; One Line Chinese  OLC
; Copyright (C) 2007  BAHCL  bahcl@hotmail.com
; OLC displays Chinese characters on the bottom line of the screen
;   in the DOS text mode
; Please read the OLC.MAN file to learn how to use.
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;
segment  .text
org      100h
         call  init

         call  Parse_Parm
         jnc   @0001
         call  do_help
         jmp   @0007
@0001:
         dec   bx
         sub   bx,cx
         shl   bx,1
         add   bx,procaddr
         call  [bx]
@0007:
         mov   ah,3Eh                     ; close hzk16f
         mov   bx,[fhandle]
         int   21h
         call  clearline
@0008:
         mov   ax,1104h                   ; restore BIOS default font
         mov   bl,0
         int   10h
@0009:
         mov   ax,4C00h
         int   21h
;
;
Parse_Parm
         xor   ax,ax
         mov   si,80h
         lodsb
         mov   di,si
         add   di,ax
         mov   [di],ah
@0010:
         lodsb
         cmp   al,0h
         jz    @0017
         cmp   al,20h
         jz    @0010
         cmp   al,'/'
         jnz   @0017
         lodsb
         mov   cx,5
         mov   bx,cx
         mov   di,parmchar
         repne scasb
         jz    @0018
@0017:
         stc
         jmp   @0019
@0018:
         clc
@0019:
         ret
;
; map bit pattern from BIG5 / GBHZ font to BIOS font
sub001
         add   ax,[crapchar]              ; unwanted symbols
         mov   bx,[big5_gbhz]             ; 15/16
         shl   bx,1                       ; 15 DBCS = 30 bytes or
         mul   bx                         ; 16 DBCS = 32 bytes
         mov   cx,dx
         mov   dx,ax
         mov   ax,4200h
         mov   bx,[fhandle]
         int   21h
         mov   ah,3Fh
         mov   cx,[big5_gbhz]
         shl   cx,1
         mov   dx,buffer_1
         int   21h
         mov   [bytesread],ax
         mov   si,buffer_1                ; transposition take place here
         mov   di,CADDRESS
         add   di,[index]
         mov   cx,[big5_gbhz]
@0100:
         lodsb
         mov   byte [di],al
         lodsb
         mov   byte [di+CHAR_HEIGHT],al
         inc   di
         loop  @0100
         cmp   word [big5_gbhz],15
         jnz   @0101
         xor   al,al
         mov   byte [di],al               ; fill the hole for 16*8 font
         mov   byte [di+CHAR_HEIGHT],al
@0101:
         mov   ax,[index]                 ; next hole address offset CAADRESS
         add   ax,32
         mov   [index],ax
         ret
;
;
sub002
         mov   dx,3DAh
@0200:   in    al,dx                      ; syncronize with vertical refresh
         test  al,8
         jnz   @0200
@0201:   in    al,dx
         test  al,8
         jz    @0201

         push  es
         mov   ax,[vid_seg]
         mov   es,ax
         mov   di,24*80*2
         mov   cx,80
         mov   ah,70h
         mov   al,0B0h
@0202:
         stosw
         inc   al
         loop  @0202
         pop   es

         mov   ax,1110h
         mov   bx,1000h
         mov   cx,256
         mov   dx,0
         mov   bp,buffer_3
         int   10h
         xor   ax,ax
         int   16h
         ret
;
; handle non DBC and Chinese style symbol
sub004
         sub   ax,ax
         mov   al,[flag_ok]
         cmp   al,20h
         jnb   @0400
         mov   al,[lastbyte]
@0400:
         mov   bx,CHAR_HEIGHT
         mul   bx
         mov   si,buffer_2
         add   si,ax
         mov   di,CADDRESS
         add   di,[index]
         mov   cx,CHAR_HEIGHT
         rep   movsb
         add   word [index],CHAR_HEIGHT
         ret
;
;
;
;
; BAHCL converted and modified the coding below
;   to assembly language from "ctool-et.c Author: Chih-Hao Tsai ctool095"
;
;
convert_big5_to_serial
         push  bp
         mov   bp,sp
         mov   ax,[bp+4]
         mov   [lastbyte],ah
         mov   [first],ah
         mov   [second],al
         mov   word [adjust],0
         mov   word [serbase],0

         cmp   byte [first],0C6h
         jne   @0300
         cmp   byte [second],0A1h
         jbe   @0300
;        mov   word [serbase],8001h
         mov   al,[first]
         sub   al,0C6h
         mov   [first],al
         mov   ah,[second]
         sub   ah,0A1h
         mov   [second],ah
         cbw
         mov   bx,9Dh
         mul   bx
         mov   bl,[second]
         add   ax,bx
         add   ax,[serbase]
         mov   [sernum],ax
         jmp   @0309
@0300:
         cmp   byte [first],0A1h          ; Chinese sytle symbols
         jb    @0301
         cmp   byte [first],0A3h
         ja    @0301
         mov   byte [flag_ok],SPACE       ; substitute with space
         jmp   @0309
;;       mov   word [serbase],8400h
;        mov   al,[first]
;        sub   al,0A1h
;        mov   [first],al
;        jmp   @0305

@0301:                                    ; most frequently used chars.
         cmp   byte [first],0A4h          ; A4..C6 1st char in stdfont.15
         jb    @0302
         cmp   byte [first],0C6h
         ja    @0302
;        mov   word [serbase],8800h
         mov   al,[first]
         sub   al,0A4h
         mov   [first],al
         jmp   @0305

@0302:                                    ; user space?
         cmp   byte [first],0C7h          ; C7..C8
         jb    @0303
         cmp   byte [first],0C8h
         ja    @0303
;        mov   word [serbase],805Fh
;        mov   al,[first]
;        sub   al,0C7h
;        mov   [first],al
;        jmp   @0305

@0303:                                    ; less frequent used chars
         cmp   byte [first],0C9h          ; C9..F9
         jb    @0304
         cmp   byte [first],0F9h
         ja    @0304
         mov   word [serbase],1519h       ; plane 2 starting address
         mov   al,[first]
         sub   al,0C9h
         mov   [first],al
         jmp   @0305

@0304:                                    ; non DBC exit point
         mov   al,[first]
         mov   byte [flag_ok],al
         mov   word [adjust],1
         xor   ax,ax
         mov   [sernum],ax
         jmp   @0309

@0305:
         cmp   byte [second],040h         ; 40..7E
         jb    @0306
         cmp   byte [second],07Eh
         ja    @0306
         mov   ah,[second]
         sub   ah,040h
         mov   [second],ah
         jmp   @0308
@0306:
         cmp   byte [second],0A1h         ; A1..FE
         jb    @0304
         cmp   byte [second],0FEh
         ja    @0304
         mov   ah,[second]
         sub   ah,0A1h
         add   ah,3Fh
         mov   [second],ah

@0308:
         mov   al,[first]
         sub   ah,ah
         mov   bx,9Dh                     ; 157
         mul   bx
         mov   bl,[second]
         add   ax,bx
         add   ax,[serbase]
         mov   [sernum],ax
         mov   byte [flag_ok],1           ; Yes, Big5
@0309:
         pop   bp
         ret   2
;
;
;
;
convert_gbhz_to_serial
         push  bp
         mov   bp,sp
         mov   ax,[bp+4]
         mov   [lastbyte],ah
         mov   [first],ah
         mov   [second],al
         mov   word [adjust],0
         mov   word [serbase],0

         cmp   byte [first],0B0h
         jb    @0310
         cmp   byte [second],0A1h
         jb    @0310
         cmp   byte [first],0F7h
         ja    @0310
         cmp   byte [second],0FEh
         ja    @0310
         mov   al,[first]
         sub   al,0B0h
         mov   [first],al
         mov   ah,[second]
         sub   ah,0A1h
         mov   [second],ah
         jmp   @0318
@0310:
         cmp   byte [first],0A1h          ; non HZ character symbols
         jb    @0314
         cmp   byte [second],0A1h
         jb    @0314
         mov   byte [flag_ok],SPACE       ; substitute with space
         jmp   @0319
@0314:                                    ; non DBC exit point
         mov   al,[first]
         mov   byte [flag_ok],al
         mov   word [adjust],1
         xor   ax,ax
         mov   [sernum],ax
         jmp   @0319
@0318:
         mov   al,[first]
         sub   ah,ah
         mov   bx,94                      ; 94 (A1..FE)
         mul   bx
         mov   bl,[second]
         add   ax,bx
         add   ax,[serbase]
         mov   [sernum],ax
         mov   byte [flag_ok],1           ; Yes, GBHZ
@0319:
         pop   bp
         ret   2
;
;
init
         mov   ax,3D00h
         mov   dx,eng_usa
         int   21h
         mov   bx,ax
         mov   ah,3Fh
         mov   cx,4096
         mov   dx,buffer_2
         int   21h
         mov   ah,3Eh
         int   21h
         mov   cx,4096 - 80*16
         mov   si,buffer_2
         mov   di,buffer_3
         rep   movsb
         mov   cx,80*16
         mov   al,0
         rep   stosb
         mov   ax,3D00h
         mov   dx,stdfont
         int   21h
         mov   [fhandle],ax
         push  es
         mov   ax,40h
         mov   es,ax
         mov   al,[es:49h]
         cmp   al,7
         jne   @1000
         mov   ax,0B000h
         mov   [vid_seg],ax
@1000:
         mov   ax,[es:4Ah]
         mov   [vid_col],ax
         mov   ax,[es:84h]
         mov   [vid_row],al
         cmp   al,[es:0F0h]
         jb    @1001
         mov   ax,[es:0F0h]
@1001:
         mov   [y_row],ax
         mov   word [es:0F0h],0
         pop   es
         call  clearline
         mov   ah,2                       ; move cursor
         mov   bh,0
         mov   dh,[vid_row]
         mov   dl,0
         int   10h
         ret
;
;
;
flipflop
         mov   ah,3Eh                     ; close stdfont/hzk16f
         mov   bx,[fhandle]
         int   21h

         cmp   byte [flip],0
         jne   @1010
         mov   word [big5_gbhz],15
         mov   word [crapchar],0
         mov   ax,3D00h
         mov   dx,stdfont
         int   21h
         call  show_big5
         jmp   @1011
@1010
         mov   word [big5_gbhz],16
         mov   word [crapchar],582h
         mov   ax,3D00h
         mov   dx,hzk16f
         int   21h
         cmp   byte [flip],1
         je    @1011
         call  show_gbhz
@1011:
         cmp   ax,5400h
         jne   @1012
         not   byte [flip]
@1012:
         ret
;
;
do_screen
         mov   ah,2
         mov   bh,0
         mov   dh,[y_row]
         mov   dl,0
         int   10h
         call  copyline
         call  flipflop
         cmp   ax,011Bh
         je    @2019
         cmp   ax,5000h
         jne   @2012
         inc   word [y_row]
         mov   bx,[vid_row]
         cmp   [y_row],bx
         jae   @2019
         jmp   do_screen
@2012:
         cmp   ax,4800h
         jne   do_screen
         dec   word [y_row]
         jns   do_screen
@2019:
         ret
;
;
;
do_cmdline
         mov   di,string
         mov   cx,80
@2020:
         lodsb
         cmp   al,0
         jz    @2021
         stosb
         loop  @2020
@2021:
         rep   stosb
         call  show_big5
         cmp   ax,5400h
         jne   @2022
         call  show_gbhz
@2022:
         ret
;
;
;
do_stdfont
         mov   word [charid],0            ; 1st Big 5 in Font library
@2030:
         mov   word [index],0
         mov   cx,40
@2031:
         mov   ax,[charid]
         push  cx
         call  sub001
         pop   cx
         inc   word [charid]
         loop  @2031
         call  sub002
         cmp   word [bytesread],0
         jz    @2039
         cmp   ax,011Bh
         je    @2039
         jmp   @2030
@2039:
         ret
;
;
do_hzk16f
         mov   byte [flip],1
         call  flipflop
         mov   word [charid],0            ; 1st HZ in Font library
@2040:
         mov   word [index],0
         mov   cx,40
@2041:
         mov   ax,[charid]
         push  cx
         call  sub001
         pop   cx
         inc   word [charid]
         loop  @2041
         call  sub002
;        xor   ax,ax
;        int   16h
         cmp   word [bytesread],0
         jz    @2049
         cmp   ax,011Bh
         je    @2049
         jmp   @2040
@2049:
         ret
;
;
;
do_help
         mov   ah,40h
         mov   bx,0
         mov   cx,helpmsgend-helpmsg
         mov   dx,helpmsg
         int   21h
         call  show_big5
         ret
;
;
;  Show a line of text
show_big5
         mov   word [crapchar],0
         mov   word [index],0
         mov   si,string
         mov   cx,[vid_col]               ; double byte 2*40
@3000:
         lodsw
         push  si
         push  cx
         xchg  ah,al
         push  ax
         call  convert_big5_to_serial
         cmp   byte [flag_ok],1
         jnz   @3001
         call  sub001
         jmp   @3002
@3001:
         call  sub004
@3002:
         pop   cx
         dec   cx
         add   cx,[adjust]                ; 1 = not a DBC
         pop   si
         sub   si,[adjust]
         loop  @3000
         call  sub002                     ; override BIOS default font
         ret
;
;
;  Show a line of text
show_gbhz
         mov   word [crapchar],582h
         mov   word [index],0
         mov   si,string
         mov   cx,[vid_col]               ; double byte 2*40
@3010:
         lodsw
         push  si
         push  cx
         xchg  ah,al
         push  ax
         call  convert_gbhz_to_serial
         cmp   byte [flag_ok],1
         jnz   @3011
         call  sub001
         jmp   @3012
@3011:
         call  sub004
@3012:
         pop   cx
         dec   cx
         add   cx,[adjust]                ; 1 = not a DBC
         pop   si
         sub   si,[adjust]
         loop  @3010
         call  sub002                     ; override BIOS default font
         ret
;
;
;
copyline
         mov     ax,[y_row]
         mov     bx,[vid_col]
         mul     bx
         shl     ax,1
         mov     si,ax
         mov     cx,[vid_col]
         push    ds
         mov     ax,[vid_seg]
         mov     ds,ax
         mov     di,string
@3021:                                    ; find begin of word
         movsb
         inc     si
         loop    @3021
         pop     ds
         ret
;
;
;
clearline
         push  es
         mov   ax,[vid_seg]
         mov   es,ax
         mov   cx,[vid_col]
         mov   ax,24*2
         mul   cx
         mov   di,ax
         mov   ax,0720h
         rep   stosw
         pop   es
         ret
;
;
;
segment  .data
SPACE       EQU   32
CHAR_HEIGHT EQU   16
LF          EQU   0Ah
vid_seg     dw    0B800h
vid_col     dw    0
vid_row     dw    0
procaddr    dw    do_screen,do_cmdline,do_stdfont,do_hzk16f,do_help
parmchar    db    "1234?",0
flip        db    0
crapchar    dw    0                       ; 1410 unwanted symbols in HZK16F
big5_gbhz   dw    15
y_row       dw    0
first       db    0
second      db    0
sernum      dw    0
serbase     dw    0
charid      dw    0
bytesread   dw    0
flag_ok     db    0                       ; 1=Chinese
lastbyte    db    0
stdfont     db    "C:\CPI\STDFONT.15",0
hzk16f      db    "C:\CPI\HZK16F",0
eng_usa     db    "C:\CPI\437.FNT",0
fhandle     dw    0
index       dw    0
adjust      dw    0
helpmsg     db 0Dh,0Ah
            db "OLC version 0.1, Copyright (C) 2007  BAHCL",0Dh,0Ah
            db "Designed and programmed by BAHCL, all rights reserved.",0Dh,0Ah
            db "OLC displays Traditional and Simplfied Chinese (BIG5,GBHZ) characters",0Dh,0Ah
            db "in DOS 80x25 video mode, with STDFONT.15, HZK16F, and",0Dh,0Ah
            db "437.FNT are kept in directory C:\CPI.",0Dh,0Ah
            db "OLC comes with ABSOLUTELY NO WARRANTY, use it at your own risk!",0Dh,0Ah
            db "This is free software, and you are welcome to redistribute it",0Dh,0Ah
            db "under the terms of the GNU General Public License version 2.",0Dh,0Ah,0Ah
            db "Syntax:",0Dh,0Ah
            db 09h, "OLC [/switch]",0Dh,0Dh,0Ah
            db "Where switch may be any of { 1..4,? }",0Dh,0Ah
            db "Read manual OLC.MAN for details.",0Dh,0Ah
            db 0Dh,0Ah
helpmsgend
string      db    'BAHCL: @椤wg ',24,25
            db    '\ų Esc  '
            db    04,04,04,'vn GNU GPL Version 2',04,04,04
buffer_1    times 32 db 0
buffer_2                      ; 437 glyphs
buffer_3    EQU   $+4096      ; 0..175 ASCII, 176..255 DBCs glyphs
CADDRESS    EQU   buffer_3+(256-80)*CHAR_HEIGHT
