
PG 1.13                                                    PG 1.13


NAME
        PG -- PaGer
        A text file viewer presented by FreeDOS

SYNOPSIS
        PG [/? | filename ...]
            /?       - displays a brief help on screen
            filename - page through filename on the PC screen
                     - filename maybe in wildcard format
            ...      - support multiple filenames
            if filename is omitted, read data from <stdin>

        or  command | PG  like
            dir /s  | PG

DESCRIPTION
        PG is a text file viewer presented by the FreeDOS.
        It browses any text file and with more advanced features.
        Read this manual carefully to get the most from PG.
        With mouse interface now!

CONTROL
        Control is intuitive, Keys defined as:

        PG Key      Meaning
        ======      =======
        Esc,Q,q     Exit program
        B,b         Toggle bit 7 on/off
        H,h         Hex view
        W,w         Wrap long lines
        Up          Scroll down 1 line
        Down,Enter  Scroll up 1 line
        Page Up     Scroll down 1 page
        Page Down   Scroll up 1 page
        Home        First page
        End         Last page
        Left        Pan view left 30 columns (1..256)
        Right       Pan view right 30 columns (1..256)
        1..5        Save current position to boomark #1..5
        Alt-1..5    Jump to saved bookmark
        6..0        Save the file and path name to filemark #1..5
        Alt-6..0    Reload the file from filemark #1..5
        Alt-D       Jump to DOS shell
        Alt-F       Enter new path and file name
        Backspace   Jump to a line as far as possible
        F1          Online help (PG.MAN this file)
        F2          Continue to search backward (Case Insensitive) (CI)
        F3          Continue to search forward  (CI)
        F4          Enter search mode and input search string (CI)
        S-F2        Continue to search backward (Case Sensitive) (CS)
        S-F3        Continue to search forward  (CS)
        F5          Save 1 screenful of text to "PG.SAV"
        F6          Change the foreground color in text window
        S-F6        Change the background color in text window
        F9          Reload files from proceeding command line argument
        F10         Reload files from following command line argument
        C-PageUp    View previous file
        C-PageDn    View next file
        User in Linux DOSEMU can press 'n' for next file and 'p' for previous


        Bookmarks #1..5
            As you're viewing a text file, press any of the numeric
            keys 1..5 (under the Function keys), for instance, pressing
            '1' to save the top position of the file you're viewing as
            bookmark #1. Later on, when you want to return to the place
            where you left bookmark #1, just press 'Alt'+'1' brings you
            back no matter how far you've been.
            Bookmarks can be updated whenever you press '1'..'5' again.

        Filemarks #1..5
            Similar to Bookmarks described above, press key '6'..'0' to
            save the path, file name, and topline as filemark #1..5.
            Filemarks can be recalled with 'Alt'+'6'..'0'
            Filemarks can be updated whenever you press '6'..'0' again.

            All filemarks are preassigned with the first file as PG
            executed. Use the left Alt key to recall.

 Backspace  Jump to line
            Prompt user to enter a line number, then jump as far
            as possible.  Line number will be the top line and
            displayed at the end of the top status line.

        F1  Show you this manual by plugin

        F2  continues case insensitive search backward for the next
            occurrence, column, line number appears at the bottom status
            line if the search is successful. It disappears if the
            search failed.

        F3  continues to search forward for the next occurrence,
            column, line number appears at the bottom status line if
            the search is successful. It disappears if the search
            failed.

        F4  Search text
            Press F4 to enter search mode, you're prompted to input
            a string. The search start from the top line of the screen,
            then to next line and so on. Follow with
            F3 to search forward (CI);
            F2 to search backward (CI);
            Shift+F3 to search forward (CS);
            Shift+F2 to search backward (CS);
            If the string is found, cursor appears, column, line number
            appears behind the search string, otherwise, nothing happens.
            Press F4 again to start a new search.

        F5  Save screen to "PG.SAV"
            When we're are viewing a file, sometimes, we want to get
            an extract from the source instead of retyping. PG helps
            us to save a screenful of text as we press the F5 key,
            a message looks "!!! copy from filename line # !!!" will
            prepend the text we want to copy, and the file "PG.SAV",
            we need to tell PG which drive to save, just once.

       S-F2 search backward case sensitive

       S-F3 search forward case sensitive

    C-PgUp  Previous file
            To view the previous file from the list.

    C-PgDn  Next file
            To view the next file from the list.

MOUSE INTERFACE
        As long as the mouse driver is found, PG and its plugins responds
        to the mouse event to perform certain tasks such as:
        1. right click at anywhere --> ESC exit;
        2. left click in upper part of screen --> page up;
        3. left click in lower part of the screen --> page down;
        4. left click at the top status line --> previous file;
        5. left click at the bottom status line --> next file;
        6. move mouse pointer over a word press F4 starts a new search;

COPYING
        This file and other related programs stored in PG113.ZIP are
        distributed under the terms of the GNU General Public License.
        See the file COPYING for details. And read the author's
        "Legal stuff" declared in the comments of the program
        source file.


What's new is version 1.13
        - support multiple command line arguments
        - quick access to files in command line arguments
        - input new additional file name for viewing
        - add 5 filemarks
        - changeable color foreground/background in text windows
        - search text with mouse
        - show column, line at bottom status line after a successful search
        - plugins enhanced
        - add support COLOR,GNU compile directives
        - Linux DOSEMU environment improved support


Features
        - view very large file (1024*1024 lines);
        - multiple files viewing (256 in 1 directory);
        - top line is restored as viewing multiple files;
        - forward / reverse search (both sensitive and insensitive)
        - save screens to a save file;
        - view panning (max. 256 columns);
        - online help;
        - wrap long line;
        - hex view;
        - piping;
        - 5 bookmarks;
        - 5 filemarks;
        - support multiple arguments in command line
        - support user input extra arguments
        - keeps all filenames viewed
        - bit 7 on / off;
        - jump to line;
        - jump to DOS shell;
        - exclude file formats considered binary;
        - cursor appears at the line and shows the position if a string is found;
        - simple user interface;
        - mouse interface;
        - \x8 filtering;

        Read the news file for development history / technical details


Portability
        Operating Systems:
           1. Linux DOSEMU 1.2.0
           2. FreeDOS native mode
           3. M$DOS Windows box
           4. M$DOS native mode
        Hardwares:
           VGA, CGA, MONO


PACKAGE (version 1.13) PG113.ZIP
        BIN\PG.MAN            - Manual (this file)
        BIN\PG.EXE            - the program
        BIN\SVHEX.COM         - Plugin binary (hex)
        BIN\SVTXT.COM         - Plugin binary (text)
        SOURCE\PG\PG.C        - C source program
        SOURCE\PG\PG.H        - C header
        SOURCE\PG\PGASM.ASM   - assembly subroutines
        SOURCE\PG\PG.MAK      - make file for Turbo C 2.01
        SOURCE\PG\SVHEX.ASM   - Plugin source file (hex)
        SOURCE\PG\SVTXT.ASM   - Plugin source file (text)
        DOC\PG\NEWS           - anouncement
        DOC\PG\TO_DO          - job list
        DOC\PG\COPYING        - GNU GPL copyright
        DOC\PG.MAN            - Manual (this file)


INSTALL PG (version 1.13)

        To compile PG you need:
        1. Borland Turbo C 2.01
        2. Nasm 0.98.xx

        Type:
            tcc  -c pg.c
            nasm -f obj pgasm.asm -o pgasm.obj
            tlink lib\c0s pg pgasm,pg,,lib\cs
            nasm -f bin svhex.asm -o svhex.com
            nasm -f bin svtxt.asm -o svtxt.com

        This will generate the PG.EXE program and plugins.

        or
            d:\>make -fpg.mak -Dtc=Turbo_C_Directory

        Should you get any error, check if the path is correct
        in "PG.MAK". Keep plugins in your path, and PG.MAN in
        the same directory as PG.EXE.

        Also messages from previous maintainer were outdated,
        noted that:
        If you like default color, try
            d:\>make -fpg.mak -DCOLOR -Dtc=Turbo_C_Directory
        for GNU notice in command line help, try
            d:\>make -fpg.mak -DGNU -Dtc=Turbo_C_Directory


Programming Resources

        PG 1.13 -- Turbo C with Nasm
          Borland Turbo C 2.01
          NASM 0.98
          Insight 1.10

        Turbo C 2.01 is available at the Borland Software Museum.
          http://community.borland.com/museum/

        Nasm 0.98.xx is available at
          http://nasm.sourceforge.net/

        Insight 1.10
          http://www.freedos.org/


Limitations
        PLUGINS cannot handle piped file size > 64K


About Plugins
        PG employs plugins to achieve extra capablities such as
        on line help, long line wrapping, hexidecimal view.
        Plugins are separate programs 1.4k each, tiny, simple
        yet support piping. Plugins are invoked with the F1,
        h,H,w,W key, and exit with exactly the same key. Plugins
        synchronize the position of the file with PG. Navigates
        with Up, Down, Page Up, Page Down, Home, End keys and
        exit with ESC. Plugins handles a disk file of any size,
        remember the starting position and recall is possible.
        Recall with Alt-1. Keep plugins together with PG.EXE
        and PG.MAN in a %PATH% directory.


Author  Bill Weinmen
        E-mail : wew@bearnet.com
        BAHCL (plugins)

Maintainer  BAHCL
        version : 1.13 ... 1.02
        E-mail  :


Messages from BAHCL:

        PG is a full-fledged text file viewer now. With all new
        features, PG just looks the same, but it is impressive if
        you give it a shot. High performance, small footprint,
        numerous useful features, minimun system resources, PG
        has all the power, to rival similar softwares in the market,
        "EVEN" the M$ realm. Yet PG is FREE and OPEN SOURCE that
        serves as a great sample to beginner programmer.

        Read the NEWS file for development history.

        I'd like to express my thanks to the authors of HELPPC,
        INSIGHT, TURBO C, NASM, IBM Tiny Editor. Without their
        contribution, PG will not be possible.


BAHCL



Messages from previous PG maintainer(s):  Outdated!

============================================================
I have made a few changes to the source, but didn't (technically)
delete anything.  I removed the verbose GNU License statement in the
usage() function.  To put it back in, add this to the code:

   #define SHOW_GNU_COPYING

or, compile like this:

  cc pg.c -fop SHOW_GNU_COPYING=1

============================================================
I have set the default behavior of the program to operate in
mono-mode only.  This is a color scheme that should work well on all
monitors, even a mono display.  To build using Bill's original
colors, add this to the code:

   #define USE_COLOR_MODE

or, compile like this:

  cc pg.c -fop USE_COLOR_MODE=1



============================================================
(Jim Hall, jhall1@isd.net)


