/*
*   This file is part of program PG v1.03 that is under the
*   licence of GNU GPL version 2.
*
*   Assembly subroutines callable by pg.c
*   Originally, these routines reside in pg.c
*     to extract here to make pg.c easier to debug
*/

/* move cursor to specific location */
MOVE(row,col)
{
    asm
    {
        mov     ax,6[bp]                ; C parameter order
        mov     dh,al                   ; row
        mov     ax,4[bp]
        mov     dl,al                   ; column
        mov     ah,02
        int     10h
    }
}
/* get a string at the cursor position */
GETSTR(string)
{
    asm
    {
        mov     ah,0Ah                  ; get a string into buffer
        mov     dx,4[bp]
        int     21h

        mov     si,dx                   ; make a string null terminated
        inc     si                      ; actual number of chars entered
        lodsb
        cbw
        add     si,ax                   ; get end of string position
        xor     ax,ax
        mov     [si],al                 ; null terminated
    }
}

cls()
{
  asm {
    push es
    mov ax, BIOS_DATA_SEG
    mov es, ax
    xor ax, ax
    mov [es:CURSOR], ax   ; home the cursor
    mov di, ax            ; zero origin for regen
    mov cx, _RegenSize
    mov ax, _VideoRegen
    mov es, ax
    mov ah, _curatt
    mov al, 20h           ; ' '
    rep stosw
    pop es
  }
}

scroll_down(top, bottom)
{
  asm {
    push ds
    std                   ; backwards for movsw

    ; number of words to move = (bottom - top + 1) * DispCols

    xor ax, ax
    mov al, 4[bp]         ; bottom
    mov bl, 6[bp]         ; top
    sub al, bl
    inc ax
    mov bx, _DispCols
    mul bl
    mov cx, ax            ; move size -> cx

    ; dest addr = (bottom * DispCols) + DispCols - 1) * 2 

    xor ah, ah
    mov al, 4[bp]
    inc ax
    mov bx, _DispCols
    push bx
    mul bl
    pop bx
    add ax, bx
    dec ax
    shl ax, 1
    mov di, ax

    ; source addr = source - (DispCols * 2)

    push ax
    mov ax, _DispCols
    shl ax, 1
    mov bx, ax
    pop ax
    sub ax, bx
    mov si, ax

    mov bx, _VideoRegen
    mov es, bx
    mov ds, bx
    rep movsw
    cld                   ; restore direction
    pop ds
  }
}  

scroll_up(top, bottom)
{
  asm {
    push ds
    cld

    ; number of words to move = (bottom - top + 1) * DispCols

    xor ax, ax
    mov al, 4[bp]         ; bottom
    mov bl, 6[bp]         ; top
    sub al, bl
    inc ax
    mov bx, _DispCols
    mul bl
    mov cx, ax            ; move size -> cx

    ; dest addr = top * 2 * DispCols 

    xor ah, ah
    mov al, 6[bp]
    shl ax, 1
    mov bx, _DispCols
    mul bl
    mov di, ax

    ; source addr = source + (DispCols * 2)

    push ax
    mov ax, _DispCols
    shl ax, 1
    mov bx, ax
    pop ax
    add ax, bx
    mov si, ax

    mov bx, _VideoRegen
    mov es, bx
    mov ds, bx
    rep movsw
    pop ds
  }
}

vidchar(vidrow, vidcol, vidchar, vidattr)
{
  asm {
    push es
    mov ax, BIOS_DATA_SEG
    mov es, ax
    mov al, 8[bp]        ; col
    mov ah, 10[bp]       ; row
    mov [es:CURSOR], ax
    push ax
    mov al, ah
    xor ah, ah
    mov bx, _DispCols    ; offset = vidrow * DispCols + vidrow
    mul bl
    pop bx
    xor bh, bh           ; add in the col
    add ax, bx
    shl ax, 1            ; * 2 for word based
    mov di, ax           ; zero origin for regen
    mov ax, _VideoRegen
    mov es, ax
    mov ah, 4[bp]        ; attr
    mov al, 6[bp]        ; char
    stosw
    pop es
  } 
}

clreol(row, col)
{
  asm {
    push es
    mov ax, BIOS_DATA_SEG
    mov es, ax
    cld

    ; num words = DispCols - col

    mov ax, _DispCols
    mov bx, 4[bp]        ; col
    cmp ax, bx           ; bail if DispCols <= col
    jle attahere
    push bx              ; use for di calc
    sub ax, bx
    mov cx, ax

    ; di = ((row * DispCols) + col) * 2

    mov ax, 6[bp]        ; row
    mov bx, _DispCols
    cmp ax, bx
    mul bl
    pop bx               ; col
    add ax, bx
    shl ax, 1
    mov di, ax
  
    mov ax, _VideoRegen
    mov es, ax
    mov ah, _curatt
    mov al, ' '
    rep stosw
  attahere:  
    pop es
  } 
}
