/* $RCSfile: FILE95.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	Rename file

   $Log: FILE95.C $
   Revision 1.3  2005/11/21 07:03:21  blairdude
   add: remove95
   add: _chmod95
   add: dostowin95
   add: win95todos
   change: filename from REN95 to FILE95

   Revision 1.2  2000/01/11 09:34:39  ska
   add: support Turbo C v2.01

   Revision 1.1  2000/01/11 09:10:09  ska
   Auto Check-in

*/

#include <assert.h>
#include <dos.h>
#include <stdarg.h>
#include <errno.h>
#include "io95.h"
#include "io95_loc.h"

/*#ifndef lint
static char const rcsid[] = 
	"$Id: REN95.C 1.2 2000/01/11 09:34:39 ska Exp ska $";
#endif*/

void win95todos(long filetime, unsigned short *time, unsigned short *date)
{
	union REGS r;
	struct SREGS s;
	r.x.ax = 0x71A7;
	r.h.bl = 0;
	s.ds = FP_SEG(filetime);
	r.x.si = FP_OFF(filetime);
	intdosx(&r, &r, &s);
	if(r.x.cflag & 1) return;
	time = &r.x.cx;
	date = &r.x.dx;
}

long dostowin95(unsigned short time, unsigned short date)
{
	union REGS r;
	struct SREGS s;
	long filetime;
	r.x.ax = 0x71A7;
	r.h.bl = 0x01;
	r.x.cx = time;
	r.x.dx = date;
	s.es = FP_SEG(filetime);
	r.x.di = FP_OFF(filetime);
	intdosx(&r, &r, &s);
	return (r.x.cflag & 1) ? (errno = r.x.ax) : filetime;
}

int _chmod95(const char *path, int func, ...)
{
	va_list list;
	int attributes;
	union REGS r;
	struct SREGS s;
	assert(path);
	s.ds = FP_SEG(path);
	r.x.dx = FP_OFF(path);
	r.h.bl = func;
	if(func)
	{
		va_start(list, func);
		attributes = va_arg(list, int);
		r.x.cx = attributes;
		return callDosandWin95(0x7143, 0x4301, &r, &s);
	}
	callDosandWin95(0x7143, 0x4300, &r, &s);
	return (r.x.cflag & 1) ? r.x.ax : r.x.cx;
}

int remove95(const char *path)
{
	DOSREGPACK r;
	assert(path);
	r.r_ds = FP_SEG(path);
	r.r_dx = FP_OFF(path);
	r.r_si = 0;
	return callWin95(0x56, &r);
}

int rename95(const char * const oldnam, const char * const newnam)
{	DOSREGPACK r;

	assert(oldnam);
	assert(newnam);
	r.r_ds = FP_SEG(oldnam);
	r.r_dx = FP_OFF(oldnam);
	r.r_es = FP_SEG(newnam);
	r.r_di = FP_OFF(newnam);
	r.r_si = 0;
	r.r_cx = 0;
	return callWin95(0x56, &r);
}
