{**********************************************************************
** PasExt 1.0.0                                                      **
** ----------------------------------------------------------------- **
** Standard extensions to Pascal language                            **
** ----------------------------------------------------------------- **
** Cronos project, 1992,1999-2000                                    **
** This unit is ofer without ANY GUARANTEE, under the terms of the   **
** GNU-GPL License 2.0 or later.                                     **
** ----------------------------------------------------------------- **
** Original author: A. Santamara Merino  (v. 1.0.0)                 **
** Modifications: <NONE>                                             **
**********************************************************************}
{ COMPATIBILITY:
   - TurboPascal 7.0   (*)
   - FreePascal  0.99.14a

-------
Uses CRT Unit: may give RTE 200 if your TP hasn't been patched
}

UNIT PasExt;

{$X+  Extended syntax ON}

INTERFACE

TYPE

    PtrRec = RECORD
                   ofs: word;
                   seg: word
             END;
    {Given a POINTER or LONGINT, a TypeCast with this record will give you
     access to its segment and offset}

    SetOfByte = set of byte;
    {This type allows you to pass sets of bytes as parameters to procedures
    and functions}


VAR
   ExtKey: char;
   {When you read a key with WaitKey procedure, if WaitKey=#0 it means that
   the user has pressed an extended code key, whose code is stored here}


PROCEDURE Pause;          {Stops until user presses a key}
PROCEDURE Beep;           {Makes the PC Beep}
FUNCTION  WaitKey: char;  {Stops until user presses a key, and returns its
                           code. If #0, extended code in ExtKey}
FUNCTION  FileExist (EFName : String): boolean;
                          {Fastest verification of FIle existence}
PROCEDURE CLI;            {Disables Interrupts}
PROCEDURE STI;            {Enables  interrupts}



IMPLEMENTATION

USES
    Crt, DOS;

PROCEDURE Pause;
BEGIN
     REPEAT UNTIL KeyPressed;
     IF ReadKey=#0 THEN ReadKey;
END;

PROCEDURE Beep;
BEGIN
     Write (#7)
END;


FUNCTION FileExist (EFName : String): boolean;
BEGIN
     FileExist := fSearch (EFName, '') <> '';
END;


FUNCTION WaitKey: char;
BEGIN
     REPEAT UNTIL Keypressed;
     Waitkey := ReadKey;
     IF WaitKey=#0 THEN ExtKey := ReadKey
END;


PROCEDURE CLI; assembler;
ASM
   CLI;
END;

PROCEDURE STI; assembler;
ASM
   STI;
END;




BEGIN
END.
