/**********************************************************************
** RegFS 0.1.0                                                       **
** ----------------------------------------------------------------- **
** Acces to register on text files                                   **
** ----------------------------------------------------------------- **
** Cronos, 1992,1999-2000                                            **
** This library is distributed with NO WARRANTY, under the terms of  **
** the GNU-GPL (ver 2.0 or later) license                            **
** ----------------------------------------------------------------- **
** Original author: Aitor Santamara Merino (0.1.0)                  **
** Modifications: <NONE>                                             **
**********************************************************************/

///////////// I  M  P  L  E  M  E  N  T  A  T  I  O  N  ////////////////

// I N C L U D E S /////////////////////////////////////////////////////

#include<stdio.h>
#include<string.h>
#include<stdlib.h>
// #include"cext.h"    (already included in .h)
#include"regfs.h"


// G L O B A L S ////////////////////////////////////////////////////////////

FILE *f;
BYTE RegFSerr = 0;


// F U N C T I O N S ////////////////////////////////////////////////////////

/* Reads a valid line from the input file*/

char *getvalidline ( char *retstr )
{
	do
	{
		fgets (retstr, 255, f);
	} while (retstr[0]==commentchar);  // avoid comments

	retstr [ strlen(retstr)-1 ] = 0;
	return retstr;
}


///////////////////////////////////////////////////////////////////////////

/* Fordwards the text file to find the correct section name*/
BYTE searchsec (char *secname)
{
    char lsecname [256] = "[";
    char usestr[256] = "";

    // Create [secname]
    strcat (strcat (lsecname, secname), "]");

    // Scan for section
    while ( strcmp(lsecname,usestr) && !feof(f))
	 strcpy (usestr, getvalidline (usestr));

    // Compare error
    RegFSerr = !!feof(f);
    return RegFSerr;
}

///////////////////////////////////////////////////////////////////////////


/* tests matching of a variable*/
BOOL matchvar (char *strs, char*vname)
{
   char *usestr;
   BOOL res;

   // first we calculate
   usestr = strtok (strdup (strs), "=");
   res = ! strcmp (usestr, vname);
   free (usestr);    /* then we free */

   return res;
}

///////////////////////////////////////////////////////////////////////////


/* Obtains the value of a variable*/
char *getlabel (char *dest, char *fname, char *secname, char *varname, BYTE ocurrence)
{
    char usestr[256] = "";

    // Try to open the file
    if (! (RegFSerr = 3* ((f = fopen (fname, "rt")) == NULL) ))
    {
	// seek the correct section
	searchsec (secname);

	// do the search till some termination event
	while  (     (!matchvar (usestr,varname)  || ocurrence )
		   &&  (usestr[0] != '[')
		   &&  !feof (f)             )
	{
		strcpy (usestr, getvalidline (usestr));
		if (matchvar (usestr,varname))
			ocurrence--;
	}
	fclose (f);

	//check the termination event
	if  ( ! (RegFSerr = 2 * ( (usestr[0]=='[') ||
					  (feof(f) && ocurrence) ||
					  (strchr(usestr,'=')==NULL)  )
		  ))
	{
	   strcpy (dest, strchr (usestr, '=')+1);
	   return dest;
	}
	else
	    return NULL;
    }
    else
	return NULL;
}

///////////////////////////////////////////////////////////////////////////


/* obtains a variable within a section */
char *getvarname (char *dest, char *fname, char *secname, BYTE ocurrence)
{
    char usestr[256]="";

    // Try to open the file
    if (! (RegFSerr = 3* ((f = fopen (fname, "rt")) == NULL) ))
    {
	// seek the correct section
	searchsec (secname);

	// do the search till some termination event
	while  (     ocurrence
		   &&  (usestr[0] != '[')
		   &&  !feof (f)          )
	{
		strcpy (usestr, "");
		while ( !feof(f) && !usestr[0])
		    strcpy (usestr, getvalidline (usestr));
		ocurrence--;
	}
	fclose (f);

	// check the termination event
	if ( (usestr[0]=='[')  ||  (feof(f) && ocurrence  )  || !usestr[0])
		dest = "#";  //no more vars
	else
	{
		strcpy (dest, usestr);
		if ( strchr (dest, '=') != NULL)
			strtok (dest, "=");
	}
	return dest;
    }
    else
	return NULL;
}


///////////////////////////////////////////////////////////////////////////


/* returns the error code of last operation*/
BYTE RegFSErr()
{
	BYTE a;
	a = RegFSerr;
	RegFSerr = 0;
	return a;
}


/////////////  E  N  D  ///////////////////////////////////////////////////

