/**********************************************************************
** LinkLib 0.9                                                       **
** ----------------------------------------------------------------- **
** Interface to deal with FreeDOS symbolic links                     **
** ----------------------------------------------------------------- **
** Cronos, 1992,1999-2000                                            **
** This library is distributed with NO WARRANTY, under the terms of  **
** the GNU-GPL (ver 2.0 or later) license                            **
** ----------------------------------------------------------------- **
** Original author: Aitor Santamara Merino (0.9)                    **
** Modifications: <NONE>                                             **
**********************************************************************/


///////////// I  M  P  L  E  M  E  N  T  A  T  I  O  N  ////////////////

// I N C L U D E S /////////////////////////////////////////////////////
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<dir.h>
//#include"cext.h"  already included in .H
#include"regfs.h"
#include"linklib.h"


// D E F I N E S ///////////////////////////////////////////////////////
#define lext ".lnk"


// F U N C T I O N S ////////////////////////////////////////////////////////



/* checks if fname or fname.<lext> exist */
char *truefname (char *fname)
{
	FILE *f;

	if  ((f=fopen(fname, "r")) == NULL)
	{
		strcat (fname, lext);
		if  ((f = fopen(fname, "r")) == NULL)
			return NULL;
		else
			fclose (f);
	}
	else
		fclose (f);
	return fname;
}



/* checks if fname or fname.<lext> is a link */
BOOL checklink (char *fname)
{
	// error when finding file
	if (truefname(fname) == NULL)
		return 0;

	//strstr strcpy
	return !strcmp (lext, strlwr (fname+strlen(fname)-4));
}


/* removes initial and last CHARACTER, supposed to be " */
char *noquotes (char *p)
{
	char *s;
	/* remove last char */
	for (s=p; *(s+1);s++);
	*s = 0;
	/* remove first char */
	for (s=p; *s; s++)
		*s = *(s+1);
      return p;
}


/* gets the starting directory of the link */
char *linkgetdir (char *lname, char *retdir)
{
	if (checklink (lname))
	{
		getlabel (retdir, lname, "definition", "workpath", 1);
		if (retdir==NULL) return NULL;
		return (noquotes(retdir));
	}
	else
		return NULL;
}

/* gets the target of a link */
char *linkgettarget (char *lname, char *rettarg)
{
	char *s;
	if (checklink (lname))
	{
		getlabel (rettarg, lname, "definition", "link", 1);
		if (rettarg==NULL) return NULL;
		return (noquotes(rettarg));
	}
	else
		return NULL;
}

/* gets the icon32 of a link */
char *linkgeticon32 (char *lname, char *reticon)
{
	char *s;
	if (checklink (lname))
	{
		getlabel (reticon, lname, "definition", "icon32", 1);
		if (reticon==NULL) return NULL;
		return (noquotes(reticon));
	}
	else
		return NULL;
}



/* opens a link */
int  startlink (char *lname)
{
	char sd[255], fn[255];


	strcpy (sd, lname);
	while (checklink (sd))
	{
		linkgetdir (lname, sd);
		if (sd != NULL)
			chdir (sd);
		linkgettarget (lname, fn);
	}



	// Code to be REPLACED in the future by using "START "+fn
	if (fn != NULL)
		return system (fn);
	else
		return 1;
}


/* creates a link with the information specified */
BOOL createlink (char *lname, char *target, char *startdir, char *icon32)
{
	FILE *f;
	strcat (lname, lext);
	if ((f=fopen(lname,"wt"))==NULL)
		return FALSE;  //error

	//write the file
	fprintf (f, "[definition]\n");
	fprintf (f, "link=\"%s\"\n", target);
	if (startdir != NULL)
		fprintf (f, "workpath=\"%s\"\n", startdir);
	if (icon32 != NULL)
		fprintf (f, "icon32=\"%s\"\n", icon32);
	fclose(f);
	return TRUE;
}

