/**********************************************************************
** RegFS 0.1.0                                                       **
** ----------------------------------------------------------------- **
** Acces to register on text files                                   **
** ----------------------------------------------------------------- **
** Cronos, 1992,1999-2000                                            **
** This library is distributed with NO WARRANTY, under the terms of  **
** the GNU-GPL (ver 2.0 or later) license                            **
** ----------------------------------------------------------------- **
** Original author: Aitor Santamara Merino (0.1.0)                  **
** Modifications: <NONE>                                             **
**********************************************************************/

///////////// I  N  T  E  R  F  A  C  E  ///////////////////////////////

#ifndef _RegFS
#define _RegFS

/* common extensions to C language */
#include "cext.h"

/* character to be used as comments delimiter */
#define commentchar ';'

/********************************************************************
** GetLabel: Reads the value of a variable in a INI-like file      **
** --------------------------------------------------------------- **
** INPUT:  dest:    previously allocated string to be filled in    **
**	     fname:   name of the file where the variable is		 **
**	     secname: the name of the section in the ini file, 	 **
**			  without brackets					 **
**	     varname: name of the variable					 **
**	     ocurrence: number of ocurrence of the variable		 **
** OUTPUT: dest is filled with the label string			       **
********************************************************************/
char *getlabel (char *dest, char *fname, char *secname, char *varname, BYTE ocurrence);



/********************************************************************
** GetVarName: Lists variables in a section                        **
** --------------------------------------------------------------- **
** INPUT:  dest:    previously allocated string to be filled in    **
**	     fname:   name of the file where you look for variables  **
**	     secname: the name of the section in the ini file, 	 **
**			  without brackets					 **
**	     ocurrence: number of variable to be found     		 **
** OUTPUT: dest is filled with the var name				 **
********************************************************************/
char *getvarname (char *dest, char *fname, char *secname, BYTE ocurrence);

/********************************************************************
** RegFSErr: status of last RegFS operation                        **
** --------------------------------------------------------------- **
** OUTPUT: error code of the operation					 **
********************************************************************/
BYTE RegFSErr();

/************ Error code table:
1: Section not found
2: Variable not found or syntax error in variable format
3: Unable to open file
*************/

#endif