/**********************************************************************
** LinkLib 0.9                                                       **
** ----------------------------------------------------------------- **
** Interface to deal with FreeDOS symbolic links                     **
** ----------------------------------------------------------------- **
** Cronos, 1992,1999-2000                                            **
** This library is distributed with NO WARRANTY, under the terms of  **
** the GNU-GPL (ver 2.0 or later) license                            **
** ----------------------------------------------------------------- **
** Original author: Aitor Santamara Merino (0.9)                    **
** Modifications: <NONE>                                             **
**********************************************************************/

///////////// I  N  T  E  R  F  A  C  E  ///////////////////////////////

#ifndef _linklib
#define _linklib

#include "cext.h"

/********************************************************************
** checklink: checks if a fname or fname.vlk is a valid link       **
** --------------------------------------------------------------- **
** INPUT:  fname:   filename to be tested (with ot without .ext) 	 **
** OUTPUT: TRUE if it is really a link, FALSE otherwise		 **
********************************************************************/
BOOL checklink (char *fname);


/********************************************************************
** linkgetdir: gets the starting dir for the target of the link    **
** --------------------------------------------------------------- **
** INPUT:  lname:   link name                                    	 **
**	     retdir:  prev. allocated string to get the dir		 **
** OUTPUT: a pointer to retdir, which contains the dir             **
********************************************************************/
char *linkgetdir (char *lname, char *retdir);


/********************************************************************
** linkgettarget: gets the file pointed by the symbolic link       **
** --------------------------------------------------------------- **
** INPUT:  lname:   link name                                    	 **
**	     rettarg: prev. allocated string to get the target	 **
** OUTPUT: a pointer to rettarg, which contains the target    	 **
********************************************************************/
char *linkgettarget (char *lname, char *rettarg);


/********************************************************************
** linkgeticon32: gets the icon32 for the symbolic link            **
** --------------------------------------------------------------- **
** INPUT:  lname:   link name                                    	 **
**	     reticon: prev. allocated string to get the iconname	 **
** OUTPUT: a pointer to reticon, which contains the iconname  	 **
********************************************************************/
char *linkgeticon32 (char *lname, char *reticon);


/********************************************************************
** startlink:  EXECUTES a link                                     **
** --------------------------------------------------------------- **
** INPUT:  lname:   link name                                    	 **
** OUTPUT: 1: link error; otherwise, SYSTEM result            	 **
** NOTES: In future versions, START will be hardcoded			 **
********************************************************************/
int  startlink (char *lname);


/********************************************************************
** createlink:  creates a new link                                 **
** --------------------------------------------------------------- **
** INPUT:  lname: new link name                                    **
**	     target: complete or relative path to the pointed file   **
**         startdir: the starting dir for the link (can be NULL)   **
**         icon32: 32-pixel icon (can be NULL)   			 **
** OUTPUT: success status                                     	 **
** NOTES: the existence of the target file is NOT checked	       **
********************************************************************/
BOOL createlink (char *lname, char *target, char *startdir, char *icon32);


#endif
