/* DZKEY.C--
 * Keyboard map for doszip.
 */
#include <conio.h>

#ifdef __BORLANDC__
 #define MK_FP(s,o) ((void _seg *)(s)+(void near *)(o))
#else
 #define MK_FP(s,o) (((unsigned short)(s)):>((void __near *)(o)))
#endif

#define YPOS		3
#define XPOS		60
#define A_INFO	  	0x1B

char *cp_keymap[];
/******** Resource begin IDKeymap *
	{ 0x401C,   1,   0, { 3, 1,73,23} },
	{ 0x0A00,   0, 'E', {59,21,10, 1} },
********* Resource data  *******************/
static	WORD IDKeymap_RC[] = {
	0x0DB3, // Alloc size
	0x401C,0x0001,0x0103,0x1749,0x0A00,0x4500,0x153B,0x010A,
	0x49F0,0xF070,0x1762,0x04F0,0x171F,0x04F0,0xF01F,0x1706,
	0x10F0,0xF01B,0x174B,0x0AF0,0xF01F,0x1708,0x10F0,0x171A,
	0x14F0,0xF01B,0x1712,0x09F0,0xF01F,0x1719,0x15F0,0xF01F,
	0x1712,0x04F0,0xF01F,0x171F,0x14F0,0xF01F,0x1712,0x03F0,
	0xF01F,0x1746,0x0AF0,0xF01F,0x1708,0x0EF0,0xF01A,0x1703,
	0x14F0,0xF01B,0x1712,0x07F0,0xF01F,0x171C,0x14F0,0xF01B,
	0x1712,0x08F0,0xF01F,0x171B,0x14F0,0xF01F,0x1712,0x0BF0,
	0xF01F,0x173E,0x08F0,0xF01F,0x170A,0x18F0,0xF01A,0x171F,
	0x07F0,0xF01F,0x171D,0x13F0,0xF01B,0x1729,0x04F0,0x171F,
	0x04F0,0x171F,0x16F0,0xF01B,0x1712,0x0AF0,0xF01F,0x170D,
	0x04F0,0x171F,0x04F0,0x171F,0x16F0,0xF01B,0x1712,0x09F0,
	0xF01F,0x170E,0x04F0,0x171F,0x04F0,0x171F,0x16F0,0xF01B,
	0x1712,0x06F0,0xF01F,0x1711,0x04F0,0x171F,0x04F0,0x171F,
	0x16F0,0xF01B,0x1712,0x07F0,0xF01F,0x1742,0x09F0,0xF01F,
	0x170A,0x0AF0,0xF01A,0x1705,0x04F0,0xF01B,0x1736,0x09F0,
	0xF01A,0x1706,0x04F0,0x171B,0xF017,0x1B04,0x67F0,0x7017,
	0x7F70,0x07F0,0x1070,0x3FF0,0xF017,0x100A,0x03F0,0xF017,
	0x2016,0x6156,0x756C,0x7365,0x6620,0x726F,0x6B20,0x7965,
	0x6F62,0x7261,0x2064,0x6373,0x6E61,0x6320,0x646F,0xF065,
	0x2062,0x6853,0x6669,0x2074,0x7473,0x7461,0x7375,0x7720,
	0x726F,0x2064,0x7461,0x5B20,0x3030,0x3034,0x303A,0x3130,
	0x5D37,0xF03A,0x2004,0x10F0,0xF030,0x2039,0x0FF0,0xC0B3,
	0x20C4,0x6853,0x6669,0x5274,0x6769,0x7468,0x08F0,0x4320,
	0x7275,0x6572,0x746E,0x6B20,0x7965,0x7270,0x7365,0x3A73,
	0x14F0,0xF020,0xB30E,0xC4C0,0x20C4,0x6853,0x6669,0x4C74,
	0x6665,0xF074,0x2009,0x6544,0x6373,0x6972,0x7470,0x6F69,
	0x3A6E,0x19F0,0xF020,0xB30D,0xF0C0,0xC403,0x4320,0x7274,
	0xF06C,0x2033,0x0CF0,0xC0B3,0x04F0,0x20C4,0x6C41,0xF074,
	0x2034,0x0BF0,0xC0B3,0x05F0,0x20C4,0x6353,0x6F72,0x6C6C,
	0x6F4C,0x6B63,0x08F0,0x4220,0x4F49,0x2053,0x6353,0x6E61,
	0x6320,0x646F,0x3A65,0x16F0,0xF020,0xB30A,0xF0C0,0xC406,
	0x4E20,0x6D75,0x6F4C,0x6B63,0x0BF0,0x4120,0x6373,0x6969,
	0x6320,0x6168,0x6172,0x7463,0x7265,0xF03A,0x2015,0x09F0,
	0xC0B3,0x07F0,0x20C4,0x6143,0x7370,0x6F4C,0x6B63,0x0AF0,
	0x4420,0x7365,0x7263,0x7069,0x6974,0x6E6F,0xF03A,0x2019,
	0x08F0,0xC0B3,0x08F0,0x20C4,0x6E49,0x6573,0x7472,0x7453,
	0x7461,0xF065,0x202C,0x07F0,0xC0B3,0x09F0,0x20C4,0x7443,
	0x6C72,0x654C,0x7466,0x0AF0,0x4B20,0x7965,0x6F62,0x7261,
	0x2064,0x6963,0x6372,0x6C75,0x7261,0x6220,0x6675,0x6566,
	0x3A72,0x0CF0,0xF020,0xB306,0xF0C0,0xC40A,0x4120,0x746C,
	0x654C,0x7466,0x0DF0,0x4120,0x6373,0x6969,0x6320,0x6168,
	0x6172,0x7463,0x7265,0xF03A,0x2013,0x05F0,0xC0B3,0x0BF0,
	0x20C4,0xF03F,0x2015,0x305B,0x3430,0x3A30,0x3030,0x4531,
	0xF05D,0x2016,0x04F0,0xC0B3,0x0CF0,0x20C4,0x7443,0x6C72,
	0x754E,0x4B6D,0x7965,0x0CF0,0x5B20,0x3030,0x3034,0x303A,
	0x3230,0x5D36,0x16F0,0xF020,0xB303,0xF0C0,0xC40D,0x5320,
	0x7263,0x6C6F,0x4B6C,0x7965,0x0DF0,0x5B20,0x3030,0x3034,
	0x303A,0x3230,0x5D45,0x16F0,0xB320,0xC0B3,0x0EF0,0x20C4,
	0x754E,0x4B6D,0x7965,0x10F0,0x5B20,0x3030,0x3034,0x303A,
	0x3330,0x5D36,0x16F0,0xB320,0xF0C0,0xC40F,0x4320,0x7061,
	0x4B73,0x7965,0x30F0,0xC020,0x10F0,0x20C4,0x6E49,0x6573,
	0x7472,0x654B,0xF079,0x200A,0x6946,0x7372,0x2074,0x7266,
	0x6565,0xF03A,0x203E,0x654E,0x7478,0x6320,0x6168,0x3A72,
	0x78F0,0x4520,0x6373,0x7061,0x2065,0xDC20,0x3FF0,0xF020,
	0xDF0A,0x03F0,0x1F20,
}; //	888 byte
WORD *	IDD_IDKeymap = IDKeymap_RC;
/******** Resource end   IDKeymap */

void pbuttset(int x, int y, int col)
{
	gotoxy(x + 2, y);
	scputc(x, y, 0, 1, 16);
	scputc(x + col - 1, y, 0, 1, 17);
}

void pbuttclr(int x, int y, int col)
{
	scputc(x, y, 0, 1, ' ');
	scputc(x + col - 1, y, 0, 1, ' ');
}

void pbuttms(int x, int y, int col)
{
	pbuttset(x, y, col);
	while (mousep())
		;
	pbuttclr(x, y, col);
}

void putdata(int);

int main(void)
{
	int key;
	int old;
	int end;
	COBJ cr;
	DOBJ *dialog;

	end = 0;
	if ((dialog = rsopen(IDD_IDKeymap)) == 0)
		return 1;
	getcursor(&cr);
	cursoroff();
	dlshow(dialog);
	putdata(0x011B);
	mouseinit();
	mouseon();
	do {
		key = getkey();
		if (key) {
			putdata(key);
			if (key == ENTER && end)
				break;
			if (key == ESC) {
				if (end) {
					break;
				} else {
					pbuttset(62, 22, 10);
					end = 1;
				}
			} else if (key) {
				pbuttclr(62, 22, 10);
				end = 0;
			}
		}
		if (mousep()) {
			int mx = mousex();
			int my = mousey();

			if (my == 22) {
				if (INRANGE(mx, 62, 72)) {
					pbuttms(62, 22, 10);
					break;
				}
			}
			if (mousep() == 1)
				scputs(4, 23, A_INFO, 0, cp_keymap[0x7D]);
			else if (mousep() == 2)
				scputs(4, 23, A_INFO, 0, cp_keymap[0x7E]);
			else
				scputs(4, 23, A_INFO, 0, cp_keymap[0x7F]);
			while (mousep());
			scputc(4, 23, A_INFO, 24, ' ');
		}
	} while (1);
	mouseoff();
	dlclose(dialog);
	setcursor(cr);
	return 0;
}

void putdata(int key)
{
	int i;
	int id;
	int scan;
	unsigned far *bp = (unsigned far *)0x0040001E;
	unsigned far *fp = (unsigned far *)0x0000041C;
	unsigned far *np = (unsigned far *)0x0000041A;
	scan = key >> 8;
	scputf(43, 3, 0, 0, "%lb", *(unsigned far *)keyshift);
	scputf(24, 5, 0, 0, "%d (%02Xh)   ",  scan,  scan);
	scputc(24, 6, 0, 19, ' ');
	scputc(24, 7, 0, 19, ' ');
	if (scan & 0x80) {
		scputf(60 - 36, 3 + 3, 0, 0, "%s\n - released",
			cp_keymap[scan & 0x7F]);
	} else {
		scputs(60 - 36, 3 + 3, 0, 20, cp_keymap[scan & 0x7F]);
	}
	if (key != 0) {
		scputf(24, 9, 0, 0, "%d (%04Xh)  ", scan, key);//key >> 8, key >> 8);
		scputc(24, 10, 0, 1, key);
		scputc(24, 11, 0, 19, ' ');
		scputs(24, 11, 0, 19, cp_keymap[scan & 0x7F]);
	}
	id = 0;
	for (i = 0; i < 4; i++) {
		scputc(25 + i, 14, 0, 1, bp[i +  0]);
		scputc(29 + i, 14, 0, 1, bp[i +  4]);
		scputc(33 + i, 14, 0, 1, bp[i +  8]);
		scputc(37 + i, 14, 0, 1, bp[i + 12]);
		scputf(22, 15 + i, 0, 0, "%04X", bp[id++]);
		scputf(27, 15 + i, 0, 0, "%04X", bp[id++]);
		scputf(32, 15 + i, 0, 0, "%04X", bp[id++]);
		scputf(37, 15 + i, 0, 0, "%04X", bp[id++]);
	}
	scputf(22, 20, 0, 0, "%04X", *fp);
	fp = (unsigned far *) MK_FP(0x0040, 10/*np*/);
	scputf(22, 21, 0, 0, "%04X (%04X)", *np, *fp);
}

char *cp_keymap[0xFF] = {

    "kbd buffer full",	    	/* 00 - 0F */
    "Esc",
    "1 !",
    "2 @ [\"]",
    "3 #",
    "4 $",
    "5 %",
    "6 ^ [6 &]",
    "7 & [7 /]",
    "8 * [8 (]",
    "9 ( [9 )]",
    "0 ) [0 =]",
    "- _ [+ ?]",
    "= + [\\ `]",
    "Backspace",
    "Tab",

    "q Q",                	/* 10 - 1F */
    "w W",
    "e E",
    "r R",
    "t T",
    "y Y",
    "u U",
    "i I",
    "o O",
    "p P",
    "[ { [ ]",
    "] } [~ ]",
    "Enter",
    "Ctrl",
    "a A",
    "s S",

    "d D",                        /* 20 - 2F */
    "f F",
    "g G",
    "h H",
    "j J",
    "k K",
    "l L",
    "; : [ ]",
    "' \" [ ]",
    "` ~ []",
    "Left Shift",
    "+ | [' *]",
    "z Z",
    "x X",
    "c C",
    "v V",

    "b B",                        /* 30 - 3F */
    "n N",
    "m M",
    ", < [, ;]",
    ". > [. :]",
    "/ ? [- _]",
    "Right Shift",
    "Grey*",
    "Alt",
    "SpaceBar",
    "CapsLock",
    "F1",
    "F2",
    "F3",
    "F4",
    "F5",

    "F6",                       /* 40 - 4F */
    "F7",
    "F8",
    "F9",
    "F10",
    "NumLock",
    "ScrollLock",
    "Home",
    "UpArrow",
    "PgUp",
    "Grey-",
    "LeftArrow",
    "Keypad 5",
    "RightArrow",
    "Grey+",
    "End",

    "DownArrow",                /* 50 - 5F */
    "PgDn",
    "Insert",
    "Delete",
    "SysReq",
    "* F11",
    "left \| (102-key)",
    "F11",
    "F12",
    "* F15",
    "PA1",
    "F13 (LWin)",
    "F14 (RWin)",
    "F15 (Menu)",
    "--",
    "--",

    "--",                       /* 60 - 6F */
    "--",
    "--",
    "F16",
    "F17",
    "F18",
    "F19",
    "F20",
    "F21 (Fn) [*]",
    "F22",
    "F23",
    "F24",
    "--",
    "EraseEOF",
    "--",
    "Copy/Play",

    "--",                       /* 70 - 7F */
    "--",
    "CrSel",
    "<delta> [*]",
    "ExSel",
    "--",
    "Clear",
    "Joyst But1",
    "Joyst But2",
    "Joyst Right",
    "Joyst Left",
    "Joyst Up",
    "Joyst Down",
    "Right mouse",
    "Left mouse",
    "Center mouse",
};

