include	clib.inc
ifdef __ZIP__
include	dos.inc
include	iost.inc
include	wsub.inc
include	fblk.inc
include	string.inc
include	unzip.inc
include	confirm.inc
include	progress.inc
include	errno.inc

	extrn	zip_copyendcentral:near
	extrn	arc_flength:dword
	extrn	foreslash:byte
	extrn	cp_ziptemp:byte

_TEXT	SEGMENT

zip_delete proc pascal uses si fblk:dword
	mov	ax,offset __srcfile
	mov	dx,offset __outfile
	call	wscopy_open
	cmp	ax,-1
	je	delete_end
	les	si,fblk
	mov	si,es:[si]
	mov	STDO.ios_flag,IO_UPDTOTAL or IO_USEUPD
	test	ax,ax
	jnz	delete_02
    delete_error:
	invoke	oclose,addr STDI
	mov	ax,offset __outfile
	call	wscopy_remove
	mov	ax,1
    delete_end:
	ret
    delete_02:			;-------- Local directory
	xor	ax,ax			; match file\*.* if direcetory
	test	si,_A_SUBDIR
	jnz	delete_subdir
	inc	ax			; exact match if file
    delete_subdir:
	push	ax
	call	zip_copylocal		; copy compressed data to temp file
	inc	ax
	jz	delete_error
	dec	ax   			; local offset in DX:CX if found
	jnz	delete_found_local	; local extra field length in BX
	test	si,_A_SUBDIR
	jz	delete_error		; delete sudir ?
    delete_found_local:
	push	dx		;-------- Central directory
	push	cx			; offset local if found
	call	otell
	lodso	zip_endcent.ze_off_cent,cx,bx
	stom	zip_endcent.ze_off_cent
	sub	bx,ax
	sbb	cx,dx
	push	cx
	push	bx
	xor	ax,ax
	test	si,_A_SUBDIR
	jnz	delete_copycentral
	inc	ax
    delete_copycentral:
	push	ax
	call	zip_copycentral
	dec	ax
	jnz	delete_fail		; must be found..
	xor	si,si      	;-------- End Central Directory
	dec	zip_endcent.ze_entry_dir
	dec	zip_endcent.ze_entry_cur
	jnz	delete_not_last_entry
	mov	si,2			; return 2 if last entry deleted
    delete_not_last_entry:
	mov	ax,offset __srcfile
	mov	dx,offset __outfile
	call	zip_copyendcentral
	inc	ax
	mov	ax,si
	jz	delete_fail
	jmp	delete_end
    delete_fail:
	jmp	delete_error
zip_delete endp

zip_maketemp proc pascal wsub:dword, fblk:dword
	mov	bx,word ptr wsub
	invoke	strfcat, addr __srcfile, [bx].ws_path, [bx].ws_file
	push	dx
	push	ax
	invoke	strcpy, addr __outfile, dx::ax
	mov	dx,offset cp_ziptemp
	call	addext
	push	dx
	push	ax
	push	dx
	push	offset __outpath
	mov	bx,word ptr wsub
	pushm	[bx].ws_arch
	push	word ptr fblk+2
	mov	ax,word ptr fblk
	add	ax,fb_name
	push	ax
	call	strfcat
	invoke	dostounix, dx::ax
	les	bx,fblk
	test	byte ptr es:[bx],_A_SUBDIR
	jz      maketemp_01
	invoke	strcat, dx::ax, addr foreslash
    maketemp_01:
	call	strcmp
	test	ax,ax
	ret
zip_maketemp endp

wzipdel proc dist pascal public uses si di wsub:dword,
	fblk:dword ; = SI:DI, CX = flag
	test	ax,ax		; set if repeated call with same directory
	jnz	wzipdel_repeat
	push	si
	mov	ax,di
	add	ax,fb_name
	push	ax
	test	cl,_A_SUBDIR
	jz	wzipdel_file
	call	confirm_delete_sub
	jmp	wzipdel_01
    wzipdel_repeat:
	push	ds
	push	offset entryname
	jmp	wzipdel_progress
    wzipdel_file:
	push	cx
	call	confirm_delete_file
    wzipdel_01:
	test	ax,ax
	jz	wzipdel_end
	inc	ax
	jz	wzipdel_cancel
	invoke	zip_maketemp, wsub, fblk
	jz      wzipdel_err
	push	ds
	push	offset __outpath
    wzipdel_progress:
	push	ds
	push	offset __srcfile
	pushm	arc_flength
	call	progress_set
	invoke	zip_delete, fblk
	mov	es,si
	mov	dl,es:[di]
	and	dl,_A_SUBDIR
	jnz	wzipdel_end
	cmp	ax,1
	je	wzipdel_err
    wzipdel_end:		; return  0: Jump/Ok/Continue
	ret			; 1: Error (-1)
    wzipdel_err:		; 2: ZIP file deleted (Ok)
	mov	dx,ds
	mov	ax,offset __outpath
	cmp	errno,0
	jne	wzipdel_errno
	mov	errno,ENOENT
    wzipdel_errno:
	call	erdelete
	inc	ax
    wzipdel_cancel:
	inc	ax
	jmp	wzipdel_end
wzipdel endp

_TEXT	ENDS
endif
	END
