include	clib.inc
include	io.inc
include	stdio.inc
include	string.inc

	.186

	extrn	_argv:dword

_DATA	SEGMENT
extini label word
	db	'.ini',0
_DATA	ENDS

_TEXT	SEGMENT

next_word PROC
	inc	di
	dec	cx
	jnz	first_word
	or	ax,ax
	ret
next_word ENDP

first_word PROC
	mov	al,[di]
	cmp	al,' '
	je	next_word
	cmp	al,9
	je	next_word
	ret
first_word ENDP

_TEXT	ENDS

PPROC	inisection, section:DWORD, inifile:DWORD
local	filename[80]:BYTE
local	readsize:WORD
local	handle:WORD
	push	si
	push	di
	lea	di,filename
	push	ss
	push	di
	les	bx,_argv
	pushm	es:[bx]
	call	strcpy
	push	dx
	push	ax
	cmp	WORD PTR inifile,0
	je	inisection_nofile
	pushm	inifile
	call	strcpy
	push	dx
	push	ax
    inisection_nofile:
	push	'.'
	call	strrchr
	jnz	inisection_setext
	push	ss
	push	di
	push	ds
	push	OFFSET extini
	call	strcat
	jmp	inisection_open
    inisection_setext:
	mov	bx,ax
	mov	es,dx
	mov	ax,extini
	mov	es:[bx],ax
	mov	ax,extini+2
	mov	es:[bx+2],ax
    inisection_open:
	push	ss
	push	di
	push	_A_NORMAL	; Open .INI file
	push	M_RDONLY
	push	A_OPEN
	call	osopen
	mov	handle,ax
	inc	ax
	jz	inisection_eropen
	pushm	section
	call	strlen
	mov	si,ax
    inisection_read:
	push    handle
	push	ds
	push	OFFSET _bufin
	push	4096
	call	osread
	mov	readsize,ax
	or	ax,ax
	jz	inisection_eof
	push	ds
	pop	es
	mov	cx,ax
	mov	di,OFFSET _bufin
	cld
    inisection_start:
	mov	ax,0A5Bh	; "\n["
    inisection_scan:
	repnz	scasb
	or	cx,cx
	jz	inisection_read
	mov	dx,cx
	inc	dx
	cmp	dx,readsize
	je	inisection_cmp
	cmp	[di-2],ah
	jne	inisection_scan
	neg	dx
	mov	cx,0FFFFh
	mov	ax,4201h
	mov	bx,handle
	int	21h
	jc	inisection_eof
	jmp	inisection_read
    inisection_cmp:
	cmp	_bufin[si+1],']'
	jne	inisection_scan
	mov	dx,es
	les	bx,section
    inisection_sloop:
	mov	al,es:[bx]
	mov	ah,[di]
	inc	di
	inc	bx
	or	ax,2020h
	cmp	ah,al
	jne	inisection_found?
	dec	cx
	jnz	inisection_sloop
    inisection_notfound:
	mov	es,dx
	jmp	inisection_start
    inisection_found?:
	cmp	ax,7D20h
	jne	inisection_notfound
	mov	ax,handle
	mov	bx,di
	jmp	inisection_ret
    inisection_eof:
	push    handle
	call	close	; 0 or -1
    inisection_eropen:
	xor	ax,ax
    inisection_ret:
	or	ax,ax
	pop	di
	pop	si
	ret
PEND	inisection

PPROC	inientry, section:DWORD, entry:DWORD, inifile:DWORD
local	handle:WORD
	push	si
	push	di
	push	WORD PTR section+2
	push	WORD PTR section
	push	WORD PTR inifile+2
	push	WORD PTR inifile
	call	inisection
	jnz	inientry_entry
    inientry_null:
	xor	ax,ax
	cwd
    inientry_end:
	pop	di
	pop	si
	ret
    inientry_eof:
	push    handle
	call	close
	jmp	inientry_null
    inientry_entry:
	mov	di,bx
	mov	handle,ax
    inientry_getentry:
	mov	ax,10	; Section found, read entries
	mov	es,dx
	repnz	scasb		; Get next line
	or	cx,cx
	jz	inientry_eof
	mov	al,[di]
	cmp	al,'['
	je	inientry_eof
	cmp	al,';'
	je	inientry_getentry
	call	first_word	; Start of line
	jz	inientry_eof
	les	bx,entry	; Compare entry name
    inientry_loop:
	mov	al,[di]
	mov	ah,es:[bx]
	or	ah,ah           ; match if entry name is zero
	jz	inientry_zero
	or	ax,2020h
	cmp	ah,al
	jne	inientry_getentry
	inc	di
	inc	bx
	dec	cx
	jnz	inientry_loop
	jmp	inientry_eof
    inientry_zero:
	call	first_word
	cmp	al,'='
	jne	inientry_getentry
    inientry_found:
	push    handle	; Entry found, read entry info
	call	close
	inc	di
	call	first_word	; to start of string
	jz	inientry_null
	mov	si,di
    inientry_line:
	lodsb
	cmp	al,';'
	je	inientry_ende
	cmp	al,0Dh
	je	inientry_ende
	dec	cx
	jnz	inientry_line
    inientry_ende:
	xor	ax,ax
	mov	[si-1],al
	cmp	al,[di]
	je	inientry_null
	push	ds
	push	di
	call	strtrim
	or	ax,ax
	jz	inientry_null
	mov	dx,ds
	mov	ax,di
	jmp	inientry_end
PEND	inientry

	END
