ZIPHEADERID	= 4B50h	; two-byte zip lead-in
ZIPLOCALID	= 0403h	; signature local file
ZIPCENTRALID	= 0201h	; signature central file
ZIPDIGITALID	= 0505h	; digital signature
ZIPENDSENTRID	= 0605h	; signature end central

_A_ENCRYPTED	= 0200h
_A_EXTLOCHD	= 0400h

S_HUFT	STRUC
	huft_e	 	DB ?
	huft_b	 	DB ?
	huft_n		DW ?
	huft_seg	DW ?
S_HUFT	ENDS

S_LZIP	STRUC	; Local file header: 30 byte
	lz_pkzip	DW ?	; local file header signature
	lz_zipid	DW ?
	lz_version	DW ?	; version needed to extract
	lz_flag		DW ?	; general purpose bit flag
	lz_method	DW ?	; compression method
	lz_time		DW ?	; last mod file time
	lz_date		DW ?	; last mod file date
	lz_crc_ax	DW ?	; crc-32
	lz_crc_dx	DW ?
	lz_csize_ax	DW ?	; compressed size
	lz_csize_dx	DW ?
	lz_fsize_ax	DW ?	; uncompressed size
	lz_fsize_dx	DW ?
	lz_fnsize	DW ?	; file name length
	lz_extsize	DW ?	; extra field length
;	file_name[file name length]
;	extra_field[extra field length]
;	compressed_data[compressed size]
S_LZIP	ENDS

S_CZIP	STRUC	; Central directory structure: 46 byte
	cz_pkzip	DW ?	; central file header signature
	cz_zipid	DW ?
	cz_version_made	DW ?	; version made by
	cz_version_need	DW ?	; version needed to extract
	cz_bitflag	DW ?	; general purpose bit flag
	cz_method	DW ?	; compression method
	cz_time		DW ?	; last mod file time
	cz_date		DW ?	; last mod file date
	cz_crc_ax	DW ?	; crc-32
	cz_crc_dx	DW ?
	cz_csize_ax	DW ?	; compressed size
	cz_csize_dx	DW ?
	cz_fsize_ax	DW ?	; uncompressed size
	cz_fsize_dx	DW ?
	cz_fnsize	DW ?	; file name length
	cz_extsize	DW ?	; extra field length
	cz_cmtsize	DW ?	; file comment length
	cz_disk		DW ?	; disk number start
	cz_int_attrib	DW ?	; internal file attributes
	cz_ext_attrib	DW ?	; external file attributes
	cz_ext_attribdx DW ?
	cz_off_local_ax	DW ?	; relative offset of local header
	cz_off_local_dx	DW ?
;	file_name[file name length]
;	extra_field[extra field length]
;	file_comment[file comment length]
S_CZIP	ENDS

S_ZEND	STRUC	; End of central directory record: 22 byte
	ze_pkzip	DW ?	; end of central dir signature
	ze_zipid	DW ?
	ze_disk_cur	DW ?	; number of this disk
	ze_disk_one	DW ?	; number at start of the central directory
	ze_entry_cur	DW ?	; central directory on this disk
	ze_entry_dir	DW ?	; total entries in the central directory
	ze_size_cent_ax	DW ?	; size central directory
	ze_size_cent_dx	DW ?
	ze_off_cent_ax	DW ?	; offset central directory
	ze_off_cent_dx	DW ?
	ze_comment_size	DW ?	; .ZIP file comment length
;	.ZIP file comment[file comment length]
S_ZEND	ENDS

GLOBAL	zip_attrib:	WORD
GLOBAL	zip_local: 	S_LZIP
GLOBAL	zip_central: 	S_CZIP
GLOBAL	zip_endcent: 	S_ZEND

GLOBALD	unzip
GLOBALD	zip_inflate
GLOBALD	zip_explode

GLOBALP	zip_deflate, level:WORD
GLOBALP	zip_copylocal, 	exact_match:BYTE
GLOBALP	zip_copycentral, loffset:DWORD, lsize:DWORD, exact_match:BYTE
