/*
 * COMMAND.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include "dzmain.h"

CMDL com = {
	"",
	{ com.base, { 0,24,80,1 }, WMAXPATH,0,0,NULL,NULL,0x07 },
	NULL
};

static int com_hndlevent(int event)
{
	int result;

	tclrascii = ' ';
	result = tihndlevent(&com.ti, event);
	tclrascii = 250;
	return result;
}

void com_initline(void)
{
	com.ti.rc.x = MIN(strlen(com.sub->path) + 1, 51);
	com.ti.rc.col = 80 - com.ti.rc.x;
	scputc(0, com.ti.rc.y, 0, 80, ' ');
	com.ti.rc.y = *__egaline - 1;
	scpath(0, com.ti.rc.y, 50, com.sub->path);
	scputc(com.ti.rc.x - 1, com.ti.rc.y, 0, 1, '>');
	gotoxy(com.ti.rc.x, com.ti.rc.y);
	com.ti.clat = 0;
	com_hndlevent(PGUP);
}

int com_setdevice(WSUB *p)
{
	wsinit(p);
	com.sub = p;
	com.ti.rc.y = *__egaline - 1;
	com_initline();
	return 1;
}

void com_egaline(void)
{
	if (com.ti.bp && com.sub) {
		com_initline();
	} else {
		com.ti.rc.y = *__egaline - 1;
	}
}

int com_hndevent(int event)
{
	int result = 1;

	switch (event) {
	case UP:
		if (!panel_state(cpanel))
			cmdoskey_up();
		else
			return 0;
		break;
	case DOWN:
		if (!panel_state(cpanel))
			cmdoskey_dn();
		else
			return 0;
		break;
	case RIGHT:
		if (com.base[0] == 0)
			break;
	default:
		if (event == 0 || com_hndlevent(event) != 0)
			result = 0;
		break;
	}
	return result;
}