/*
 * XLSETCEL.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <xcell.h>

int xl_setcell(xcell *xl, unsigned char id, unsigned char count)
{
	unsigned char idcol;
	unsigned char idrow;
	unsigned char index;

	if (id < count)
		index = id;
	else
		index = count - 1;
	idcol = index / xl->rows;
	idrow = index - idcol * xl->rows;
	xl->rc = xl->cpos;
	xl->rc.x += (idcol * (xl->cpos.col + 1));
	xl->rc.y += idrow;
	return index;
}