/*
 * WSSORT.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <wsub.h>
#include <string.h>

static int compare(const FBLK *a, const FBLK *b, int type)
{
	int n,sa,sb;
	char *p;
	char *q;

	if (stricmp(a->name, "..") == 0)
		return 0;

	sa = ISSUBDIR(a->flag);
	sb = ISSUBDIR(b->flag);
	if (sa && !sb)
		return 0;
	if (!sa && sb)
		return 1;

	n = (stricmp(a->name, b->name) > 0);
	switch (type) {
	case _W_SORTTYPE:
		p = strrchr(a->name,'.');
		q = strrchr(b->name,'.');
		if (p == NULL && q != NULL)
			return 0;
		if (p != NULL && q == NULL)
			return 1;
		if (stricmp(p, q) == 0)
			break;
		return stricmp(p, q) > 0;
	case _W_SORTDATE:
		if (a->date == b->date)	{
			if (a->time == b->time)
				break;
			else
				return a->time < b->time;
		}
		return a->date < b->date;
	case _W_SORTSIZE:
		if (a->size == b->size)
			break;
		return a->size < b->size;
	}
	return n;
}

static void sort_fcb(FBLK **b, int count, int s)
{
	int g,c,n;
	fblk *t;

	for (g = (count >> 1); g > 0; g >>= 1) {
		for (c = g; c < count; c++) {
			for (n = c - g; n >= 0 &&
			     compare(b[n], b[n+g], s); n -= g) {
				t = b[n];
				b[n] = b[n+g];
				b[n+g] = t;
			}
		}
	}
}

void wssort(WSUB *p)
{
	_ASSERTE(p == NULL);
	_ASSERTE(p->fcb == NULL);
	if (p->count < 2)
		return;	/* nothing to do */
	sort_fcb(p->fcb, p->count, *p->flag & _W_SORTSIZE);
}