/*
 * ATOX.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <stdlib.h>

long xtol(const char *p)
{
	int c;
	long total;

	total = 0;
	do {
		c = (0x20 | *p++);
		if (c < '0' || c > 'f')
			break;
		if (c <= '9')
			c -= '0';
		else if (c >= 'a')
			c = 10 + c - 'a';
		else
			break;
		total = ((total << 4) + c);
	} while ( 1 );
	return total;
}