/*
 * SETVBUF.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <stdio.h>
#include <alloc.h>
#include <limits.h>

int setvbuf(FILE *o, char *buffer, int type, size_t size)
{
	if ((type != _IONBF) && ((size < 2) || (size > INT_MAX) ||
		((type != _IOFBF) && (type != _IOLBF))))
		return EOF;
	_flush(o);
	_freebuf(o);
	o->flag &= ~(_IOMYBUF|_IOYOURBUF|_IONBF|
		_IOSETVBUF|_IOFEOF|_IOFLRTN|_IOCTRLZ);
	if (type & _IONBF) {
		o->flag |= _IONBF;
		buffer = (char *)&(o->charbuf);
		size = 2;
	} else if (buffer == NULL) {
		if ((buffer = malloc(size)) == NULL)
			return EOF;
		o->flag |= _IOMYBUF | _IOSETVBUF;
	} else {
		o->flag |= _IOYOURBUF | _IOSETVBUF;
	}
	o->bufsize = size;
	o->bp = o->base = buffer;
	o->cnt = 0;
	return 0;
}