/*
 * FBSTATIC.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <fblock.h>
#include <string.h>

FBLK *fbstatic(const ffblk *ff)
{
	static char ffbuf[sizeof(FBLK) + 14];
	FBLK *b = (FBLK *)ffbuf;

	b->flag = ff->ff_attrib;
	b->size = ff->ff_fsize;
	b->date = ff->ff_fdate;
	b->time = ff->ff_ftime;
	strcpy(b->name, ff->ff_name);
	if (ISSUBDIR(b->flag) && *b->name == '.')
		b->flag |= _A_UPDIR;

	return b;
}