/*
 * TRACE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dos.h>
#include <errno.h>
#include <string.h>
#include <tdialog.h>
#include <wchar.h>
#include <stdsc.h>
#include <stdio.h>

static char *syserrmsg[] =
{
	"Error on device:",
	"Memory error:",
	"Block Device Error:",
	"Error on drive A:",
	"Disk area of error:",
	"DOS", "FAT", "ROOT", "DATA",
	"Hit <Enter> key to continue..."
};

/******** Resource begin SystemError *
	{ 0x681C,   1,   0, {14, 9,52, 7} },
	{ 0x0000,   0, 'C', { 4, 5,12, 1} },
********* Resource data  *******************/
static int SystemError_RC[] = {
#ifdef _RCEDIT_
	0x0338,0x681C,0x0001,0x090E,0x0734,0x0000,0x4300,0x0504,
	0x010C,
#endif
	0x34F0,0xF070,0x47D4,0x7070,0xF07F,0x7009,0xF040,0x4728,
	0x0CF0,0xF040,0x4723,0x14F0,0x5320,0x7379,0x6574,0x206D,
	0x7265,0x6F72,0xF072,0x20EA,0x6F43,0x746E,0x6E69,0x6575,
	0x2020,0xF0DC,0x2028,0x0CF0,0xF0DF,0x2023,0x4747,
}; //	80 byte
ROBJ *IDD_SystemError = (ROBJ *)&SystemError_RC;
/******** Resource end   SystemError */

static TOBJ object = { 0x0801, 0, 'C', { 4, 5,12, 1}, };
static DOBJ dialog = { 0x001D, 1, 0, {14, 9,52, 7}, (WCHR*)_bufin, &object };

int trace(void)
{
	int x,y;
	char *p;
	char *type;
	char *info;
	char *drive;
	char dev[32];

	if (0 == (sys_erflag | sys_erdrive | sys_ercode))
		return 0;
	wcunzip(dialog.wp, IDD_SystemError, 52 * 7);
	dialog.flag = (_D_DOPEN | _D_MYBUF | _D_SHADE);
	twshow(&dialog);
	x = dialog.rc.x;
	y = dialog.rc.y;
	info = (sys_ercode > 20) ?
		sys_errlist[ENOTBLK] : dos_errlist[sys_ercode];
	drive = NULL;
	dev[0] = 0;
	if (sys_erflag & __ISDEVICE) {
		if (sys_erdevice->dh_attr < 0)	{
			type = syserrmsg[0];
			memcpy(dev, sys_erdevice->dh_name, 7);
			dev[7] = 0;
		} else {
			if (sys_erflag & 0x0200)
				type = syserrmsg[1];
			else
				type = syserrmsg[2];
		}
	} else {
		type = syserrmsg[3];
		type[15] = 'A' + (char)sys_erdrive;

		switch (sys_erflag & __DISKAREA) {
		case __DISK_DOS:  drive = syserrmsg[5]; break;
		case __DISK_FAT:  drive = syserrmsg[6]; break;
		case __DISK_ROOT: drive = syserrmsg[7]; break;
		case __DISK_DATA: drive = syserrmsg[8]; break;
		}
	}
	scputs(x + 3, y + 2, 0, 46, type);
	if (type == syserrmsg[0]) {
		scputs(x + 20, y + 2, 0, 7, dev);
		scputs(x + 3, y + 3, 0, 46, info);
	} else {
		scputs(x + 23, y + 2, 0, 27, info);
	}
	if (drive) {
		scputs(x + 3, y + 3, 0, 0, syserrmsg[4]);
		scputs(x + 23, y + 3, 0, 0, drive);
	}
	scputs(x + 18, y + 5, 0,  0, syserrmsg[9]);
	sys_erflag  = 0;
	sys_erdrive = 0;
	sys_ercode  = 0;
	beep(10, 9);
	tdmodal(&dialog);
	return 1;
}