; SCAN_IO.ASM--
; Copyright (c) 2000 Hjort Nidudsson
;
; Change history:
; 06 Jun 2004	- Added long filenames to scan
; 16 Apr 2000	- Created

INCLUDE		clibss.inc
INCLUDE		dos.inc
INCLUDE		dir.inc
INCLUDE		string.inc

		.386p

GLOBAL PASCAL	cp_stdmask: BYTE

_BSS  		SEGMENT

fp_directory	DD ?
fp_fileblock	DD ?
fp_maskp	DD ?
scan_curpath	DB WMAXPATH DUP(?)
scan_curfile	DB WMAXPATH DUP(?)
scan_fblock	DB SIZE s_wfblk DUP(?)

_BSS		ENDS

ATTRIB_ALL	= 3Fh
ATTRIB_FILE	= 2Fh

PPROC		scansub
ARG             spath:	DWORD,\
		smask:	DWORD,\
		sflag:	WORD
		mov	eax,smask
		mov	fp_maskp,eax
		push	sflag
		push	spath
		call	scan_directory
		ret
PEND		scansub

PPROC		scan_directory
ARG             flag:	WORD,\
		path:	DWORD
LOCAL		ffblk:	BYTE:[44],\
		hndl:	WORD,\
		sdta:	WORD,\
		odta:	WORD,\
		wpath:	DWORD,\
		wfblk:	DWORD,\
		result:	WORD,\
		subx:	WORD
		USES	DS,si,di
		mov	dx,OFFSET DGROUP:[scan_curpath]
		call	init_globals
		test	flag,1
		jz	SHORT @@1
		push	path
		call	fp_directory
		mov	result,ax
		or	ax,ax
		jz	SHORT @@1
		mov	result,ax
		call	restore_dta
		jmp	SHORT @@toend
@@1:            push	path
		call	strlen
		add	ax,OFFSET DGROUP:[scan_curpath]
		mov	subx,ax
		push	wpath
		push	path
		push	DS
		push	OFFSET DGROUP:[cp_stdmask]
		call	strfcat
		mov	cx,ATTRIB_ALL
		call    scan_findfirst
		cmp	ax,-1
		jz	SHORT @@nomatch
		mov	hndl,ax
		call	scan_findnext
		or	ax,ax
		jz	SHORT @@2
		jmp	SHORT @@close
@@2:		call	scan_findnext
		or	ax,ax
		jnz	SHORT @@close
		mov	al,DGROUP:[scan_fblock]
		test    al,_A_SUBDIR
		jz	SHORT @@2
		mov	ax,subx
		inc	ax
		push	DS
		push	ax
		mov	eax,wfblk
		add	ax,wf_name
		push	eax
		call	strcpy
		push    flag
		push    wpath
		call	scan_directory
		mov	result,ax
		or	ax,ax
		jnz	SHORT @@close
		jmp	SHORT @@2
@@close:	call	scan_closeff
@@nomatch:	xor	ax,ax
		mov	bx,subx
		mov	[bx],al
@@toend:	mov	ax,result
		test	flag,1
		jnz	SHORT @@nocall
		push	path
		call	fp_directory
@@nocall:	ret
PEND		scan_directory

PPROC		scan_files
ARG		path:	DWORD
LOCAL		ffblk:	BYTE:[44],\
		hndl:	WORD,\
		sdta:	WORD,\
		odta:	WORD,\
		wpath:	DWORD,\
		wfblk:	DWORD,\
		result:	WORD,\
		subx:	WORD
		USES	DS,si,di
		mov	dx,OFFSET DGROUP:[scan_curfile]
		call	init_globals
		push	wpath
		push	path
		push	fp_maskp
		call	strfcat
		mov	cx,ATTRIB_FILE
		call	scan_findfirst
		cmp	ax,-1
		je	SHORT @@toend
		mov	hndl,ax
@@next:		push	path
		push	wfblk
		call	fp_fileblock
		mov	result,ax
		or	ax,ax
		jnz	SHORT @@close
		call	scan_findnext
		or	ax,ax
		jz	SHORT @@next
@@close:	call	scan_closeff
@@toend:        mov	ax,result
		ret
PEND		scan_files

_TEXT		SEGMENT

error:		push	ax
		call	dosmaperr
		mov	ax,-1
		ret

scan_findfirst:	lds	dx,wpath
		cmp	_ifsmgr,0
		jnz	SHORT scan_wffirst
		mov	ah,4Eh
		int	21h
		jc	SHORT error
		jmp	SHORT copyff

scan_wffirst:	mov	ax,714eh
		mov	si,1
		les	di,wfblk
		stc
		int	21h
		jc	SHORT error
		ret

scan_findnext:	cmp	_ifsmgr,0
		jnz	SHORT next_ifs
		mov	ah,4fh
		int	21h
		jc	SHORT error
		jmp	SHORT copyff

next_ifs:	stc
		mov	ax,714fh
		mov	bx,hndl
		mov	si,1
		les	di,wfblk
		int	21h
		jc	SHORT error
		mov	ax,0
		ret

copyff:		les	di,wfblk
		mov	bx,di
		xor	eax,eax
		cld
		mov	cx,((SIZE s_wfblk) / 2)
	rep	stosw
		mov	di,bx
		lea	bx,ffblk
		mov     al,SS:[bx.ff_attrib]
		mov	ES:[di],al
		mov     ax,SS:[bx.ff_ftime]
		mov	ES:[di.wf_timemodified],ax
		mov     ax,SS:[bx.ff_fdate]
		mov	ES:[di.wf_datemodified],ax
		mov     eax,SS:[bx.ff_fsize]
		mov	ES:[di.wf_sizeax],eax
		add	bx,ff_name
		add	di,wf_name
		mov	eax,SS:[bx]
		stosd
		mov	eax,SS:[bx+4]
		stosd
		mov	eax,SS:[bx+8]
		stosd
		mov	ax,0
		ret

init_globals:	mov	ax,DS
		shl	eax,16
		mov	ax,dx
		mov	wpath,eax
		mov	ax,OFFSET DGROUP:[scan_fblock]
		mov	wfblk,eax
		xor	ax,ax
		mov	sdta,ax
		mov	result,ax
		cmp	_ifsmgr,ax
		jnz	SHORT end_init
		mov	ah,2Fh
		int	21h
		mov	sdta,ES
		mov	odta,bx
		lea	dx,ffblk
		push	DS
		push	SS
		pop	DS
		mov	ah,1Ah
		int	21h
		pop	DS
end_init:	ret

restore_dta:    mov	ax,sdta
		or	ax,ax
		jz	SHORT end_init
		push	DS
		mov	DS,ax
		mov	dx,odta
		mov	ah,1ah
		int	21h
		pop	DS
		ret

scan_closeff:	cmp	_ifsmgr,0
		jnz	SHORT close_ifs
		call	restore_dta
		jmp	SHORT end_close
close_ifs:      mov	bx,hndl
		mov	ax,71A1h
		int	21h
end_close:	ret

_TEXT		ENDS

		END