/* COPYHNDL.C--
 * Copyright (c) 1997 Hjort Nidudsson
 *
 * Change history:
 * 02 Apr 1997	- Created.
 */

#include <io.h>
#include <errno.h>
#include <alloc.h>
#include <progress.h>

void wzipupdatecrc(void far *, unsigned);

#define BUFSIZE	65024U /* 127 * 512 */
/*
 * return (1) ok,
 * else return (0) and set errno to ENOMEM or ENOSPC
 */
int copyhndl(int ih, int oh, DWORD size)
{
	char *buf;
	WORD bsize;
	DWORD offs,count;

	bsize = BUFSIZE;
	if ((buf = (char *)malloc(bsize)) == NULL) {
		if ((buf = (char *)malloc(_MAXIOBUF)) == NULL) {
			errno = ENOMEM;
			return 0;
		}
		bsize = _MAXIOBUF;
	}
	if (size <= bsize) {
		if (osread(ih, buf, (unsigned)size) == size &&
			oswrite(oh, buf, (unsigned)size) == size) {
			wzipupdatecrc(buf, size);
			free(buf);
			return 1;
		}
		free(buf);
		return 0;
	}
	offs = lseek(oh, 0L, SEEK_CUR);
	count = bsize;
	while (count <= size) {
		if (osread(ih, buf, bsize) != bsize ||
			oswrite(oh, buf, bsize) != bsize ||
			progress_update(count + offs)) {
			free(buf);
			return 0;
		}
		count += bsize;
		wzipupdatecrc(buf, bsize);
	}
	if (count > size) {
		count = (size - (count - bsize));
		if (osread(ih, buf, (unsigned)count) != count ||
			oswrite(oh, buf, (unsigned)count) != count) {
			free(buf);
			return 0;
		}
		wzipupdatecrc(buf, count);
	}
	free(buf);
	return 1;
}