;
; MAKEHTAB.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;
; From source put into the public domain by Mark Adler.
;

INCLUDE		unzip.inc
INCLUDE		alloc.inc

HUFT		STRUC
		extra 	DB ?
		bitcnt 	DB ?
		ubase	DW ?
			DW ?
HUFT		ENDS

PPROC		wzipmakehtab
USES		si,di
LOCAL		a:	WORD,\
		c:	WORD:[MAXBIT+1],\
		el:	WORD,\
		f:	WORD,\
		g:	WORD,\
		i:	WORD,\
		k:	WORD,\
		lx:	WORD:[MAXBIT+1],\
		l:	WORD,\
		p:	WORD,\
		q:	DWORD,\
		r:	HUFT,\
		u:	DWORD:[MAXBIT],\
		v:	WORD:[MAXCODE],\
		w:	WORD,\
		x:	WORD:[MAXBIT+1],\
		y:	WORD,\
		z:	WORD
ARG		b:	DWORD,\
		n:	WORD,\
		s:	WORD,\
		d:	DWORD,\
		e:	DWORD,\
		t:	DWORD,\
		m:	DWORD
		lea	ax,lx
		add	ax,2
		mov	l,ax
		cmp	n,256
		jbe	SHORT eltomax
		les	bx,b
		mov	ax,ES:[bx+512]
		jmp	SHORT length_EOB
eltomax:	mov	ax,MAXBIT
length_EOB:	mov	el,ax
		xor	ax,ax
		lea	dx,c
		mov	di,dx
		push	SS
		pop	ES
		mov	cx,17
		cld
	rep	stosw
		mov	cx,n
		les	di,b
set_bitlength:	mov	bx,ES:[di]
		add	di,2
		shl	bx,1
		add	bx,dx
		inc	WORD PTR SS:[bx]
		loop	SHORT set_bitlength
		mov	bx,dx
		mov	ax,n
		cmp	ax,SS:[bx]
		jne	SHORT minimum_code
		xor	eax,eax
		les	bx,t
		mov	ES:[bx],eax
		les	bx,m
		mov	ES:[bx],ax
		jmp	toend
minimum_code:   mov	di,1
		xor	ax,ax
mincode_loop:   cmp	di,MAXBIT
		ja	SHORT set_jk
		mov	bx,di
		shl	bx,1
		add	bx,dx
		cmp	ax,SS:[bx]
		jnz	SHORT set_jk
		inc	di
		jmp	SHORT mincode_loop
set_jk:		mov	k,di
		les	si,m
		cmp	ES:[si],di
		jnb	SHORT maximum_code
		mov	ES:[si],di
maximum_code:   mov	cx,MAXBIT
		xor	ax,ax
maxcode_loop:   mov	bx,cx
		shl	bx,1
		add	bx,dx
		cmp	ax,SS:[bx]
		jnz	SHORT set_g
		loop	SHORT maxcode_loop
set_g:          mov	g,cx
		les	bx,m
		cmp	cx,ES:[bx]
		jae	SHORT last_length
		mov	ES:[bx],cx
last_length:	mov	si,cx
		mov	cx,di
		mov	ax,1
		shl	ax,cl
		mov	cx,ax
input_loop:	cmp	di,si
		jae	SHORT test_ci
		mov	bx,di
		shl	bx,1
		add	bx,dx
		sub	cx,SS:[bx]
		cmp	cx,0
		jbe	SHORT erzip
		shl	cx,1
		inc	di
		jmp	SHORT input_loop
test_ci:	mov	bx,si
		shl	bx,1
		add	bx,dx
		sub	cx,SS:[bx]
		cmp	cx,0
		jb	SHORT erzip
		add	SS:[bx],cx
		mov	y,cx
		xor	ax,ax
		lea	bx,x
		add	bx,2
		mov	SS:[bx],ax
		mov	di,dx
		add	di,2
makesoffs:	dec	si
		jz	SHORT maketable
		add	ax,SS:[di]
		add	di,2
		add	bx,2
		mov	SS:[bx],ax
		jmp	SHORT makesoffs
erzip:		mov	ax,ER_ZIP
		jmp	toend
maketable:      xor	cx,cx
		les	si,b
mkt_next:	mov	ax,ES:[si]
		add	si,2
		or	ax,ax
		jz	SHORT mkt_loop
		shl	ax,1
		lea	bx,x
		add	bx,ax
		mov	ax,SS:[bx]
		inc	WORD PTR SS:[bx]
		shl	ax,1
		lea	bx,v
		add	bx,ax
		mov	SS:[bx],cx
mkt_loop:	inc	cx
		cmp	cx,n
		jb	SHORT mkt_next
		xor	eax,eax
		mov	i,ax
		mov	x,ax
		mov	w,ax
		mov	lx,ax
		mov	si,-1
		mov	u,eax
		mov	q,eax
		mov	z,ax
		lea	ax,v
		mov	p,ax
		jmp	main_loop
loop_w:		mov	w,ax
		inc	si
		mov	ax,g
		sub	ax,w
		mov	z,ax
		les	bx,m
		cmp	ax,ES:[bx]
		jbe	SHORT use_z
		mov	ax,ES:[bx]
		mov	z,ax
use_z:		mov	ax,k
		sub	ax,w
		mov	di,ax
		mov	cx,ax
		mov	ax,1
		shl	ax,cl
		mov	f,ax
		mov	dx,a
		inc	dx
		cmp	ax,dx
		jbe	SHORT kw_table
		sub	f,dx
		lea	bx,c
		mov	ax,k
		shl	ax,1
		add	bx,ax
deduct_code:	mov	ax,z
		inc	di
		cmp	di,ax
		jnb	SHORT kw_table
		mov	ax,f
		shl	ax,1
		mov	f,ax
		add	bx,2
		cmp	ax,SS:[bx]
		jbe	SHORT kw_table
		mov	ax,SS:[bx]
		sub	f,ax
		jmp	SHORT deduct_code
kw_table:	mov	ax,w
		add	ax,di
		cmp	ax,el
		jbe	SHORT set_jentries
		mov	ax,el
		cmp	w,ax
		jae	SHORT set_jentries
		sub	ax,w
		mov	di,ax
set_jentries:	mov	ax,1
		mov	cx,di
		shl	ax,cl
		mov	z,ax
		mov	bx,si
		shl	bx,1
		add	bx,l
		mov	SS:[bx],di
		inc	ax
		mov	dx,6
		mul	dx
		push	ax
		call	malloc
		or	ax,ax
		jnz	SHORT link_newtbl
		or	si,si
		jz	SHORT nohuf
		push	u
		call	wzipfreehuf
nohuf:		jmp	ermem

link_newtbl:
IFDEF	DEBUG
		mov	cx,z
		inc	cx
		add	zip_numhuf,cx
ENDIF
		les	bx,t
		add	ax,6
		mov	q,eax
		mov	ES:[bx],eax
		sub	ax,4
		mov	t,eax
		les	bx,t
		xor	eax,eax
		mov	ES:[bx],eax
		mov	ax,si
		shl	ax,2
		lea	bx,u
		add	bx,ax
		mov	eax,q
		mov	SS:[bx],eax
		mov	ax,si
		or	ax,ax
		je	SHORT end_w
		shl	ax,1
		lea	bx,x
		add	bx,ax
		mov	dx,i
		mov	SS:[bx],dx
		mov	bx,l
		add	bx,ax
		sub	bx,2
		mov	cx,SS:[bx]
		mov	r.bitcnt,cl
		mov	bx,ax
		mov	ax,16
		add	ax,di
		mov	r.extra,al
		mov	eax,q
		mov	DWORD PTR r+2,eax
		mov	ax,w
		sub	ax,cx
		mov	dx,ax
		mov	ax,1
		mov	cx,w
		shl	ax,cl
		dec	ax
		mov	cx,i
		and	cx,ax
		mov	ax,cx
		mov	cx,dx
		shr	ax,cl
		mov	dx,ax
		imul	dx,dx,6
		mov	ax,si
		dec	ax
		shl	ax,2
		lea	bx,u
		add	bx,ax
		mov	ax,SS:[bx]
		add	ax,dx
		mov	ES,SS:[bx+2]
		mov	bx,ax
		mov	ax,WORD PTR r
		mov	ES:[bx],ax
		mov	eax,DWORD PTR r+2
		mov	ES:[bx+2],eax
end_w:		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		mov	ax,si
		shl	ax,1
		mov	bx,l
		add	bx,ax
		mov	ax,w
		add	ax,SS:[bx]
		cmp	ax,k
		jae 	SHORT table_entry
		jmp	loop_w

table_entry:	mov	ax,k
		sub	ax,w
		mov	r.bitcnt,al
		mov	ax,n
		shl	ax,1
		lea	dx,v
		add	ax,dx
		mov	bx,p
		cmp	ax,bx
		ja	SHORT end_blcode
		mov	r.extra,99
		jmp	SHORT fill_code
end_blcode:	mov	ax,SS:[bx]
		cmp	ax,s
		jae	SHORT non_simple
		add	p,2
		mov	r.ubase,ax
		mov	r.extra,16
		cmp	ax,256
		jb	SHORT fill_code
		mov	r.extra,15
		jmp	SHORT fill_code
non_simple:	add	p,2
		sub	ax,s
		shl	ax,1
		les	bx,e
		add	bx,ax
		mov	dl,ES:[bx]
		mov	r.extra,dl
		les	bx,d
		add	bx,ax
		mov	ax,ES:[bx]
		mov	r.ubase,ax
fill_code:	mov	cx,k
		sub	cx,w
		mov	ax,1
		shl	ax,cl
		mov	f,ax
		mov	cx,w
		mov	ax,i
		shr	ax,cl
		mov	cx,ax
		mov	ES,WORD PTR q+2
fill_loop:	cmp	cx,z
		jnb	SHORT do_backwards
		mov	ax,cx
		mov	dx,6
		mul	dx
		mov	bx,WORD PTR q
		add	bx,ax
		mov	ax,WORD PTR r
		mov	ES:[bx],ax
		mov	eax,DWORD PTR r+2
		mov	ES:[bx+2],eax
		add	cx,f
		jmp	SHORT fill_loop
do_backwards:	mov	cx,k
		dec	cx
		mov	ax,1
		shl	ax,cl
		mov	cx,ax
		mov	di,i
increment_i:    test	di,cx
		jz	SHORT xor_i
		xor	di,cx
		shr	cx,1
		jmp	SHORT increment_i
xor_i:		xor	di,cx
		mov	i,di
update_wh:	mov	ax,1
		mov	cx,w
		shl	ax,cl
		dec	ax
		mov	dx,di
		and	dx,ax
		mov	bx,si
		shl	bx,1
		lea	ax,x
		add	bx,ax
		cmp	dx,SS:[bx]
		je	SHORT loop_a
		dec	si
		mov	ax,si
		shl	ax,1
		mov	bx,l
		add	bx,ax
		mov	ax,SS:[bx]
		sub	w,ax
		jmp	SHORT update_wh
loop_a:		mov	ax,a
		dec	a
		or	ax,ax
		je 	SHORT inc_k
		jmp	end_w
inc_k:		inc	k
main_loop:	mov	ax,k
		cmp	ax,g
		jg 	SHORT end_main
		mov	bx,k
		shl	bx,1
		lea	ax,c
		add	bx,ax
		mov	ax,SS:[bx]
		mov	a,ax
		jmp	SHORT loop_a
end_main:	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		mov	bx,l
		mov	ax,SS:[bx]
		les	bx,m
		mov     ES:[bx],ax
;
; Return true (1) --warning error--
; if we were given an incomplete table
;
		mov	ax,1
		cmp	y,0
		je	SHORT retok
		cmp	g,1
		je	SHORT retok
		jmp	SHORT toend
ermem:		mov	ax,ER_MEM
		jmp	SHORT toend
retok:		xor	ax,ax
toend:          ret
PEND		wzipmakehtab

		END
