/*
 * OPENTEMP.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <arch.h>
#include <string.h>

char *arc_maketemp(char *b)
{
	char *q;

	strcpy(b, __outfile);
	if ((q = strrchr(b, '.')) == NULL)
		return strcat(b, ARCTEMP_EXT);
	strcpy(q, ARCTEMP_EXT);
	return b;
}

int arc_renametemp(void)
{
	char b[WMAXPATH];

	arc_maketemp(b);
	if (strcmp(b, __outfile) && filexist(b) == 1) {
		remove(__outfile);
		return rename(b, __outfile);
	}
	return -1;
}

int arc_opentemp(void)
{
	char b[WMAXPATH];

	return osopen(arc_maketemp(b), _A_TEMPORARY, M_WRONLY, A_CREATE);
}

int arc_deltemp(void)
{
	char b[WMAXPATH];

	return remove(arc_maketemp(b));
}
