/*
 * CMSEARCH.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <ios.h>
#include <time.h>
#include <alloc.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <tlistobj.h>
#include <progress.h>
#include <dzmain.h>
#include <arch.h>

#define MAXHIT		999
#define LISTFILE	"filelist.bat"

#define MAXINFOTXT	36
typedef struct	{
	long	offset;
	char	text[MAXINFOTXT];
	char	name[2];
      } SBLK;

typedef struct {
	SBLK *	fcb[MAXHIT];
	FILT 	filter;
      }	FFOB;

#define DEFAULTSTATE	0x0027F800

enum Resource_FILE_SEARCH {
	ID_FFMASK = 11,
	ID_FFPATH,
	ID_CONTENT,
	ID_REPLACE,
	ID_SCANSUB,
	ID_USECASE,
	ID_START,
	ID_CONFIG,
	ID_SAVE,
	ID_GOTO,
	ID_FVIEW,
	ID_QUIT,
	ID_FRAME1,
	ID_FRAME2,
	ITEMCOUNT
};

#define OCOUNT	ID_FFMASK

enum Resource_ADVANCED {
	ID_DATEAFTER,
	ID_DATEBEFORE,
	ID_SIZEGREATER,
	ID_SIZELESS,
	ID_FSYSTEM,
	ID_FHIDDEN,
	ID_FRDONLY,
	ID_FARCHIVE,
	ID_FSUBDIR,
	ID_FNORMAL,
	ID_OK,
	ID_CANCEL
};

enum Resource_FSMakelist {
	ID_FILENAME,
	ID_BEFORE,
	ID_TXTAFTER,
	ID_SOK,
	ID_SCANCEL
};

static int search_view(void);
static int search_advanced(void);
static int search_save(void);
static int search_dofile(const char *, wfblk *);
static int search_dosubdir(const char *);
static int search_path(char *);
static int search_start(void);
static int search_eventcell(void);
static int search_initlist(void);
static int search_exit(void);
static void search_putcellid(void);

static FFOB *search;
static GCMD search_keys[3] = {
	{ F3, 	 search_view	},
	{ ALTX,  search_exit	},
	{ 0, 	 NULL		},
};

int search_exit(void)
{
	while (shift->AltLeft);
	return _C_ESCAPE;
}

int search_view(void)
{
	if (lo_objcount == 0)
		return _C_NORMAL;
	tview(search->fcb[lo_objindex + lo_celindex]->name,
	      search->fcb[lo_objindex + lo_celindex]->offset);
	lo_dialog->index = lo_celindex;
	return _C_NORMAL;
}

/* Operation Filters */

int search_advanced(void)
{
	int x,y;

	cmfilter();
	x = lo_dialog->rc.x + 16;
	y = lo_dialog->rc.y + 20;
	if (filtp == NULL)
		scputc(x, y, 0, 1, ' ');
	else
		scputc(x, y, 0, 1, 7);
	return _C_NORMAL;
}

int search_save(void)
{
	DOBJ *dp;
	int i,h;

	if (lo_objcount == 0)
		return 0;
	if ((dp = rsopen(IDD_FSMakelist)) == NULL)
		return _C_NORMAL;
#ifdef _DOSBMP_
	dp->object[0].flag |= _O_DHELP;
#endif
	strcpy(dp->object[ID_FILENAME].data, LISTFILE);
	tdinit(dp);
	if (tdevent(dp) == 0) {
		tdclose(dp);
		return _C_NORMAL;
	}
	if ((h = getouthandle(dp->object[ID_FILENAME].data)) == -1) {
		tdclose(dp);
		return _C_NORMAL;
	}
	for (i = 0; i < lo_objcount; i++) {
		if (*(char *)dp->object[ID_BEFORE].data) {
			oswrite(h, dp->object[ID_BEFORE].data,
				strlen(dp->object[ID_BEFORE].data));
			oswrite(h, " ", 1);
		}
		oswrite(h, search->fcb[i]->name, strlen(search->fcb[i]->name));
		if (*(char *)dp->object[ID_TXTAFTER].data) {
			oswrite(h, " ", 1);
			oswrite(h, dp->object[ID_TXTAFTER].data,
				strlen(dp->object[ID_TXTAFTER].data));
		}
		oswrite(h, "\r\n", 2);
	}
	close(h);
	tdclose(dp);
	if (panel_state(cpanel)) {
		tdhide(lo_dialog);
		panel_update_fcb(cpanel);
		tdshow(lo_dialog);
	}
	return _C_NORMAL;
}

int search_dofile(const char *p, wfblk *wf)
{
	SBLK *	ff;
	TOBJ *	o;
	int 	h;
	int 	usecase;
	int	result;
	char *	q;
	long 	offset;
	char 	b[WMAXPATH];

	result = 0;
	if (lo_objcount >= MAXHIT)
		return result;
	if (test_filter(wf->name, wf->size_low, wf->attrib, wf->date_modified) == 0)
		return result;
	strfcat(b, p, wf->name);
	if (progress_set(NULL, wf->name, 1))
		return _ER_USERABORT;
	if (p == NULL)
		return -1;
	o = lo_dialog->object;
	if (cmpwarg(wf->name, o[ID_FFMASK].data) == 0)
		return result;
	q = (char *)o[ID_CONTENT].data;
	if (*q == 0) {
		if ((ff = (SBLK *)malloc(strlen(b) + sizeof(SBLK))) == NULL)
			return -1;
		memset(ff, 0, sizeof(SBLK));
		strcpy(ff->name, b);
		search->fcb[lo_objcount++] = ff;
		progress_update(lo_objcount);
		return result;
	}
	if ((h = osopen(b, wf->attrib, M_RDONLY, A_OPEN)) == -1)
		return result;
	if (o[ID_USECASE].flag & _O_FLAGB)
		usecase = IOS_USECASE;
	else
		usecase = 0;
	if ((offset = iossearch(h, wf->size_low, _bufin, _INTIOBUF, usecase)) == -1L) {
		close(h);
		return result;
	}
	do {
		if ((ff = (SBLK *)malloc(strlen(b) + sizeof(SBLK))) == NULL) {
			close(h);
			return -1;
		}
		search->fcb[lo_objcount++] = ff;
		result = progress_update(lo_objcount);
		ff->offset = offset;
		strcpy(ff->name, b);
		lseek(h, offset, SEEK_SET);
		osread(h, ff->text, MAXINFOTXT - 1);
		lseek(h, MIN(offset + 1, wf->size_low), SEEK_SET);
	} while (result == 0 && lo_objcount < MAXHIT &&
		(offset = iossearch(h,
			wf->size_low, _bufin, _INTIOBUF, usecase)) != -1L);
	close(h);
	return result;
}

int search_dosubdir(const char *p)
{
	if (progress_set(NULL, p, 0))
		return _ER_USERABORT;
	return scan_files(p);
}

int search_path(char *p)
{
	char *q = p + strlen(p) - 1;

	if (*q == '\\')
		*q = 0;
	fp_maskp = lo_dialog->object[ID_FFMASK].data;
	fp_fileblock = search_dofile;
	fp_directory = search_dosubdir;
	if (lo_dialog->object[ID_SCANSUB].flag & _O_FLAGB)
		return scan_directory(1, p);
	return search_dosubdir(p);
}

int search_start(void)
{
	int 	q;
	TOBJ *	o;

	for (q = 0; q < lo_objcount; q++)
		free(search->fcb[q]);
	lo_celindex =
	lo_objindex =
	lo_celcount =
	lo_objcount = 0;
	o = lo_dialog->object;
#ifdef _DOSBMP_
	lo_dialog->object[0].flag |= _O_DHELP;
#endif
	tdsetbitflag(o, ID_FFMASK, _O_STATE, 0x0FFF);
	tdinit(lo_dialog);
	scputc(lo_dialog->rc.x + 4, lo_dialog->rc.y + 13, 0, 9, 196);
	progress_open(cp_search, NULL);
	progress_set(o[ID_FFPATH].data, 0, MAXHIT + 2);
	search_path(o[ID_FFPATH].data);
	progress_close();
	if (lo_objcount == 0)
		return _C_NORMAL;
	lo_celcount = MIN(lo_objcount, ID_FFMASK);
	scputf(lo_dialog->rc.x + 4, lo_dialog->rc.y + 13, 0, 0, "[%03d:000]",
		lo_objcount);
	search_initlist();
	for (q = 0; q < lo_celcount; q++)
		o[q].flag &=  ~_O_STATE;
	return _C_NORMAL;
}

void search_putcellid(void)
{
	scputf(lo_dialog->rc.x + 4, lo_dialog->rc.y + 13, 0, 0,
		"[%03d:%03d]", lo_objcount, lo_objindex + lo_dialog->index + 1);
}

int search_eventcell(void)
{
	search_putcellid();
	return lo_exevent();
}

int search_initlist(void)
{
	int x,y,q;
	BYTE *p;
	SBLK *ff;

	tdinit(lo_dialog);
	x = lo_dialog->rc.x + 4;
	y = lo_dialog->rc.y + 2;
	for (q = 0; q < lo_celcount; q++) {
		ff = search->fcb[lo_objindex + q];
		scpath(x, y + q, 32, ff->name);
		if (ff->text[0]) {
			for (p = ff->text; p[0]; p++) {
				if (*p < 32)
					break;
			}
			*p = 0;
			scputs(x + 33, y + q, 0, 35, ff->text);
		}
	}
	return 1;
}

int FindFile(const char *path)
{
	int event;
	int 	x;
	char *	p;
	char *	q;
	TOBJ *	o;

	cmclrcmdl();
	if ((search = (FFOB *)malloc(sizeof(FFOB))) == NULL)
		return stderror(NULL, EMNOMEM, 0);
	if (lo_open(IDD_FILE_SEARCH, OCOUNT, search_initlist) == 0) {
		free(search);
		return stderror(NULL, EMNOMEM, 0);
	}
	memset(search, 0, sizeof(FFOB));
	lo_celindex =
	lo_objindex =
	lo_celcount =
	lo_objcount = 0;
	o = lo_dialog->object;
	o[ID_CONTENT].data = searchstring;
	o[ID_FRAME1].data = search_keys;
	strcpy(o[ID_FFPATH].data, path);
	p = strfn(o[ID_FFPATH].data);
	strcpy(o[ID_FFMASK].data, p);
	if (p == o[ID_FFPATH].data) {
		strcpy(o[ID_FFPATH].data, com.sub->path);
	} else {
		*--p = 0;
	}
	for (x = 0; x < OCOUNT; x++)
		o[x].proc = search_eventcell;
	o[ID_START].proc  = search_start;
	o[ID_CONFIG].proc = search_advanced;
	o[ID_SAVE].proc   = search_save;
	o[ID_FVIEW].proc  = search_view;
	o[ID_FRAME1].proc = lo_mouseup;
	o[ID_FRAME2].proc = lo_mousedn;
	if (fsflag & FS_SEARCHCASE)
		o[ID_USECASE].flag |= _O_FLAGB;
	if (fsflag & FS_SEARCHSUB)
		o[ID_SCANSUB].flag |= _O_FLAGB;
	tdinit(lo_dialog);
	filtp = NULL;
	while ((event = rsevent(IDD_FILE_SEARCH, lo_dialog)) != 0) {
		if (lo_dialog->index < ID_FFMASK) {
			x = lo_objindex + lo_dialog->index;
			tview(search->fcb[x]->name, search->fcb[x]->offset);
		} else if (lo_dialog->index == ID_GOTO) {
			break;
		} else {
			search_start();
		}
	}
	fsflag &= ~(FS_SEARCHCASE|FS_SEARCHSUB);
	if (o[ID_USECASE].flag & _O_FLAGB)
		fsflag |= FS_SEARCHCASE;
	if (o[ID_SCANSUB].flag & _O_FLAGB)
		fsflag |= FS_SEARCHSUB;
	if (lo_dialog->index == ID_GOTO && panel_state(cpanel)) {
		q = search->fcb[lo_objindex + lo_celindex]->name;
		if ((p = strrchr(q, '\\')) != NULL) {
			*p = 0;
			chdrv(TOUPPER(*q) - '@');
			chdir(q);
			strcpy(cpanel->ide->path, q);
			com_setdevice(cpanel->ide);
		}
		tdclose(lo_dialog);
		panel_update_fcb(cpanel);
	} else {
		tdclose(lo_dialog);
	}
	for (x = 0; x < lo_objcount; x++)
		free(search->fcb[x]);
	free(search);
	return event;
}

int cmsearch(void)
{
	char b[WMAXPATH];

	return FindFile(strfcat(b, com.sub->path, com.sub->mask));
}