/*
 * WSRDSUB.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <wsub.h>
#include <string.h>
#include <errno.h>

int wsreadsub(WSUB *q)
{
	int a,i;
	int result;

	wsfree(q);
	a = (*q->flag & _W_HIDDEN) ? _A_ALLFILES : _A_STDFILES;
	if (*q->mask == 0)
		strcpy(q->mask, cp_stdmask);
	if (*q->flag & _W_LONGNAME)
		result = wsreadwf(q, a);
	else
		result = wsreadff(q, a);
	if (result == 0) {
		q->fcb[0] = fbupdir(0);
		q->count = 1;
		return 1;
	}
	a = 0;
	for (i = 0; i < result; i++)
		if (strcmp(q->fcb[i]->name, "..") == 0)
			a++;
	if (a == 0 && q->path[strlen(q->path) - 1] != '\\') {
		q->fcb[result++] = fbupdir(0);
		q->count++;
	}
	return result;
}

int wsreadff(WSUB *q, int scan_attrib)
{
	ffblk ff;
	fblk *fb;
	char mask[WMAXPATH];

	q->count = 0;
	strfcat(mask, q->path, cp_stdmask);
	if (findfirst(mask, &ff, scan_attrib))
		return 0;
	if (trace())
		return 0;
	if (ff.ff_name[0] == '.' && ff.ff_name[1] == 0) {
		if (findnext(&ff))
			return 0;
	} do {
		if (ISSUBDIR(ff.ff_attrib) == 0 &&
			cmpwarg(ff.ff_name, q->mask) == 0)
			continue;
		if ((fb = fballocff(&ff, *q->flag & 0xFF00)) == NULL)
			break;
		q->fcb[q->count] = fb;
		if (++q->count >= q->maxfb)
			break;
	} while (findnext(&ff) == 0);
	return q->count;
}

int wsreadwf(WSUB *q, int scan_attrib)
{
	int handle;
	fblk *fb;
	wfblk *ff;
	wfblk wfblock;
	char mask[WMAXPATH];

	q->count = 0;
	ff = &wfblock;
	strfcat(mask, q->path, cp_stdmask);
	if ((handle = wfindfirst(mask, ff, scan_attrib)) == -1)
		return 0;
	if (trace()) {
		wcloseff(handle);
		return 0;
	}
	if (ff->name[0] == '.' && ff->name[1] == 0) {
		if (wfindnext(ff, handle)) {
			wcloseff(handle);
			return 0;
		}
	} do {
		if (ISSUBDIR(ff->attrib) == 0 &&
			cmpwarg(ff->name, q->mask) == 0)
			continue;
		if ((fb = fballocwf(ff, *q->flag & 0xFF00)) == NULL)
			break;
		q->fcb[q->count] = fb;
		if (++q->count >= q->maxfb)
			break;
	} while (wfindnext(ff, handle) == 0);
	wcloseff(handle);
	return q->count;
}
