/*
 * STRING.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_STRING
#define __INC_STRING
#if !defined(__INC_DEFS)
 #include <defs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

void * _CType memchr(void *, int, size_t);
int    _CType memcmp(const void *, const void *, size_t);
void * _CType memcpy(void *, const void *, size_t);
void * _CType memmove(void *, const void *, size_t);
void * _CType memset(void *, int, size_t);

#define	memzero(p,c) memset(p,0,c)

char * _CType strcat(char *, const char *);
char * _CType strchr(const char *, int);
int    _CType strcmp(const char *, const char *);
char * _CType strcpy(char *, const char *);
size_t _CType strlen(const char *);
char * _CType strncat(char *, const char *, size_t);
int    _CType strncmp(const char *, const char *, size_t);
char * _CType strncpy(char *, const char *, size_t);
char * _CType strrchr(const char *, int);
char * _CType strstr(const char *, const char *);
int    _CType stricmp(const char *, const char *);
int    _CType strnicmp(const char *, const char *, size_t);
char * _CType strupr(char *);
char * _CType strlwr(const char *);
char * _CType strrev(char *);

void * _CType memrol(void *, size_t, int __bits_1_7);
void * _CType memror(void *, size_t, int __bits_1_7);
void * _CType memrev(void *, size_t);
void * _CType memrchr(void *, int, size_t);
void * _CType memxchg(void *, void *, size_t);
void * _CType wmemcpy(void *, const void *, size_t __word_count);
char * _CType strstart(char *);
int    _CType strtrim(char *);
int    _CType striptab(char *, int __size);
char * _CType strfn(const char *);
char * _CType strfcat(char *__dest,
		const char *__path,
		const char *__file);
char * _CType setext(char *__buf, const char *__ext);
int    _CType cmpwarg(const char *__file, const char *__mask);
int    _CType cmpwargs(const char *__file, const char *__mask);
char * _CType ascii_todos(char *__win);
char * _CType ascii_towin(char *__dos);

#ifdef __cplusplus
 }
#endif
#endif