/*
 * PANEL.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <arch.h>
#include <disk.h>
#include <string.h>
#include <ctype.h>
#include <dzmain.h>
#include <progress.h>
#include <alloc.h>

static int panel_initarg_path(void)
{
	if (access(argv_filename, 0) != 0)
		return 0;
	if ((_CX & _A_SUBDIR) == 0)
		return 2;
	cflag &= ~(_C_PANELID);
	if (argv_filename[1] == ':')
		chdrv(_toupper(argv_filename[0]) - 'A');
	chdir(argv_filename);
	fullpath(config.ide[0].path, 0);
	return 1;
}

static int panel_initarg_arch(WORD w)
{
	char *p;

	config.ide[0].flag &= ~_W_ARCHIVE;
	config.ide[1].flag &= ~_W_ARCHIVE;
	config.ide[0].flag |= _W_VISIBLE;
	strcpy(config.ide[0].file, (p = strfn(argv_filename)));
	if (p > argv_filename) {
		*--p = 0;
		if (panel_initarg_path() == 0)
			return 0;
	} else {
		cflag &= ~(_C_PANELID);
		fullpath(config.ide[0].path, 0);
	}
	config.ide[0].arch[0] = 0;
	if (w == ARJHEADERID)
		config.ide[0].flag |= _W_ARJ;
	else
		config.ide[0].flag |= _W_ZIP;
	return 1;
}

int init_panels(void)
{
	WORD dw;

	if (config.ide[0].path[0] == 0)
		strcpy(config.ide[0].path, programpath);
	if (config.ide[1].path[0] == 0)
		strcpy(config.ide[1].path, programpath);
	if (config.ide[0].mask[0] == 0)
		strcpy(config.ide[0].mask, cp_stdmask);
	if (config.ide[1].mask[0] == 0)
		strcpy(config.ide[1].mask, cp_stdmask);
	if (_ifsmgr == 0) {
		config.ide[0].flag &= ~_W_LONGNAME;
		config.ide[1].flag &= ~_W_LONGNAME;
	}
	if (dzcount == 0 && argv_filename) {
		if (panel_initarg_path() == 2) {
			dw = readword(argv_filename);
			if (dw == ZIPHEADERID || dw == ARJHEADERID)
				panel_initarg_arch(dw);
		}
	}
	return 0;
}

int open_panels(void)
{
	if (cflag & _C_PANELID)
		cpanel = &panelb;
	else
		cpanel = &panela;
	if (aflag & _W_VISIBLE) {
		prect_open(&panela);
	}
	if (bflag & _W_VISIBLE) {
		prect_open(&panelb);
	}
	if (panel_open(cpanel) == 0)
		return 0;
	if (cpanel == &panelb)
		panel_open(&panela);
	else
		panel_open(&panelb);
	return 1;
}

int panel_open(panel *p)
{
	int  id;
	WSUB *q;
	WORD flag;
	char path[WMAXPATH];

	if (wsopen(p->ide) == 0)
		return 0;
	id = (*p->flag & _W_PANELID);
	p->fcb_index = config.idb[id];
	p->cel_index = config.idx[id];
	p->cel_count = 0;
	q = p->ide;
	if (p == cpanel) {
		flag = *q->flag;
		strcpy(path, q->path);
		q->path[0] = 0;
		com_setdevice(q);
		if (ISARCHIVE(flag) && stricmp(path, q->path) == 0) {
			*q->flag = flag;
		}
	}
	if (*p->flag & _W_VISIBLE) {
		panel_update_fcb(p);
		if (p == cpanel)
			panel_setactive(p);
	}
	return 1;
}

int panel_xycmd(panel *p, int x, int y)
{
	RECT	rc;
	int	ex,q;
	int	result;

	if (panel_state(p) == 0)
		return 0;
	rc = p->dialog->rc;
	ex = rc.x + rc.col - 1;
	if (0 == (result = rcxyrow(rc, x, y)))
		return PN_XYOUTSIDE;
	if (result == 1)
		return PN_XYMOVEUP;
	if (result == 2) {
		if (x > rc.x && x < rc.x + 3)
			return PN_XYNEWDISK;
		if (x == rc.x + 3)
			return PN_XYCONFIG;
		if (x > rc.x + 4 && x < ex)
			return PN_XYMOVEUP;
	}
	if (*p->flag & _W_MINISTATUS) {
		if (result > rc.row - 3 && x > rc.x && x < ex) {
			if (result == rc.row - 2 && x == ex - 2)
				return PN_XYMINISTATUS;
			return PN_XYMOVEDOWN;
		}
		rc.row -= 2;
	} else if (result == rc.row) {
		if (x == ex - 2)
			return PN_XYMINISTATUS;
		return PN_XYMOVEDOWN;
	}
	for (q = 0; q < p->cel_count; q++) {
		rc = xl_getrect(p->xl, q);
		if (rcxyrow(rc, x, y))
			return PN_XYFILE;
	}
	return PN_XYINSIDE;
}

int panel_setid(panel *p, int q)
{
	p->fcb_index = 0;
	p->cel_index = 0;
	pcell_set(p);
	if (q < p->cel_count) {
		p->cel_index = q;
	} else {
		p->fcb_index = q - p->cel_count + 1;
		p->cel_index = p->cel_count - 1;
	}
	return q;
}

static char *strmega(long size)
{
	long q;
	int index;
	static char result[32];

	index = 0;
	q = size;
	while (q > 999999) {
		q = DIVK(q);
		index++;
	}
	sprintf(result,"%7lu", q);
	if (index == 1)
		strcat(result, "K");
	else if (index == 2)
		strcat(result, "M");
	else if (index == 3)
		strcat(result, "G");
	return result;
}

void panel_putfile(fblk *p, int x, int y)
{
	fbputll(p, x, y);
	if (ISSUBDIR(p->flag) == 0)
		scputs(x + 15, y, at_Files, 0, strmega(p->size));
	else if (ISUPDIR(p->flag))
		scputs(x + 16, y, at_System, 7, cp_updir + 1);
	else
		scputs(x + 16, y, at_Subdir, 7, cp_subdir + 1);
	fbputdate(p, x + 24, y);
	fbputtime(p, x + 33, y);
}
