/*
 * FCLOSE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <stdio.h>

int fclose(FILE *o)
{
	int result = EOF;

	_ASSERTE(o == NULL);
	if (inuse(o))	{
		result = fflush(o);
		_freebuf(o);
		if (close(o->file) < 0)
			result = EOF;
		o->file = -1;
		o->flag = 0;
	}
	return result;
}