/*
 * _FLSBUF.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <stdio.h>

int _flsbuf(int ch, FILE *o)
{
	int fh;
	int written;
	int count;

	fh = o->file;
	if (!(o->flag & (_IOWRT | _IORW)) || (o->flag & _IOSTRG)) {
		o->flag |= _IOERR;
		return EOF;
	}
	if (o->flag & _IOREAD) {
		o->cnt = 0;
		if (o->flag & _IOEOF) {
			o->bp = o->base;
			o->flag &= ~_IOREAD;
		} else {
			o->flag |= _IOERR;
			return EOF;
		}
	}
	o->flag |= _IOWRT;
	o->flag &= ~_IOEOF;
	written = count = o->cnt = 0;
	if (!anybuf(o)) {
		if (!(((o == stdout) || (o == stderr)) && (osisatty(fh))))
			_getbuf(o);
	}
	if (bigbuf(o)) {
		count   = o->bp - o->base;
		o->bp  = o->base + 1;
		o->cnt = o->bufsize - 1;
		if (count > 0)
			written = write(fh, o->base, count);
		else if (_osfile[fh] & FH_APPEND)
			lseek(fh, 0L, SEEK_END);
		*o->base = (char)ch;
	} else {
		count = 1;
		written = write(fh, &ch, count);
	}
	if (written != count) {
		o->flag |= _IOERR;
		return EOF;
	}
	return (ch & 0xff);
}