/*
 * WSUB.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_WSUB
#define __INC_WSUB

#include <dir.h>
#include <fblock.h>

#define WMAXFBLOCK	0x3FFF

#define _W_PANELID	0x0001
#define _W_VISIBLE	0x0002
#define _W_MINISTATUS	0x0004
#define _W_CURPATH	0x0008
#define _W_LONGNAME	0x0010
#define _W_DETAIL	0x0020
#define _W_HIDDEN	0x0040

#define _W_LOCALE	0x0000
#define _W_FLOPPY	0x0080
#define _W_CDROOM	0x0100
#define _W_NETWORK	0x0180

#define _W_SORTNAME	0x0000
#define _W_SORTTYPE     0x0200
#define _W_SORTDATE     0x0400
#define _W_SORTSIZE	0x0600
#define _W_SORTFLAG	_W_SORTSIZE
#define __SORTOBJS	0x4000

/* Archive Types [00..15] */
#define _W_ARCHIVE	_A_ARCHIVE
#define _W_ZIP		_A_ZIP
#define _W_ARJ		_A_ARJ
/* these are not used.. */
#define _W_GZ		_A_GZ
#define _W_7Z		_A_7Z /* src/clib/wsub/04_7Z/*/
#define _W_CAB		_A_CAB
#define _W_BZ2		_A_BZ2

/* the last two reserved for Info View/Search Result.. */
#define _W_SEARCHLST	0xE000 /* dump info from File Search */
#define _W_INFOVIEW	0xF000 /* dump info from opposite panel */

#ifdef __cplusplus
 extern "C" {
#endif

#define WSSetLocal(p)	(*p->flag &= ~_W_NETWORK)
#define WSClrArch(p)	(*p->flag &= ~_W_ARCHIVE)

/* Get drive from path-string (A:=0) */
#define WSGetDrive(p)	(p->path[0] - 'A')

typedef struct {
	WORD	flag;
	char	mask[32];	/* read mask (*.*) */
	char	path[WMAXPATH];	/* current path	*/
	char	file[WMAXPATH];	/* archive file-name */
	char	arch[WMAXPATH];	/* path in archive */
      }	PATH;

typedef struct {
	int	count;  	/* number of blocks in buffer */
	int 	maxfb;		/* max fileblock in WSUB */
	WORD *	flag;
	char *	mask; 		/* read mask (*.*) */
	char *	path;		/* current path	*/
	char *	file;		/* archive file-name */
	char *	arch;		/* path in archive */
	FBLK **	fcb;		/* pointer to fileblocks */
      }	WSUB;

int _CType wsopen(WSUB *);
int _CType wsclose(WSUB *);
int _CType wsfree(WSUB *);
int _CType wsinit(WSUB *);
int _CType wslocal(WSUB *);
int _CType wsearch(WSUB *, const char *);
int _CType wschdrv(WSUB *, int __drv);
int _CType wschdir(WSUB *, const FBLK *);
int _CType wssetflag(WSUB *);
int _CType wscdroom(WSUB *);
void _CType wssort(WSUB *);
FBLK *_CType wsfblk(WSUB *, int __index);
FBLK *_CType wsffirst(WSUB *);
int _CType wsopenarch(WSUB *);
char *_CType wssavepath(WSUB *);
WSUB *_CType wsnew(const char *__path, const char *__mask, int __max);
int _CType wsread(WSUB *);
int _CType wsreadsub(WSUB *);
int _CType wsreadff(WSUB *, int __scan_attrib);
int _CType wsreadwf(WSUB *, int __scan_attrib);
int _CType wsdecomp(WSUB *, FBLK *, const char *__destpath);
int _CType wsmkdir(WSUB *, char *__directory);
int _CType wsmkdirlocal(const char *__directory);

typedef struct { /* Functions for archives (not used) */
	int 	(*read)(WSUB *);
	int 	(*add)(WSUB *, FBLK *, char *__srcpath);
	int 	(*del)(WSUB *, FBLK *);
	int 	(*copy)(WSUB *, FBLK *, char *__destpath);
	int 	(*move)(WSUB *, FBLK *, char *__destpath);
	int 	(*ren)(WSUB *, FBLK *, char *__newname);
      } WARC;

int _CType warjread(WSUB *);
int _CType wgzread(WSUB *);
int _CType wzipread(WSUB *);
int _CType wzipcopy(WSUB *, FBLK *, const char *__destpath);
int _CType wzipdel(WSUB *, FBLK *);

extern const char cp_stdmask[];

#ifdef __cplusplus
 }
#endif
#endif