/*
 * CONFIG.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <ini.h>
#include <string.h>
#include <errno.h>
#include <dzmain.h>

char programpath[MAXPATH];

#define PANELFLAG  	(_W_VISIBLE|_W_SORTTYPE|_W_HIDDEN)
#define CONFIGFLAG      (_C_AUTOSAVE|_C_SMALLPANELS|_C_INSMOVDN)

DZCFG config = {
	DZVERSION,
	CONFIGFLAG,
	0xFF,		/* BYTE: Confirm */
	0,		/* BYTE: Console */
	TV_HEXOFFSET,   /* BYTE: Text View */
	FS_SEARCHSUB,   /* BYTE: File Search */
	0,              /* WORD: Compress */
	{
		0,	/* PanelA: fcb[index] */
		0       /* PanelB: fcb[index] */
	},{
		0,      /* PanelA: panel[index] */
		0       /* PanelB: panel[index] */
	},{
		{	/* PanelA: PATH */
			PANELFLAG,
			"*.*",
			"C:\\DOSZIP",
			"",
			""
		},{     /* PanelB: PATH */
			PANELFLAG | _W_PANELID | _W_MINISTATUS,
			"*.*",
			"",
			"",
			""
		},
	},{ /* Operation Filter */
		0xFFFF, 0, 0, 0L, 0L, "*.*", ""
	},{ /* Default Color */
		{
			0x00,0x10,0x70,0x70,0x40,0x30,0x30,0x70
		},{
			0x00,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
			0x08,0x0B,0x00,0x00,0x0F,0x0A,0x0F,0x0F
		},{
			0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63
		}
	},{ /* Pending file -- to be deleted on startup */
		""
	}
};

int config_init(void)
{
	strcpy(programpath, configfile);
	*strrchr(programpath, '\\') = 0;
	if (argv_cfgpath != NULL && filexist(argv_cfgpath)) {
		strfcat(configfile, argv_cfgpath, "DZ.");
		configfile_extp = strrchr(configfile, '.');
		return 1;
	}
	if (envconf == NULL)
		return 1;
	strfcat(configfile, envconf, "DZ.");
	configfile_extp = strrchr(configfile, '.');
	return 1;
}

int config_read(void)
{
	int h,z,v;

	if ((h = iniopen(OPENCFG_READ)) != -1) {
		if (osread(h, &v, 2) != 2 || v > DZVERSION || v < DZMINVERS) {
			close(h);
			return 0;
		}
		z = osread(h, &config.dzflag, sizeof(DZCFG) - 2);
		close(h);
		if (z == sizeof(DZCFG) - 2)
			return 1;
	}
	return 0;
}

int config_write(void)
{
	int h, z;

	if ((h = iniopen(OPENCFG_WRITE)) != -1) {
		z = oswrite(h, &config, sizeof(DZCFG));
		close(h);
		return (z == sizeof(DZCFG));
	}
	return 0;
}

static int create_INI(void)
{
	int h;

	if ((h = iniopen(OPENINI_WRITE)) != -1) {
		oswrite(h, default_ini, strlen(default_ini));
		close(h);
	}
	return 1;
}

void init_tools(void)
{
	if (!filexist(filename_INI()))
		create_INI();
}

int cmsavesetup(void)
{
	if (rsmodal(IDD_SaveSetup)) {
		if (config_write() == 0)
			return stderror(filename_CFG(), EMEROPEN, 0);
		return 1;
	}
	return 0;
}