/*
 * CMOPTION.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dzmain.h>

enum {	P_INSMOVDN,
	P_SELECTDIR,
	P_CDCLRRDONLY,
	P_OK,
	P_CANCEL,
	P_COUNT		};

int cmpanel(void)
{
	DOBJ *d;
	TOBJ *o;

	if ((d = rsopen(IDD_Panel)) == 0)
		return 0;
/*** Init Dialog ***/
	o = &d->object[P_INSMOVDN];
	if (cflag & _C_INSMOVDN)
		o[P_INSMOVDN].flag |= _O_FLAGB;
	if (cflag & _C_SELECTDIR)
		o[P_SELECTDIR].flag |= _O_FLAGB;
	if (cflag & _C_CDCLRDONLY)
		o[P_CDCLRRDONLY].flag |= _O_FLAGB;
	tdinit(d);
/*** Get result ***/
	if (rsevent(IDD_Panel, d)) {
		cflag &= ~(_C_INSMOVDN|_C_SELECTDIR|_C_HORIZONTAL|_C_CDCLRDONLY);
		if (o[P_INSMOVDN].flag & _O_FLAGB)
			cflag |= _C_INSMOVDN;
		if (o[P_SELECTDIR].flag & _O_FLAGB)
			cflag |= _C_SELECTDIR;
		if (o[P_CDCLRRDONLY].flag & _O_FLAGB)
			cflag |= _C_CDCLRDONLY;
		tdclose(d);
		return 1;
	}
	tdclose(d);
	return 0;
}

enum {	CO_COPY,
	CO_MOVE,
	CO_DELETE,
	CO_DELSUBDIR,
	CO_DELSYSTEM,
	CO_DELHIDDEN,
	CO_EXIT,
	CO_OK,
	CO_CANCEL,
	CO_COUNT	};

int cmconfirm(void)
{
	DOBJ *d;

	if ((d = rsopen(IDD_Confirm)) == NULL)
		return 0;
	tdsetbitflag(d->object, CO_OK, _O_FLAGB, config.confirm);
	tdinit(d);
	if (rsevent(IDD_Confirm, d) != 0)
		config.confirm = tdgetbitflag(d->object, CO_OK, _O_FLAGB);
	twclose(d);
	return 0;
}

enum {  D_SCREEN,
	D_PANELS,
	D_CONFIRM,
	D_COMPRESS,
	D_AUTOSAVE,
	D_OK,
	D_CANCEL,
	D_COUNT		};

int cmoptions(void)
{
	DOBJ *d;
	TOBJ *o;
	int result;

	if ((d = rsopen(IDD_Configuration)) == 0)
		return 0;
/*** Init Dialog ***/
	o = d->object;
	o[D_SCREEN].proc = cmscreen;
	o[D_PANELS].proc = cmpanel;
	o[D_CONFIRM].proc = cmconfirm;
	o[D_COMPRESS].proc = cmcompression;
	if (cflag & _C_AUTOSAVE)
		o[D_AUTOSAVE].flag |= _O_FLAGB;
	tdinit(d);
	result = rsevent(IDD_Configuration, d);
	if (result) {
		cflag &= ~_C_AUTOSAVE;
		if (o[D_AUTOSAVE].flag & _O_FLAGB)
			cflag |= _C_AUTOSAVE;
	}
	tdclose(d);
	if (result)
		redraw_panels();
	return result;
}