/*
 * TLISTOBJ.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <tlistobj.h>
#include <tdialog.h>
#include <keydefs.h>
#include <mouse.h>

DOBJ *lo_dialog;
int lo_celcount; /* visible cells */
int lo_celindex; /* index from cell one (dialog->index) */
int lo_dlgcount; /* number of list-object in dialog (0..count) */
int lo_objcount; /* total number of items in list */
int lo_objindex; /* index in list buffer */

int (*lo_setcel)(void);

int lo_eventup(void)
{
	if (lo_dialog->index != 0) {
		lo_dialog->index = 0;
		return 1;
	}
	if (lo_objindex) {
		lo_objindex--;
		return lo_setcel();
	}
	return 0;
}

int lo_eventdn(void)
{
	if (lo_objcount - lo_objindex - lo_dlgcount < 1)
		return 0;
	if (lo_dialog->index != lo_dlgcount - 1) {
		lo_dialog->index = lo_dlgcount - 1;
		return 1;
	}
	if (lo_objcount - lo_objindex - lo_celindex > 1) {
		lo_objindex++;
		return lo_setcel();
	}
	return 0;
}

int lo_exevent(void)
{
	int result;

	lo_celindex = lo_dialog->index;
	result = tdxcellevent(lo_dialog, &lo_dialog->object[lo_celindex]);

	switch (result) {
	case TAB:
		lo_dialog->index = lo_dlgcount - 1;
		break;
	case DOWN:
		if (lo_celindex == lo_dlgcount - 1)
			return lo_eventdn();
		break;
	case UP:
		if (lo_celindex == 0)
			return lo_eventup();
		break;
	case PGUP:
		if (lo_objindex > lo_dlgcount) {
			lo_objindex -= lo_dlgcount;
			lo_setcel();
			break;
		}
	case HOME:
		if (lo_objindex) {
			lo_objindex = 0;
			lo_setcel();
		} else if (lo_celindex) {
			lo_dialog->index = 0;
			lo_setcel();
		}
		break;
	case PGDN:
		if (lo_celindex != lo_celcount - 1) {
			lo_dialog->index = lo_celcount - 1;
			lo_setcel();
			break;
		}
		if (lo_objindex + lo_celindex + lo_dlgcount < lo_objcount) {
			lo_objindex += lo_dlgcount;
			lo_setcel();
			break;
		}
	case END:
		if (lo_objindex != lo_objcount - lo_dlgcount) {
			lo_objindex = MAX(lo_objcount - lo_dlgcount, 0);
			lo_setcel();
		}
	default:
		break;
	}
	return result;
}

int lo_mousescroll(int (*proc)(void))
{
	while (mousep() && proc()) {
		scroll_delay();
		scroll_delay();
	}
	while (mousep());
	return _C_NORMAL;
}

int lo_mouseup(void)
{
	return lo_mousescroll(lo_eventup);
}

int lo_mousedn(void)
{
	return lo_mousescroll(lo_eventdn);
}

int lo_eventopen(void)
{
	if (lo_celindex >= lo_dlgcount) {
		stdmsg("TDialog", "No item selected\n");
		return _C_NORMAL;
	}
	return _C_RETURN;
}

int lo_open(ROBJ *rp, int dlgcount, int (*proc)(void))
{
	int x;
	TOBJ *o;

	if ((lo_dialog = rsopen(rp)) == NULL)
		return 0;

	lo_celcount = 0;
	lo_dlgcount = dlgcount;
	lo_celindex = dlgcount;
	lo_setcel = proc;

	o = lo_dialog->object;
	for (x = 0; x < lo_dlgcount; x++)
		o[x].proc = lo_exevent;

	return 1;
}
