/*
 * TGETLINE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <rect.h>
#include <wchar.h>
#include <color.h>
#include <keydefs.h>
#include <mouse.h>
#include <tdialog.h>

int tgetline(const char *title, char *buf, int lsize, int bsize)
{
	DOBJ wb;
	RECT rc;
	int result, q;

	wb.rc.col = lsize + 8;
	wb.rc.row = 5;
	wb.rc.x	  = 40 - wb.rc.col / 2;
	wb.flag	  = _D_STDDLG;
	wb.rc.y	  = 5;
	rc.col 	  = lsize;
	rc.row    = 1;
	rc.x	  = 4;
	rc.y	  = 2;
	result    = 0;

	if (twopen(&wb, at_Dialog, title)) {
		wcputa(rcbprc(wb.wp, rc, wb.rc.col), rc.col, 0x07);
		twshow(&wb);
		while (mousep());
		q = 0;
		while (q != ESC) {
			q = tdedit(buf, rcaddrc(wb.rc, rc), bsize, 1);
			if (q == ENTER || (WORD)q == KPENTER) {
				result = 1;
				break;
			}
			if (q == MOUSECMD) {
				if (rcxyrow(wb.rc, mousex(), mousey()))
					twmove(&wb);
				else
					break;
			}
		}
	}
	twclose(&wb);
	return result;
}
