;
; CMPWARG.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc
INCLUDE		string.inc

PPROC		cmpwarg
USES		DS,si,di
LOCAL		efile:	WORD,\
		emask:	WORD
ARG		filep:	DPTR,\
		maskp:	DPTR
		mov	di,'.'
		push	maskp
		push	di
		call	strrchr
		mov	emask,ax
		push	filep
		push	di
		call	strrchr
		mov	efile,ax
		MLDS	si,filep
		MLES	di,maskp
next:		lodsb
		mov	ah,ES:[di]
		inc	di
		or	al,al
		jz	SHORT file_zero
		or	ah,ah
		jz	SHORT file_zero
		cmp	ah,'.'
		jz	SHORT mask_ext
		cmp	al,'.'
		jz	SHORT error
		cmp	ah,'?'
		jz	SHORT next
		cmp	ah,'*'
		jz	SHORT test_mext
		or	ax,2020h
		cmp	ah,al
		jz	SHORT next
		jmp	SHORT error
mask_ext:	cmp	al,'.'
		jz	SHORT test_ext
		jmp	SHORT error
test_mext:	mov	di,emask
		or	di,di
		jz	SHORT success
		cmp	ES:[di+1],ah
		jz	SHORT success
test_ext:       mov	di,emask
		mov	si,efile
nextext:	lodsb
		mov	ah,ES:[di]
		inc	di
		or	al,al
		jz	SHORT file_zero
		or	ah,ah
		jz	SHORT file_zero
		cmp	ah,'?'
		jz	SHORT nextext
		cmp	ah,'*'
		jz	SHORT success
		or	ax,2020h
		cmp	ah,al
		jz	SHORT nextext
		jmp	SHORT error
file_zero:	or	ax,ax
		jnz	SHORT error
success:        mov	ax,1
		jmp	SHORT toend
error:		xor	ax,ax
toend:		ret
PEND		cmpwarg

		END
