/*
 * CONFIRMD.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <arch.h>
#include <dialog.h>

extern ROBJ *IDD_ConfirmDelete;
extern const char
	cp_delselected	[], /*    You have selected %d file(s)\n */
			    /* Do you want to delete all the files */
	cp_delrdonly	[], /* The following file is marked Read only. */
	cp_delsystem	[], /* The following file is marked System. */
	cp_delflag	[], /* Do you still wish to delete it? */
	cp_dodelete	[]; /* Do you wish to delete */

#define ID_DELETE	1
#define ID_DELETEALL	2
#define ID_SKIPFILE	3
#define ID_CANCEL	4

int confirmflag;

int confirm_delete(const char *info, int selected)
{
	int x,y;
	int result;
	DOBJ *d;

	if ((d = rsopen(IDD_ConfirmDelete)) == NULL)
		return 0;
	twshow(d);
	x = d->rc.x;
	y = d->rc.y;
	if (selected > 1) {
		scputf(x + 12, y + 2, 0, 0, cp_delselected, selected);
	} else if (selected == MSG_DELSYSTEM) {
		scputs(x + 12, y + 2, 0, 0, cp_delsystem);
		scenter(x + 3, y + 3, 53, info);
		scputs(x + 14, y + 4, 0, 0, cp_delflag);
	} else if (selected == MSG_DELRDONLY) {
		scputs(x + 10, y + 2, 0, 0, cp_delrdonly);
		scenter(x + 3, y + 3, 53, info);
		scputs(x + 14, y + 4, 0, 0, cp_delflag);
	} else {
		scputs(x + 18, y + 2, 0, 0, cp_dodelete);
		scenter(x + 3, y + 3, 53, info);
	}
	beep(50, 6);
	result = rsevent(IDD_ConfirmDelete, d);
	tdclose(d);
	return result;
}