#
# RULES.MAK
#
# This file is part of DOSZIP
# Copyright (c) 1996 Hjort Nidudsson.
#

# Turn on autodependency checking
#.autodepend

# Let MAKE know where to find all the appropriate files

DOSZIP=\doszip
LIB=$(DOSZIP)\lib
INC=$(DOSZIP)\inc
SRC=$(DOSZIP)\src\clib\$(SUBD)

# Set up memory model macros depending on version we are makeing (s,c,m,l,h)

MODEL = l

# Name of the library files to create (Release/Debug)

LIBR = $(LIB)\C$(MODEL)
LIBD = $(LIB)\DEBUG\C$(MODEL)

# Declare compiler and flags

CC=bcc		# name of C compiler
AC=tasm		# name of assembler
LC=tlib 	# name of librarian
BCCR=-R -O1 -Og -k- -d
BCCD=-v -y -DDEBUG -wpro -weas -wpre -R -n$(SRC)
TSMR=/I$(INC)\asm /m /ml /t /q /D__$(MODEL)__ $*,*.obj
TSMD=/I$(INC)\asm /zi /z /w2 /m /ml /t /d__$(MODEL)__ /DDEBUG $(SRC)\$*,*.obj

# Implicit rules to make the object files for the library

.cpp.obj:
	@if exist $*.obj del $*.obj
	$(CC) $(BCCR) $*.cpp
	$(LC) $(LIBR) -+$*

.c.obj:
	@if exist $*.obj del $*.obj
	$(CC) $(BCCR) $*.c
	$(LC) /0 /C $(LIBR) -+$*
	$(CC) $(BCCD) $(SRC)\$*.c
	$(LC) /E /C $(LIBD) -+$(SRC)\$*

.asm.obj:
	@if exist $*.obj del $*.obj
	$(AC) $(TSMR)
	$(LC) /0 /C $(LIBR) -+$*
	$(AC) $(TSMD)
	$(LC) /E /C $(LIBD) -+$*

all: turboc.cfg $(OBJS) clean

clean:
	@echo Delete objects...
	@del *.obj
	@del $(LIBR).BAK
	@del $(LIBD).BAK
	@del turboc.cfg

turboc.cfg: makefile.mak
  copy &&|
-c
-m$(MODEL)
-I$(INC)
-L$(LIB)
-3
-a
-p
-zC_TEXT
-zR_DATA
-zD_BSS
-zSDGROUP
-P-.C
| turboc.cfg