;
; C0.ASM -- Start Up Code for DOS
;
; C/C++ Run Time Library - Version 5.0
;
; Copyright (c) 1987, 1992 by Borland International
; All Rights Reserved.
;

		locals

		__C0__ = 1
INCLUDE         RULES.ASI

_TEXT		SEGMENT	BYTE PUBLIC 'CODE'
		ENDS
IFDEF	DEBUG
_FARDATA        SEGMENT PARA PUBLIC 'FAR_DATA'
		ENDS
_FARBSS         SEGMENT PARA PUBLIC 'FAR_BSS'
		ENDS
IFNDEF __TINY__
_OVERLAY_	SEGMENT PARA PUBLIC 'OVRINFO'
		ENDS
_1STUB_		SEGMENT PARA PUBLIC 'STUBSEG'
		ENDS
ENDIF
ENDIF

_DATA           SEGMENT PARA PUBLIC 'DATA'
		ENDS
_INIT_  	SEGMENT	WORD PUBLIC 'INITDATA'
InitStart	LABEL 	BYTE
		ENDS
_INITEND_       SEGMENT	BYTE PUBLIC 'INITDATA'
InitEnd		LABEL 	BYTE
		ENDS
_EXIT_          SEGMENT	WORD PUBLIC 'EXITDATA'
ExitStart       LABEL 	BYTE
		ENDS
_EXITEND_       SEGMENT	BYTE PUBLIC 'EXITDATA'
ExitEnd		LABEL 	BYTE
		ENDS
IFDEF	DEBUG
_CVTSEG         SEGMENT WORD PUBLIC 'DATA'
		ENDS
_SCNSEG         SEGMENT WORD PUBLIC 'DATA'
		ENDS
ENDIF
IFNDEF __HUGE__
_BSS		SEGMENT WORD PUBLIC 'BSS'
		ENDS
_BSSEND		SEGMENT BYTE PUBLIC 'BSSEND'
		ENDS
ENDIF

IFNDEF __TINY__
_STACK		SEGMENT STACK 'STACK'
		ENDS
ENDIF

		ASSUME  CS:_TEXT, DS:DGROUP

;;;;;;; The libary use Pascal Calling Convention

		EXTRN	main	:	DIST
		EXTRN	exit	:	DIST
		EXTRN	_stklen	:	WORD
		EXTRN	_nfile	: 	WORD
	IFND	EXTRN   _heaplen:	WORD

;;;;;;; New IO-functions

		EXTRN	_ioinit :	NEAR

PSPhigh		= 	0002h	; Highest Memory Segment Addr
PSPenv		= 	002Ch	; Environment Segment address
PSPcmd		=	0080h
MinStack        =	128     ; Minimal stack size in words

_TEXT		SEGMENT
;
;       At the start, DS and ES both point to the SEGMENT prefix.
;       SS points to the stack SEGMENT except in TINY model where
;       SS is equal to CS
;

IFDEF   __TINY__
		ORG     100h
ENDIF

START		PROC	NEAR

;       Save general information, such as :
;               DGROUP SEGMENT address
;               DOS version number
;               Program Segment Prefix address
;               Environment address
;               Top of far heap

IFDEF   __TINY__
		mov     dx,CS          	; DX = GROUP Segment address
ELSE
		mov	dx,DGROUP
ENDIF
		mov	CS:DGROUP@,dx
		mov	ah,30h
		int	21h  		; get DOS version number
		mov  	bp,DS:[PSPhigh] ; BP = Highest Memory Segment Addr
		mov	bx,DS:[PSPenv]  ; BX = Environment Segment address
		mov	DS,dx
		mov	_osversion,ax	; Keep major and minor version number
		mov	_psp,ES         ; Keep Program Segment Prefix address
		mov	envseg,bx       ; Keep Environment Segment address
		mov	WORD PTR [_heaptop+2],bp
;
;       Save several vectors and install default divide by zero handler.
;
		call	savevectors

;       Count the number of environment variables and compute the size.
;       Each variable is ended by a 0 and a zero-length variable stops
;       the environment. The environment can NOT be greater than 32k.

		mov	ax,envseg
		mov	ES,ax
		xor	ax,ax
		mov	bx,ax
		mov	di,ax
		mov	cx,7fffh	; Environment cannot be > 32 Kbytes
		cld
@@envloop:	repnz	scasb
		jcxz	@@initfail      ; Bad environment !!!
		inc	bx              ; BX = Nb environment variables
		cmp	ES:[di],al
		jne	SHORT @@envloop ; Next variable ...
@@envlen:	or	ch,10000000b
		neg     cx
		mov   	envlen,cx       ; Save Environment size

		mov	cx,DPTRZ / 2
		shl	bx,cl
		add	bx,DPTRZ * 4
		and	bx,not ((DPTRZ * 4) - 1)
		mov	envsize,bx      ; Save Environment Variables Nb.
;
;       Determine the amount of memory that we need to keep
;

	IFND	mov	dx,DS
	IFFD	mov	dx,SS
		sub	bp,dx		; BP = remaining size in paragraphs
	IFFD	mov	di,SEG _stklen
	IFFD	mov	ES,di
	IFFD	mov	di,ES:_stklen 	; DI = Requested stack size
	IFND	mov	di,_stklen 	; DI = Requested stack size

;
; Make sure that the requested stack size is at least MINSTACK words.
;
		cmp     di,2*MinStack	; requested stack big enough ?
		jae     SHORT @@stackok
		mov     di,2*MinStack	; no --> use minimal value
	IFFD	mov     ES:_stklen,di 	; override requested stack size
	IFND	mov     _stklen,di

@@stackok:
	IFND	add	di,OFFSET DGROUP:edata@
	IFND	jb	SHORT @@initfail
	IFND	add     di,_heaplen
	IFND	jb	SHORT @@initfail

		mov	cl,4
		shr	di,cl
		inc	di
		cmp	bp,di
IFDEF 	LDATA
		jnb     SHORT @@resize
ELSE
		jb	SHORT @@initfail
		cmp	_stklen,0
		je	SHORT @@expand_ds	; Expand DS up to 64 Kb
		cmp	_heaplen,0
		jne	SHORT @@resize
@@expand_ds:	mov	di,1000h
		cmp	bp,di
		ja	SHORT @@resize
		mov	bp,di
		jmp     SHORT @@resize
ENDIF

; All initialization errors arrive here

@@initfail:	jmp	_abort
;
;       Return to DOS the amount of memory in excess
;       Set far heap base and pointer
;
@@resize:      	mov	bx,di
		add	bx,dx
		mov	WORD PTR [_heapbase+2],bx
		mov	WORD PTR [_brklvl+2],bx
		mov	ax,_psp
		sub	bx,ax	; BX = Number of paragraphs to keep
		mov	ES,ax   ; ES = Program Segment Prefix address
		push	di      ; preserve DI
		mov	ax,4A00h
		int	21h     ; this call clobbers SI,DI,BP !!!!!!
		pop	di      ; restore  DI
		shl	di,cl   ; $$$ CX is still equal to 4 $$$

		cli		; req'd for pre-1983 88/86s
		mov	SS,dx   ; Set the program stack
		mov	sp,di
		sti

	IFFD	mov	ax,SEG _stklen
	IFFD	mov	ES,ax
	IFFD	mov	ES:_stklen,di ; If separate stack SEGMENT, save size

IFNDEF  __HUGE__

;	Reset uninitialized data area

		xor	ax,ax
		mov	ES,CS:DGROUP@
		mov	di,OFFSET DGROUP:bdata@
		mov	cx,OFFSET DGROUP:edata@
		sub	cx,di
		cld
	rep	stosb

ENDIF

; If default number of file handles have changed then tell DOS

		cmp	_nfile,20
		jbe	SHORT @@nochange
		cmp	_osmajor,3		; Check for >= DOS 3.3
		jb	SHORT @@nochange
		ja	SHORT @@dochange
		cmp	_osminor,1Eh
		jb	SHORT @@nochange

@@dochange:	mov	ax,5801h	; Set last fit allocation
		mov	bx,2
		int	21h
		jc	SHORT @@badinit

		mov	ah,67h		; Expand handle table
		mov	bx,_nfile
		int	21h
		jc	SHORT @@badinit

		mov	ah,48h		; Allocate 16 bytes to find new
		mov	bx,1		; top of memory address
		int	21h
		jc	SHORT @@badinit
		inc	ax
		mov	WORD PTR [_heaptop+2],ax

		dec	ax 		; Change back and release block
		mov	ES,ax
		mov	ah,49h
		int	21h

		mov	ax,5801h	; Set last fit allocation
		mov	bx,0
		int	21h
		jnc	SHORT @@nochange

@@badinit:	jmp	_abort

@@nochange:	xor	bp,bp		; set BP to 0 for overlay mgr
		mov	ES,CS:DGROUP@
		mov	si,OFFSET DGROUP:InitStart ;si = start of table
		mov	di,OFFSET DGROUP:InitEnd   ;di = end of table
		call	initialize

;;;;;;; main([char *env[],] int argc, char *argv[]));

	IFFD	push    [c0environ+2]
		push    c0environ
		push    c0argc
	IFFD	push    [c0argv+2]
		push    c0argv
callmain:	call	main

;       Flush and close streams and files

		push	ax
		call	exit

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Call cleanup routines
;
; _cleanup()      call all #pragma exit cleanup routines.
; _checknull()    check for null pointer zapping copyright message
; _terminate(int) exit program with error code
;
; These functions are called by exit(), _exit(), _cexit(),
; and _c_exit().
;

_cleanup       	PROC   	DIST
		PUBLIC 	_cleanup
		mov	ES,WORD PTR CS:DGROUP@
		push	si
		push	di
		mov	si,OFFSET DGROUP:ExitStart
		mov	di,OFFSET DGROUP:ExitEnd
		call	cleanup
		pop	di
		pop	si
		ret
_cleanup	ENDP

; Check for null pointers before exit

_checknull	PROC    DIST
		PUBLIC	_checknull
IFDEF	DEBUG
    IFNDEF LDATA
	IFNDEF  __TINY__
		push	si
		push	di
		xor	ax,ax
		mov	si,ax
		mov	cx,16
@@add:		add	al,[si]
		adc	ah,0
		inc	si
		loop	@@add
		sub	ax,checksum
		jz      SHORT @@ok
		mov	cx,sizenullmsg
		mov	dx,OFFSET DGROUP:nullcheck
		call	stderrmsg
@@ok:        	pop     di
		pop	si
	ENDIF
    ENDIF
ELSE
		xor	ax,ax
ENDIF
		ret
_checknull	ENDP

;       Exit to DOS

_terminate     	PROC    DIST
		PUBLIC  _terminate
		mov     bp,sp
IFDEF LPROG
		mov     ax,[bp+4]
ELSE
		mov     ax,[bp+2]
ENDIF
		mov     ah,4ch
		int     21h                     ; Exit to DOS
_terminate     	ENDP

START		ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Vector save/restore & default Zero divide routines

zerodivision	PROC    FAR
		mov	cx,sizezeromsg
		mov	dx,OFFSET DGROUP:zerodivmsg
		call	stderrmsg
		mov	ax,3
		push	ax
		call	exit
zerodivision	ENDP

;;;;;;; INT 24 C - DOS 1+ - CRITICAL ERROR HANDLER
;
; invoked when a critical (usually hardware) error is encountered by DOS
;
; Values for critical error handler action code:
;   00h	ignore error and continue processing request
;   01h	retry operation
;   02h	terminate program as though INT 21/AH=4Ch
; * 03h	fail system call in progress (DOS 3+)
;
int24:		push	DS
		mov	DS,CS:DGROUP@
		mov	[sys_erflag],ah
		mov	[sys_erdrive],al
		mov	ax,di          		; DI low byte contains
		mov	ah,0                    ; error code if AH bit 7 set
		mov	[sys_ercode],ax
		mov	WORD PTR [sys_erdevice],si
		mov	WORD PTR [sys_erdevice+2],bp
		pop	DS
		mov	ax,3
		iret

savevectors	PROC	NEAR
		push	DS

		mov	ax,3500h			; INT 0
		int	21h
		mov	WORD PTR interrup00,bx
		mov	WORD PTR interrup00 + 2,ES

		mov	ax,3504h                        ; INT 4
		int	21h
		mov	WORD PTR interrup04,bx
		mov	WORD PTR interrup04 + 2,ES

		mov	ax,3505h                        ; INT 5
		int	21h
		mov	WORD PTR interrup05,bx
		mov	WORD PTR interrup05 + 2,ES

		mov	ax,3506h                        ; INT 6
		int	21h
		mov	WORD PTR interrup06,bx
		mov	WORD PTR interrup06 + 2,ES

		mov	ax,3524h                        ; INT 24
		int	21h
		mov	WORD PTR interrup24,bx
		mov	WORD PTR interrup24 + 2,ES

		mov	ax,2500h ; Install default divide by zero handler.
		mov	dx,CS
		mov	DS,dx
		mov	dx,OFFSET zerodivision
		int	21h

		mov	ax,2524h ; Install default error handler.
		mov	dx,CS
		mov	DS,dx
		mov	dx,OFFSET int24
		int	21h

		pop	DS
		ret
savevectors	ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; _restorezero() puts back all the vectors that SaveVectors took.
;
;NOTE : TSRs must BE AWARE that signal() functions which take these
;       vectors will be deactivated if the keep() function is executed.
;       If a TSR wants to use the signal functions when it is active it
;       will have to save/restore these vectors itself when activated and
;       deactivated.
;
_restorezero	PROC   	DIST
		PUBLIC 	_restorezero
IFDEF   __HUGE__
		push    DS
		mov     DS,CS:DGROUP@
ENDIF
		push	DS
		mov     ax,2500h
		lds	dx,interrup00
		int	21h
		pop	DS

		push	DS
		mov     ax,2504h
		lds	dx,interrup04
		int	21h
		pop	DS

		push	DS
		mov     ax,2505h
		lds	dx,interrup05
		int	21h
		pop	DS

		push	DS
		mov     ax,2506h
		lds	dx,interrup06
		int	21h
		pop	DS

		push	DS
		mov     ax,2524h
		lds	dx,interrup24
		int	21h
		pop	DS

		ret
_restorezero	ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;  Loop through a startup/exit (SE) table,
;  calling functions in order of priority.
;  ES:SI is assumed to point to the beginning of the SE table
;  ES:DI is assumed to point to the end of the SE table
;
pnear           EQU     0
pfar            EQU     1
notused         EQU     0ffh

se      	STRUC
		calltype	DB ?   ; 0=NEAR,1=FAR,FF=not used
		priority	DB ?   ; 0=HIGHEST,FF=lowest
		addrlow         DW ?
		addrhigh        DW ?
se		ENDS


initialize	PROC 	NEAR
@@start:	mov	ax,0100h 	; start with lowest priority
		mov	dx,di           ; set sentinel to end of table
		mov	bx,si           ; bx = start of table
@@topoftable:	cmp	bx,di           ; and the end of the table?
		je	SHORT @@endoftable ; yes, exit the loop
		cmp	ES:[bx.calltype],notused
		je     	SHORT @@next
		mov	cl,ES:[bx.priority]
		xor	ch,ch
		cmp	cx,ax
		jae	SHORT @@next
		mov	ax,cx
		mov	dx,bx
@@next:         add	bx,SIZE se
		jmp	SHORT @@topoftable
@@endoftable:	cmp	dx,di
		je	SHORT @@done
		mov	bx,dx
		cmp	ES:[bx.calltype],pnear  ;is it near or far?
		mov	ES:[bx.calltype],notused;wipe the call type
		push	ES
		je	SHORT @@nearcall
@@farcall: 	call	DWORD PTR ES:[bx.addrlow]
		pop	ES
		jmp	SHORT @@start
@@nearcall:     call	WORD PTR ES:[bx.addrlow]
		pop	ES
		jmp	SHORT @@start
@@done:		ret
initialize	ENDP

cleanup		PROC	NEAR
@@start:	mov	ah,0
		mov	dx,di
		mov	bx,si
@@topoftable:	cmp	bx,di
		je	@@endoftable
		cmp	ES:[bx.calltype],notused
		je	@@next
		cmp	ES:[bx.priority],ah
		jb	@@next
		mov	ah,ES:[bx.priority]
		mov	dx,bx
@@next:         add	bx,SIZE se
		jmp	@@topoftable
@@endoftable:	cmp	dx,di
		je	@@done
		mov	bx,dx
		cmp	ES:[bx.calltype],pnear
		mov	ES:[bx.calltype],notused
		push	ES
		je	SHORT @@nearcall
@@farcall: 	call	DWORD PTR ES:[bx.addrlow]
		pop	ES
		jmp	SHORT @@start
@@nearcall:     call	WORD PTR ES:[bx.addrlow]
		pop	ES
		jmp	SHORT @@start
@@done:		ret
cleanup		ENDP

stderrmsg	PROC	NEAR	; ErrorDisplay
		PUBLIC	stderrmsg
		mov	ah,40h	; WRITE TO FILE OR DEVICE
		mov	bx,2    ; BX = file handle (stderr)
		int	21h     ; CX = number of bytes to write
		ret             ; DS:DX -> data to write
stderrmsg	ENDP

_abort		PROC	DIST
		PUBLIC  _abort
		mov	cx,sizeabortmsg
		mov	dx,OFFSET DGROUP:abortmsg
		call	stderrmsg
		mov	ax,3
		push	ax
		call	exit
_abort		ENDP


;
; The DGROUP@ variable is used to reload DS with DGROUP
;
		PUBLIC	DGROUP@
DGROUP@		DW	?

IFDEF	DEBUG

;bit masks to extract default pointer types from MMODEL (at run-time)

FCODE           EQU     8000h
FDATA           EQU     4000h

IFDEF   __TINY__                ; Small Code - Small Data
	MMODEL          EQU     0
ENDIF
IFDEF   __SMALL__               ; Small Code - Small Data
	MMODEL          EQU     1
ENDIF
IFDEF   __MEDIUM__              ; Large Code - Small Data
	MMODEL          EQU     FCODE+2
ENDIF
IFDEF   __COMPACT__             ; Small Code - Large Data
	MMODEL          EQU     FDATA+3
ENDIF
IFDEF   __LARGE__               ; Large Code - Large Data
	MMODEL          EQU     FCODE+FDATA+4
ENDIF
IFDEF   __HUGE__                ; Large Code - Large Data
	MMODEL          EQU     FCODE+FDATA+5
ENDIF

; __MMODEL is used to determine the memory model or the default
; pointer types at run time.
		PUBLIC __MMODEL
__MMODEL        DW      MMODEL

ENDIF

_TEXT		ENDS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

_DATA		SEGMENT

; Magic symbol used by the debug info to locate the data segment
		PUBLIC 	DATASEG@
DATASEG@        LABEL   BYTE

; The CopyRight string must NOT be moved or changed without
; changing the null pointer check logic

CopyRight       DB      4 dup(0)
		DB      'Borland C++ - Copyright 1991 Borland Intl.',0
lgth_CopyRight  EQU     $ - CopyRight

IFDEF	DEBUG
    IFNDEF LDATA
	IFNDEF  __TINY__
	checksum	=	00D5Ch
	nullcheck       DB      'Null pointer assignment', 13, 10, 0
	sizenullmsg	=	$ - nullcheck
	ENDIF
    ENDIF
ENDIF ; DEBUG

zerodivmsg	DB	'Divide error', 13, 10
sizezeromsg	EQU	$ - zerodivmsg

abortmsg	DB	'Abnormal program termination', 13, 10
sizeabortmsg	=	$ - abortmsg

		;--------------------------------------------------

interrup00	DD	00000000h ; CPU-generated - DIVIDE ERROR
interrup04	DD	00000000h ; CPU-generated - INTO DETECTED OVERFLOW
interrup05	DD	00000000h ; PRINT SCREEN
interrup06	DD	00000000h ; CPU-generated (80286+) - INVALID OPCODE
interrup24	DD	00000000h ; CRITICAL ERROR HANDLER

		;--------------------------------------------------

		PUBLIC	c0argc
		PUBLIC	c0argv
c0argc		DW	0
c0argv		DW	0
	IFFD	DW	0

		PUBLIC	c0environ
c0environ	DW	0
	IFFD	DW	0
		PUBLIC	envseg
envseg		DW 	0
		PUBLIC	envlen
envlen	  	DW 	0
		PUBLIC	envsize
envsize	  	DW 	0
		PUBLIC	_psp
_psp		DW 	0

		PUBLIC	_osminor
		PUBLIC	_osmajor
		PUBLIC	_osversion
_osversion	LABEL	WORD
_osmajor	DB	0
_osminor	DB	0

		; Whenever an error in a system call occurs,
		; errno is set to a value from 0 to sys_nerr
		; by dosmaper(doserrno);
		PUBLIC	errno
		PUBLIC	doserrno
errno		DW	0
doserrno	DW	0

		;--------------------------------------------------
		; critical error handler
		PUBLIC  sys_erdevice
		PUBLIC  sys_ercode
		PUBLIC  sys_erflag
		PUBLIC  sys_erdrive
sys_erdevice    DD	00000000h
sys_ercode	DW	0
sys_erflag	DB	0
sys_erdrive	DB	0

		;--------------------------------------------------
		; Memory management variables

IFNDEF LDATA
		PUBLIC	__heapbase
__heapbase	DW      DGROUP:edata@
ENDIF
IFNDEF __HUGE__
		PUBLIC	__brklvl
__brklvl	DW      DGROUP:edata@
ENDIF
		PUBLIC	_heaptop
		PUBLIC	_heapbase
		PUBLIC	_brklvl
_heaptop	DD	0
_heapbase	DD      0
_brklvl		DD      0

_DATA		ENDS

IFDEF	DEBUG
_CVTSEG		SEGMENT
		PUBLIC	__RealCvtVector
__RealCvtVector	LABEL		WORD
		ENDS
_SCNSEG		SEGMENT
		PUBLIC	__ScanTodVector
__ScanTodVector	LABEL		WORD
		ENDS
ENDIF

IFNDEF __HUGE__
_BSS		SEGMENT
bdata@ 		LABEL		BYTE
		ENDS
_BSSEND 	SEGMENT
edata@ 		LABEL		BYTE
		ENDS
ENDIF

IFNDEF __TINY__
_STACK		SEGMENT
		DB		128 dup(?)
		ENDS
ENDIF

		END	START
