include	clib.inc
include	keyb.inc
include	conio.inc
include	mouse.inc
include	dos.inc
include	format.inc

	public	tdialog
	public	tdllist
	public	dlpbuttevent
	public	dlradioevent
	public	dlcheckevent
	public	dlxcellevent
	public	dlteditevent
	public	dlmenusevent

USE_MDALTKEYS	= 1

_TEXT  	SEGMENT

dummy_update PROC
	xor	ax,ax
	ret
dummy_update ENDP

tdshortkey PROC
	push	ax
	test	es:[bx.to_flag],_O_DEACT
	jnz	tdshortkey_nokey
	cmp	es:[bx.to_ascii],0
	je	tdshortkey_nokey
	and	al,0DFh
	cmp	es:[bx.to_ascii],al
	je	tdshortkey_found
	mov	al,es:[bx.to_ascii]
	and	al,0DFh
	sub	al,'A'
	push	bx
	mov	bh,0
	mov	bl,al
	cmp	ah,[bx+key_scancode]
	pop	bx
	jne	tdshortkey_nokey
    tdshortkey_found:
	or	ax,1
	jmp	tdshortkey_end
    tdshortkey_nokey:
	xor	ax,ax
    tdshortkey_end:
	pop	ax
	ret
tdshortkey ENDP

handle_event PROC
	test	ax,ax
	jnz	handle_event_do
	ret
    handle_event_do:
	push	si
	push	di
	xor	dx,dx
	mov	si,dx
	mov	cx,dx
	les	bx,tdialog
	mov	cl,es:[bx.dl_count]
	MLES	bx,es:[bx.dl_object]
	cmp	ax,KEY_F1
	je	handle_event_help
	test	cl,cl
	jz	handle_event_null
    handle_event_loop:
	test	es:[bx.to_flag],_O_GLCMD
	jz	handle_event_shkey
	mov	dx,word ptr es:[bx.to_data]
	mov	di,word ptr es:[bx.to_data+2]
    handle_event_shkey:
	call	tdshortkey
	jnz	handle_event_si_to_index
	add	bx,16
	inc	si
	dec	cx
	jnz	handle_event_loop
	test	dx,dx
	jz	handle_event_null
	mov	bx,dx
	mov	es,di
    handle_event_gloop:
	cmp	es:[bx.gl_key],0
	jz	handle_event_null
	cmp	es:[bx],ax
	je	handle_event_found
	add	bx,size S_GLCMD
	jmp	handle_event_gloop
    handle_event_found:
	call	es:[bx.S_GLCMD.gl_proc]
	jmp	handle_event_end
    handle_event_null:
	xor	ax,ax
	jmp	handle_event_end
    handle_event_si_to_index:
	test	es:[bx.to_flag],_O_PBKEY
	mov	ax,si
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	mov	ax,_C_RETURN
	jnz	handle_event_end
    handle_event_one:
	mov	ax,_C_NORMAL
    handle_event_end:
	mov	result,ax
	pop	di
	pop	si
	ret
    handle_event_help:
	xor	ax,ax
	les	bx,tdialog
	test	es:[bx.dl_flag],_D_DHELP
	jz	handle_event_end
	cmp	word ptr thelp,ax
	jz	handle_event_end
	call	thelp
	mov	ax,_C_NORMAL
	jmp	handle_event_end
handle_event ENDP

test_event PROC
	xor	bx,bx
    test_event_loop:
	cmp	ax,[bx+keytable]
	je	test_event_found
	add	bx,2
	dec	cx
	jnz	test_event_loop
	call	handle_event
	ret
    test_event_found:
	call	[bx+proctab]
	ret
test_event ENDP

ldobject_cursor PROC
	push	ax
	MPUSH	ds
	push	offset ocurs
	call	getcursor
	pop	ax
ldobject_cursor ENDP

ldobject PROC
	les	bx,tdialog
	cmp	es:[bx.dl_count],0
	je	ldobject_end
	test	ax,ax
	jnz	ldobject_index
	mov	al,es:[bx.dl_index]
	inc	ax
    ldobject_index:
	mov	dx,es:[bx+4]
	MLES	bx,es:[bx.dl_object]
	dec	ax
	shl	ax,4
	add	ax,bx
	mov	word ptr tobjp,ax
	mov	word ptr tobjp+2,es
	mov	bx,ax
	mov	ax,es:[bx]
	mov	oflag,ax
	mov	ax,word ptr es:[bx.to_rect+2]
	mov	word ptr orect+2,ax
	mov	ax,word ptr es:[bx.to_rect]
	add	ax,dx
	mov	word ptr orect,ax
	mov	ah,0
	mov	oxpos,ax
	mov	al,orect.rc_y
	mov	oypos,ax
	mov	al,orect.rc_col
	mov	oxlen,ax
	mov	ax,es:[bx]
	ret
    ldobject_end:
	xor	ax,ax
	ret
ldobject ENDP

ifdef __MOUSE__
omousecmd PROC
	call	mousex
	push	ax
	call	mousey
	pop	dx
	cmp	ax,oypos
	jne	omousecmd_nil
	mov	ax,oxpos
	dec	ax
	cmp	dx,ax
	jb	omousecmd_nil
	add	ax,2
	cmp	dx,ax
	jbe	omousecmd_one
    omousecmd_nil:
	xor	ax,ax
	mov	ax,MOUSECMD
	ret
    omousecmd_one:
	or	ax,1
	ret
omousecmd ENDP
endif

exechild PROC
	inc	ax
	call	ldobject
	cmp	word ptr es:[bx.to_proc],0
	jz	exechild_end
	call	es:[bx.to_proc]
	mov	result,ax
	cmp	ax,_C_REOPEN
	jne	exechild_end
	les	bx,tdialog
	mov	al,es:[bx.dl_index]
	push	ax
	invoke	dlinit, tdialog
	pop	ax
	les	bx,tdialog
	mov	es:[bx.dl_index],al
    exechild_end:
	ret
exechild ENDP

cl_to_index PROC
	dec	cx
	mov	[di.dl_index],cl
	mov	ax,1
	test	ax,ax
	ret
cl_to_index ENDP

cl_to_index_if_act PROC
	test	es:[si.to_flag],_O_DEACT
	jz	cl_to_index
	xor	ax,ax
	ret
cl_to_index_if_act ENDP

previtem PROC
	push	ds
	push	si
	push	di
	lds	di,tdialog
	xor	cx,cx
	add	cl,[di.dl_index]
	jz	previtem_00
	les	si,[di.dl_object]
	mov	ax,cx
	dec	ax
	shl	ax,4
	add	si,ax
    previtem_set:
	call	cl_to_index_if_act
	jnz	previtem_break
	sub	si,size S_TOBJ
	dec	cx
	jnz	previtem_set
    previtem_break:
	jnz	previtem_end
	xor	cx,cx
    previtem_00:
	add	cl,[di.dl_count]
	jz	previtem_02
	mov	bl,[di.dl_index]
	mov	si,word ptr [di.dl_object]
	mov	ax,cx
	dec	ax
	shl	ax,4
	add	si,ax
	xor	ax,ax
    previtem_01:
	cmp	bl,cl
	ja	previtem_02
	test	es:[si.to_flag],_O_DEACT
	jz	previtem_04
	sub	si,size S_TOBJ
	dec	cx
	jnz	previtem_01
    previtem_02:
	xor	ax,ax
    previtem_end:
	pop	di
	pop	si
	pop	ds
	ret
    previtem_04:
	call	cl_to_index
	jmp	previtem_end
previtem ENDP

itemleft PROC
	push	ds
	push	si
	push	di
	lds	di,tdialog
	xor	cx,cx
	add	cl,[di.dl_index]
	jz	itemleft_nil
	les	si,[di.dl_object]
	mov	ax,cx
	dec	ax
	shl	ax,4
	add	si,ax
	mov	bx,es:[si+20]
    itemleft_loop:
	cmp	bh,es:[si+5]
	jne	itemleft_next
	cmp	bl,es:[si+4]
	jbe	itemleft_next
	call	cl_to_index_if_act
	jnz	itemleft_end
    itemleft_next:
	sub	si,16
	dec	cx
	jnz	itemleft_loop
    itemleft_nil:
	xor	ax,ax
    itemleft_end:
	pop	di
	pop	si
	pop	ds
	ret
itemleft ENDP

nextitem PROC
	push	ds
	push	si
	push	di
	lds	di,tdialog
	xor	dx,dx
	xor	cx,cx
	mov	dl,[di+2]
	mov	cl,[di+3]
	inc	cx
	les	si,[di+12]
	mov	ax,cx
	shl	ax,4
	add	si,ax
	inc	cx
    nextitem_00:
	cmp	cx,dx
	ja	nextitem_01
	call	cl_to_index_if_act
	jnz	nextitem_04
	inc	cx
	add	si,16
	jmp	nextitem_00
    nextitem_01:
	xor	dx,dx
	mov	dl,es:[si+3]
	inc	dx
	mov	cx,1
	mov	si,[di+12]
    nextitem_02:
	cmp	cx,dx
	ja	nextitem_03
	call	cl_to_index_if_act
	jnz	nextitem_04
	inc	cx
	add	si,16
	jmp	nextitem_02
    nextitem_03:
	xor	ax,ax
    nextitem_04:
	pop	di
	pop	si
	pop	ds
	ret
nextitem ENDP

itemright PROC
	push	ds
	push	si
	push	di
	lds	di,tdialog
	xor	dx,dx
	xor	cx,cx
	mov	dl,byte ptr [di+2]
	mov	cl,byte ptr [di+3]
	inc	cx
	les	si,[di+12]
	mov	ax,cx
	shl	ax,4
	add	si,ax
	mov	bx,es:[si-12]
	inc	cx
    itemright_00:
	cmp	cx,dx
	ja	itemright_02
	cmp	bh,es:[si+5]
	jnz	itemright_01
	cmp	bl,es:[si+4]
	jnb	itemright_01
	call	cl_to_index_if_act
	jnz	itemright_end
    itemright_01:
	inc	cx
	add	si,16
	jmp	itemright_00
    itemright_02:
	xor	ax,ax
    itemright_end:
	pop	di
	pop	si
	pop	ds
	ret
itemright ENDP

xbuttxchg PROC
	mov	bl,byte ptr oxpos
	mov	bh,byte ptr oypos
	call	@getxyw
	xchg	si,ax
	mov	cx,1
	call	@scputw
	add	bl,byte ptr oxlen
	dec	bl
	call	@getxyw
	xchg	di,ax
	call	@scputw
	ret
xbuttxchg ENDP

ifdef __MOUSE__

xbuttms	PROC
	push	si
	push	di
	mov	si,' '
	mov	di,si
	call	xbuttxchg
	inc	bl
	call	@getxyw
	push	ax
	sub	bl,byte ptr oxlen
	inc	bh
	inc	bl
	call	@getxyw
	push	ax
	mov	al,byte ptr oflag
	and	ax,000Fh
	push	ax
	jnz	xbuttms_00
	mov	cl,byte ptr oxlen
	mov	al,' '
	call	@scputw
	add	bl,cl
	dec	bh
	dec	bl
	mov	cl,1
	call	@scputw
    xbuttms_00:
	call	msloop
	call	xbuttxchg
	pop	dx
	pop	ax
	pop	di
	test	dx,dx
	jnz	xbuttms_end
	mov	cx,oxlen
	mov	bh,byte ptr oypos
	mov	bl,byte ptr oxpos
	inc	bh
	inc	bl
	call	@scputw
	add	bl,byte ptr oxlen
	dec	bh
	dec	bl
	mov	cl,1
	mov	ax,di
	call	@scputw
    xbuttms_end:
	pop	di
	pop	si
	ret
xbuttms	ENDP

cmdmouse PROC
	push	si
	push	di
	les	bx,tdialog
	mov	si,word ptr es:[bx.dl_rect+2]
	mov	di,word ptr es:[bx.dl_rect]
	call	mousex
	mov	cx,ax
	call	mousey
	mov	dx,ax
	push	si
	push	di
	push	cx
	push	dx
	call	rcxyrow
	jz	cmdmouse_00
	cmp	ax,1
	jne	cmdmouse_02
	invoke	dlmove, tdialog
	jmp	cmdmouse_04
    cmdmouse_00:
	mov	result,_C_ESCAPE
    cmdmouse_01:
	pop	di
	pop	si
	ret
    cmdmouse_02:
	mov	al,es:[bx.dl_count]
	mov	ah,0
	test	ax,ax
	jz	cmdmouse_04
	mov	si,ax
	les	bx,es:[bx.dl_object]
    cmdmouse_03:
	mov	ax,word ptr es:[bx.to_rect]
	add	ax,di
	push	word ptr es:[bx.to_rect+2]
	push	ax
	push	cx
	push	dx
	call	rcxyrow
	jnz	cmdmouse_05
	add	bx,size S_TOBJ
	dec	si
	jnz	cmdmouse_03
    cmdmouse_04:
	call	msloop
	mov	result,_C_NORMAL
	jmp	cmdmouse_01
    cmdmouse_05:
	les	bx,tdialog
	mov	ah,0
	mov	al,es:[bx.dl_count]
	sub	ax,si
	mov	si,ax
	inc	ax
	call	ldobject
	test	ax,_O_DEACT
	jnz	cmdmouse_11
	les	bx,tdialog
	mov	ax,si
	mov	es:[bx.dl_index],al
	mov	ax,oflag
	and	al,0Fh
	cmp	al,_O_TBUTT
	je	cmdmouse_06
	cmp	al,_O_PBUTT
	jne	cmdmouse_07
    cmdmouse_06:
	call	xbuttms
    cmdmouse_07:
	mov	ax,oflag
	test	ax,_O_DEXIT
	jnz	cmdmouse_00
	test	ax,_O_CHILD
	jz	cmdmouse_09
    cmdmouse_08:
	mov	ax,si
	call	exechild
	jmp	cmdmouse_01
    cmdmouse_09:
	and	ax,000Fh
	cmp	al,_O_TBUTT
	je	cmdmouse_10
	cmp	al,_O_PBUTT
	je	cmdmouse_10
	cmp	al,_O_MENUS
	je	cmdmouse_10
	cmp	al,_O_XHTML
	je	cmdmouse_10
	mov	result,_C_NORMAL
	jmp	cmdmouse_01
    cmdmouse_10:
	mov	result,_C_RETURN
	jmp	cmdmouse_01
    cmdmouse_11:
	and	al,0Fh
	cmp	al,_O_LLMSU
	je	cmdmouse_13
	cmp	al,_O_LLMSD
	je	cmdmouse_14
	cmp	al,_O_MOUSE
	jne	cmdmouse_12
	test	cx,_O_CHILD
	jnz	cmdmouse_08
    cmdmouse_12:
	call	mousex
	mov	cx,ax
	call	mousey
	mov	dx,ax
	jmp	cmdmouse_04
    cmdmouse_13:
	call	TDLLISTMOUSEUP
	jmp	cmdmouse_01
    cmdmouse_14:
	call	TDLLISTMOUSEDN
	jmp	cmdmouse_01
cmdmouse ENDP

mousedelay PROC
	call	mousep
	jnz	mousedelay_do
	ret
    mousedelay_do:
	call	scroll_delay
	call	scroll_delay
	or	ax,1
	ret
mousedelay ENDP

TDLLISTMOUSEUP PROC
	les	bx,tdllist
	xor	ax,ax
	cmp	ax,es:[bx.ll_count]
	jz	TDRETNORMAL
	mov	dx,es:[bx]
	mov	es:[bx.ll_celoff],ax
	les	bx,tdialog
	cmp	dl,es:[bx.dl_index]
	mov	es:[bx.dl_index],dl
	jz	LLMUP_00
	ret
LLMUP_00:
	call	case_UP
	test	ax,ax
	jz	TDRETNORMAL
	call	mousedelay
	jnz	LLMUP_00
	jmp	TDRETNORMAL
TDLLISTMOUSEUP ENDP

TDLLISTMOUSEDN PROC
	les	bx,tdllist
	xor	ax,ax
	cmp	ax,es:[bx.ll_count]
	jz	TDRETNORMAL
	mov	ax,es:[bx.ll_numcel]
	dec	ax
	mov	es:[bx.ll_celoff],ax
	add	ax,es:[bx]
	les	bx,tdialog
	cmp	al,es:[bx.dl_index]
	mov	es:[bx.dl_index],al
	jz	LLMDN_00
	xor	ax,ax
	ret
LLMDN_00:
	call	case_DOWN
	test	ax,ax
	jz	TDRETNORMAL
	call	mousedelay
	jnz	LLMDN_00
TDLLISTMOUSEDN ENDP

else

case_MOUSE PROC
	mov	result,_C_NORMAL
	ret
case_MOUSE ENDP

endif ; __MOUSE__

TDRETNORMAL PROC
  ifdef __MOUSE__
	call	msloop
	inc	ax	; _C_NORMAL
  else
	mov	ax,_C_NORMAL
  endif
	ret
TDRETNORMAL ENDP

TDLISTITEM PROC
	xor	ax,ax
	call	ldobject
	test	ax,_O_LLIST
	jnz	TDLISTITEM_00
	and	al,0Fh
	cmp	al,_O_MENUS
	jz	TDLISTITEM_00
	mov	result,_C_NORMAL
	pop	ax
    TDLISTITEM_00:
	ret
TDLISTITEM ENDP

case_HOME PROC
	call	TDLISTITEM
	mov	ax,0
	jz	case_HOME_00
	les	bx,tdllist
	mov	es:[bx.S_LOBJ.ll_index],ax
	mov	es:[bx.S_LOBJ.ll_celoff],ax
	push	es:[bx.S_LOBJ.ll_dlgoff]
	call    es:[bx.S_LOBJ.ll_proc]
	pop	ax
    case_HOME_00:
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	call	nextitem
	call	previtem
	ret
case_HOME ENDP

case_LEFT PROC
	xor	ax,ax
	call	ldobject
	test	ax,_O_LLIST
	jz	case_LEFT_00
	jmp	case_PGUP
    case_LEFT_00:
	and	ax,000Fh
	cmp	ax,_O_MENUS
	jz	case_LEFT_01
	call	itemleft
	jz	case_UP
	ret
    case_LEFT_01:
	jmp	case_EXIT
case_LEFT ENDP

case_RIGHT PROC
	xor	ax,ax
	call	ldobject
	test	ax,_O_LLIST
	jz	case_RIGHT_00
	jmp	case_PGDN
    case_RIGHT_00:
	and	ax,000Fh
	cmp	ax,_O_MENUS
	jz	case_RIGHT_01
	call	itemright
	jz	case_DOWN
	ret
    case_RIGHT_01:
	jmp	case_EXIT
case_RIGHT ENDP

case_UP PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_LLIST
	jz	case_UP_01
	xor	ax,ax
	les	bx,tdllist
	cmp	ax,es:[bx.ll_celoff]
	jne	case_UP_01
	cmp	ax,es:[bx.ll_index]
	je	case_UP_00
	mov	dx,es:[bx.ll_dlgoff]
	les	bx,tdialog
	cmp	es:[bx.dl_index],dl
	je	case_UP_02
	mov	es:[bx.dl_index],dl
	inc	ax
    case_UP_00:
	ret
    case_UP_01:
	call	previtem
	ret
    case_UP_02:
	les	bx,tdllist
	dec	es:[bx.ll_index]
	jmp	case_LLPROC
case_UP	ENDP

case_DOWN PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_LLIST
	jz	case_NEXT
	les	bx,tdllist
	mov	cx,es:[bx.ll_dcount]
	mov	dx,es:[bx.ll_celoff]
	mov	ax,cx
	dec	ax
	cmp	ax,dx
	jz	case_DOWN_00
	mov	ax,dx
	add	ax,es:[bx.ll_index]
	inc	ax
	cmp	ax,es:[bx.ll_count]
	jb	case_NEXT
    case_DOWN_00:
	mov	ax,es:[bx]
	add	ax,dx
	les	bx,tdialog
	mov	ah,es:[bx.dl_index]
	mov	es:[bx.dl_index],al
	cmp	al,ah
	jne	case_NORMAL
	les	bx,tdllist
	mov	ax,es:[bx.ll_count]
	sub	ax,es:[bx.ll_index]
	sub	ax,cx
	jle	return_NULL
	inc	es:[bx.ll_index]
case_DOWN ENDP

case_LLPROC PROC
	call	es:[bx.S_LOBJ.ll_proc]
	jmp	return_AX
case_LLPROC ENDP

case_EXIT PROC
	inc	di
case_EXIT ENDP

return_NULL PROC
	xor	ax,ax
return_NULL ENDP

return_AX PROC
	mov	result,ax
	ret
return_AX ENDP

case_NORMAL PROC
	mov	result,_C_NORMAL
	ret
case_NORMAL ENDP

case_TAB PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_LLIST
	jz	case_NEXT
	les	bx,tdllist
	mov	ax,es:[bx.ll_dlgoff]
	add	ax,es:[bx.ll_dcount]
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	jmp	case_NORMAL
case_TAB ENDP

case_NEXT PROC
	jmp	nextitem
case_NEXT ENDP

case_ESC PROC
	mov	result,_C_ESCAPE
	ret
case_ESC ENDP

case_PGUP PROC
	call	TDLISTITEM
	jz	case_PGUP_02
	les	bx,tdllist
	xor	ax,ax
	cmp	ax,es:[bx.ll_celoff]
	jz	case_PGUP_01
	mov	es:[bx.ll_celoff],ax
	mov	ax,es:[bx.ll_dlgoff]
	les	bx,tdialog
	mov	es:[bx.dl_index],al
    case_PGUP_00:
	mov	result,_C_NORMAL
	ret
    case_PGUP_01:
	cmp	ax,es:[bx.ll_index]
	jz	case_PGUP_00
	mov	ax,es:[bx.ll_dcount]
	cmp	ax,es:[bx.ll_index]
	jbe	case_PGUP_03
    case_PGUP_02:
	jmp	case_HOME
    case_PGUP_03:
	sub	es:[bx.ll_index],ax
	jmp	case_LLPROC
case_PGUP ENDP

case_PGDN PROC
	call	TDLISTITEM
	jz	case_END
	les	bx,tdllist
	mov	ax,es:[bx.ll_dcount]
	dec	ax
	cmp	ax,es:[bx.ll_celoff]
	jz	case_PGDN_00
	mov	ax,es:[bx.ll_numcel]
	add	ax,es:[bx]
	dec	ax
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	mov	result,_C_NORMAL
	ret
    case_PGDN_00:
	add	ax,es:[bx.ll_celoff]
	add	ax,es:[bx.ll_index]
	inc	ax
	cmp	ax,es:[bx.ll_count]
	jnb	case_END
	mov	ax,es:[bx.ll_dcount]
	add	es:[bx.ll_index],ax
	jmp	case_LLPROC
case_PGDN ENDP

case_END PROC
	call	TDLISTITEM
	jnz	case_END_00
	les	bx,tdialog
	mov	al,es:[bx.dl_count]
	dec	al
	mov	es:[bx.dl_index],al
	call	previtem
	call	nextitem
	ret
    case_END_00:
	les	bx,tdllist
	mov	ax,es:[bx.ll_count]
	cmp	ax,es:[bx.ll_dcount]
	jnb	case_END_01
	mov	ax,es:[bx.ll_numcel]
	dec	ax
	mov	es:[bx.ll_celoff],ax
	add	ax,es:[bx]
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	mov	result,_C_NORMAL
	ret
    case_END_01:
	sub	ax,es:[bx.ll_dcount]
	cmp	ax,es:[bx.ll_index]
	jz	case_END_02
	mov	es:[bx.ll_index],ax
	mov	ax,es:[bx.ll_dcount]
	dec	ax
	mov	es:[bx.ll_celoff],ax
	add	ax,es:[bx]
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	les	bx,tdllist
	jmp	case_LLPROC
    case_END_02:
	jmp	return_NULL
case_END ENDP

case_ENTER PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_CHILD
	mov	ax,_C_RETURN
	jnz	case_ENTER_00
	mov	result,ax
	ret
    case_ENTER_00:
	les	bx,tdialog
	mov	ah,0
	mov	al,es:[bx.dl_index]
	call	exechild
	ret
case_ENTER ENDP

OGOTOXY	PROC
	xor	ax,ax
	call	ldobject_cursor
	call	cursoron
	inc	oxpos
	push	oxpos
	push	oypos
	call	gotoxy
	ret
OGOTOXY	ENDP

XORRADIOFLAG PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_RADIO
	jz	XORRADIOFLAG_00
  ifdef __MOUSE__
	call	msloop
  else
	xor	ax,ax
  endif
	ret
    XORRADIOFLAG_00:
	les	bx,tdialog
	xor	cx,cx
	add	cl,es:[bx.dl_count]
	jz	XORRADIOFLAG_03
	MLES	bx,es:[bx.dl_object]
    XORRADIOFLAG_01:
	test	byte ptr es:[bx.to_flag],_O_RADIO
	jz	XORRADIOFLAG_02
	and	byte ptr es:[bx.to_flag],not _O_RADIO
	push	es
	push	bx
	push	cx
	invoke	dlinitobj, tdialog, es::bx
	pop	cx
	pop	bx
	pop	es
    XORRADIOFLAG_02:
	add	bx,16
	dec	cx
	jnz	XORRADIOFLAG_01
	xor	ax,ax
	call	ldobject
	or	byte ptr es:[bx.to_flag],_O_RADIO
	invoke	dlinitobj, tdialog, es::bx
  ifdef __MOUSE__
	call	msloop
	inc	ax
  else
	mov	ax,_C_NORMAL
  endif
    XORRADIOFLAG_03:
	ret
XORRADIOFLAG ENDP

ORETURN	PROC
	invoke	setcursor, ocurs
	ret
ORETURN	ENDP

TDXORSWITCH PROC
	xor	ax,ax
	call	ldobject
	xor	ax,_O_FLAGB
	mov	es:[bx],ax
	test	ax,_O_FLAGB
	mov	ax,' '
	jz	TDXORSWITCH_00
	mov	al,'x'
    TDXORSWITCH_00:
	mov	bx,word ptr orect
	inc	bl
	mov	cx,1
	call	@scputw
  ifdef __MOUSE__
	call	msloop
  else
	xor	ax,ax
  endif
	ret
TDXORSWITCH ENDP

ifdef __MOUSE__

TDTESTXYROW PROC
	pushm	orect
	call	mousex
	push	ax
	call	mousey
	push	ax
	call	rcxyrow
	mov	ax,MOUSECMD
	ret
TDTESTXYROW ENDP

endif

TDSELECTOBJ PROC
	pushm	orect
	push	ds
	push	offset xlbuf
	call	rcread
	mov	al,at_background[B_DarkGray]
	mov	bx,offset xlbuf
	push	ds
	pop	es
	mov	cx,oxlen
	call	@wcputbg
	pushm	orect
	push	ds
	push	offset xlbuf
	call	rcxchg
	ret
TDSELECTOBJ ENDP

TDESELECTOBJ PROC
	push	ax
	pushm	orect
	MPUSH	ds
	push	offset xlbuf
	call	rcwrite
	pop	ax
	ret
TDESELECTOBJ ENDP

if USE_MDALTKEYS

case_ALTUP PROC
	mov	ax,offset rcmoveup
	jmp	case_ALTMOVE
case_ALTUP ENDP

case_ALTDN PROC
	mov	ax,offset rcmovedn
	jmp	case_ALTMOVE
case_ALTDN ENDP

case_ALTLEFT PROC
	mov	ax,offset rcmoveleft
	jmp	case_ALTMOVE
case_ALTLEFT ENDP

case_ALTRIGHT PROC
	mov	ax,offset rcmoveright
case_ALTRIGHT ENDP

case_ALTMOVE PROC
	les	bx,tdialog
	test	es:[bx.dl_flag],_D_DMOVE
	jz	case_ALTMOVE_00
	pushm	es:[bx.dl_rect]
	pushm	es:[bx.dl_wp]
	push	es:[bx.dl_flag]
	LPUSH	cs
	call	ax
	les	bx,tdialog
	mov	es:[bx+4],dx
    case_ALTMOVE_00:
	ret
case_ALTMOVE ENDP

endif

_TEXT	ENDS

;************** Public

DPROC	dlpbuttevent
	push	si
	push	di
	xor	ax,ax
	call	ldobject_cursor
	call	cursoron
	mov	ax,oxpos
	inc	ax
	push	ax
	push	oypos
	call	gotoxy
	mov	al,byte ptr oflag
	and	al,0Fh
	cmp	al,_O_TBUTT
	je	@F
	call	cursoroff
    @@:
	mov	si,16
	mov	di,17
	call	xbuttxchg
	call	tgetevent
	push	ax
	call	xbuttxchg
	invoke	setcursor, ocurs
	pop	ax
	pop	di
	pop	si
	ret
PEND	dlpbuttevent

DPROC	dlradioevent
	call	OGOTOXY
    tdradioevent_00:
	call	tgetevent
  ifdef __MOUSE__
	cmp	ax,MOUSECMD
	je	tdradioevent_01
  endif
	cmp	ax,KEY_SPACE
	je	tdradioevent_02
	jmp	tdradioevent_03
  ifdef __MOUSE__
    tdradioevent_01:
	call	omousecmd
	jz	tdradioevent_03
  endif
    tdradioevent_02:
	call	XORRADIOFLAG
	test	oflag,_O_EVENT
	jz	tdradioevent_00
	mov	ax,KEY_SPACE
    tdradioevent_03:
	call	ORETURN
	ret
PEND	dlradioevent

DPROC	dlcheckevent
	call	OGOTOXY
    tdcheckevent_00:
	call	tgetevent
  ifdef __MOUSE__
	cmp	ax,MOUSECMD
	je	@F
  endif
	cmp	ax,KEY_SPACE
	je	tdcheckevent_02
	jmp	tdcheckevent_03
  ifdef __MOUSE__
    @@:
	call	omousecmd
	jz	tdcheckevent_03
  endif
    tdcheckevent_02:
	call	TDXORSWITCH
	test	oflag,_O_EVENT
	jz	tdcheckevent_00
	mov	ax,KEY_SPACE
    tdcheckevent_03:
	call	ORETURN
	ret
PEND	dlcheckevent

DPROC	dlxcellevent
	xor	ax,ax
	call	ldobject
	jz	@F
	call	cursoroff
    @@:	test	oflag,_O_LLIST
	jz	@F
	les	bx,tdialog
	mov	ah,0
	mov	al,es:[bx.dl_index]
	les	bx,tdllist
	cmp	ax,es:[bx.ll_dlgoff]
	jb	@F
	sub	ax,es:[bx.ll_dlgoff]
	cmp	ax,es:[bx.ll_numcel]
	jnb	@F
	mov	es:[bx.ll_celoff],ax
    @@:	call	TDSELECTOBJ
    tdxcellevent_loop:
	call	tgetevent
  ifdef __MOUSE__
	cmp	ax,MOUSECMD
	jne	tdxcellevent_07
	call	TDTESTXYROW
	jz	tdxcellevent_07
	push	oxpos
	push	oypos
	push	oxlen
	call	mousewait
	mov	ax,oflag
	and	ax,000Fh
	cmp	ax,_O_XHTML
	mov	ax,KEY_ENTER
	jz	tdxcellevent_07
	push	si
	mov	si,10
    @@:
	invoke	delay, 16
	call	mousep
	jnz	@F
	dec	si
	jnz	@B
    @@:
	call	mousep
	jz	@F
	call	TDTESTXYROW
	jz	@F
	mov	ax,KEY_ENTER
	jmp	tdxcellevent_06
    @@:
	xor	ax,ax
    tdxcellevent_06:
	pop	si
  endif
    tdxcellevent_07:
	test	ax,ax
	jz	tdxcellevent_loop
	call	TDESELECTOBJ
	ret
PEND	dlxcellevent

DPROC	dlteditevent
	xor	ax,ax
	call	ldobject
	mov	dx,es:[bx]
	pushm	es:[bx.to_data]
	push	word ptr es:[bx.to_rect+2]
	mov	ax,word ptr es:[bx.to_rect]
	mov	ch,0
	mov	cl,es:[bx.to_count]
	les	bx,tdialog
	add	ax,es:[bx+4]
	push	ax
	shl	cx,4
	push	cx
	push	dx
	call	dledit
	ret
PEND	dlteditevent

DPROC	dlmenusevent
	xor	ax,ax
	call	ldobject_cursor
	call	cursoroff
	mov	ax,word ptr es:[bx.to_data]
	test	ax,ax
	jz	@F
	push	word ptr es:[bx.to_data+2]
	push	ax
	xor	ax,ax
	mov	es,ax
	mov	bh,es:[0484h]
	mov	bl,20
	mov	al,' '
	mov	ah,at_background[B_Menus]
	or	ah,at_foreground[F_Menus]
	mov	cx,60		; (68) Japheth 28.08.11
	call	@scputw
	mov	ax,offset format_s
	mov	cx,003Ah
	call	@scputf
	add	sp,DPTRZ
    @@:
	call	TDSELECTOBJ
	call	tgetevent
	call	TDESELECTOBJ
	invoke	setcursor, ocurs
	ret
PEND	dlmenusevent

PPROC	dlevent, dialog:dword
local	prevdlg:dword	; init tdialog
local	cursor:	dword	; init cursor
	push	si
	push	di
	movmx	prevdlg,tdialog
	movmx	tdialog,dialog
	les	bx,tdialog
	mov	si,es:[bx]
	assertt	si,_D_DOPEN,jnz,"dlevent"
	test	si,_D_ONSCR
	jnz	@F
	invoke	dlshow, dialog
	test	ax,ax
	jz	tdevent_end
    @@:
	invoke	getcursor, addr cursor
	call	cursoroff
	xor	ax,ax
	les	bx,tdialog
	cmp	es:[bx.dl_count],al
	je	@F
	call	ldobject
	and	ax,_O_DEACT
	jz	tdevent_modal
	call	nextitem
	jnz	tdevent_modal
    @@:
	call	tgetevent
	mov	cx,9
	call	test_event
	mov	ax,result
	cmp	ax,_C_ESCAPE
	je	tdevent_cancel
	cmp	ax,_C_RETURN
	je	tdevent_cancel
	jmp	@B
    tdevent_end:
	les	bx,dialog
        mov	dx,ax
        movmx	tdialog,prevdlg
        mov	ax,dx
	mov	cx,dlexit
	pop	di
	pop	si
	test	ax,ax
	ret
    tdevent_oevent:
	call	es:[bx.to_proc]
	jmp	tdevent_test
    tdevent_modal:
  ifdef __MOUSE__
	call	msloop
  else
	xor	ax,ax
  endif
	xor	di,di
    tdevent_continue:
	xor	ax,ax
	mov	result,ax
	call	ldobject
	and	ax,_O_EVENT
	jnz	tdevent_oevent
	mov	ax,es:[bx]
	and	ax,000Fh
	cmp	al,6
	ja	tdevent_tbutt
	add	ax,ax
	xchg	bx,ax
	LPUSH	cs
	call	[bx+eventproc]
	jmp	tdevent_test
    tdevent_cancel:
	mov	event,0
	jmp	tdevent_exit
    tdevent_tbutt:
	cmp	al,_O_TBUTT
	mov	ax,KEY_ESC
	jne	tdevent_test
	call	dlpbuttevent
    tdevent_test:
	mov	dlexit,ax
	mov	event,ax
	mov	cx,key_count
	call	test_event
	mov	ax,result
	cmp	ax,_C_ESCAPE
	je	tdevent_cancel
	cmp	ax,_C_RETURN
	je	tdevent_return
	test	di,di
	jz	tdevent_continue
    tdevent_exit:
	invoke	setcursor, cursor
	mov	ax,event
	test	ax,ax
	jmp	tdevent_end
    tdevent_return:
	xor	ax,ax
	call	ldobject
	and	ax,_O_DEXIT
	jnz	tdevent_cancel
    tdevent_index:
	les	bx,tdialog
	mov	ah,0
	mov	al,es:[bx.dl_index]
	inc	ax
	mov	event,ax
	jmp	tdevent_exit
PEND	dlevent

_DATA	SEGMENT

tdialog	dd ?
tdllist	dd ?
tdoffss	dw ?

ocurs	dd	?
tobjp	dd	?
oflag	dw	?
orect	dd	?
oxpos	dw	?
oypos	dw	?
oxlen	dw	?
xlbuf	dw 	80 dup(?)

event	dw	?
result	dw	?
dlexit	dw	?

proctab label word
	dw	case_ESC
	dw	case_ESC
  if USE_MDALTKEYS
	dw	case_ALTUP
	dw	case_ALTDN
	dw	case_ALTLEFT
	dw	case_ALTRIGHT
  endif
	dw      case_ENTER
	dw      case_ENTER
  ifdef __MOUSE__
	dw      cmdmouse
  endif
	dw      case_LEFT
	dw      case_UP
	dw      case_RIGHT
	dw      case_DOWN
	dw      case_HOME
	dw      case_END
	dw      case_TAB
	dw      case_PGUP
	dw      case_PGDN

keytable label word
	dw      KEY_ESC
	dw      KEY_ALTX
  if USE_MDALTKEYS
	dw	KEY_ALTUP
	dw	KEY_ALTDN
	dw	KEY_ALTLEFT
	dw	KEY_ALTRIGHT
  endif
	dw      KEY_ENTER
	dw      KEY_KPENTER
  ifdef __MOUSE__
	dw	MOUSECMD
  endif
	dw      KEY_LEFT
	dw      KEY_UP
	dw      KEY_RIGHT
	dw      KEY_DOWN
	dw      KEY_HOME
	dw      KEY_END
	dw      KEY_TAB
	dw      KEY_PGUP
	dw      KEY_PGDN

if USE_MDALTKEYS
 ifdef __MOUSE__
  key_count =	18
 else
  key_count =	17
 endif
else
 ifdef __MOUSE__
  key_count =	14
 else
  key_count =	13
 endif
endif

eventproc label word
	dw	offset dlpbuttevent
	dw	offset dlradioevent
	dw	offset dlcheckevent
	dw	offset dlxcellevent
	dw	offset dlteditevent
	dw	offset dlmenusevent
	dw	offset dlxcellevent

_DATA	ENDS

	END
