include doszip.inc

ifdef __FF__

include malloc.inc
include dos.inc
include dir.inc
include io.inc
include iost.inc
include progress.inc
include string.inc
include syserrls.inc
include	conio.inc
include	mouse.inc
include	keyb.inc
include	ff.inc

	.186

	public	FFOpen
	public	FFClose
	public	FFAlloc
	public	FindFile
	public	cmsearch

mklistidd	proto
mklistadd	proto
externdef	_bufin:byte
externdef	format_lst:byte
externdef	IDD_DZFindFile:dword

ID_FILE = 13
ID_GOTO	= 22

OF_MASK	= 14*16
OF_PATH	= 15*16
OF_SSTR	= 16*16
OF_SUBD	= 17*16
OF_CASE	= 18*16
OF_HEXA	= 19*16
OF_FIND	= 20*16
OF_FILT	= 21*16
OF_SAVE	= 22*16
OF_GOTO	= 23*16
OF_QUIT	= 24*16
OF_MSUP	= 25*16
OF_MSDN	= 26*16
OF_GCMD = OF_MSUP

_DATA	SEGMENT

OUTPUT_BINARY	= 0	; Binary dump (default)
OUTPUT_TEXT	= 1	; Convert tabs, CR/LF
OUTPUT_LINE	= 2	; Convert tabs, break on LF

DLG_FindFile	dd ?
FCB_FindFile	dw ?

GCMD_search	label word
GCMD KEY_F2,	event_mklist
GCMD KEY_F3,	event_view
GCMD KEY_F4,	event_edit
GCMD KEY_F5,	event_filter
GCMD KEY_F6,	event_toggle_hex
GCMD KEY_F7,	event_find
GCMD KEY_F8,	event_delete
GCMD KEY_F9,	cmfilter_load
GCMD KEY_F10,	event_toggle_format
GCMD KEY_DEL,	event_delete
GCMD KEY_ALTX,	event_exit
		dw	0

_DATA	ENDS

ff_directory	proto dist pascal directory:dword
ff_fileblock	proto dist pascal directory:dword, wfblk:dword

_DZIP	SEGMENT

whilekeyalt proc	; Delay Alt-Key on exit
	les bx,keyshift
	mov bl,es:[bx]
	test bl,KEY_ALT
	jnz whilekeyalt
	ret
whilekeyalt endp

getcurobj proc
	mov bx,FCB_FindFile
	.if [bx.ll_count]
	    mov ax,[bx.ll_index]
	    add ax,[bx.ll_celoff]
	    shl ax,2
	    les bx,[bx.ll_list]
	    add bx,ax
	    mov ax,es:[bx]
	    mov dx,es:[bx+2]
	.endif
	ret
getcurobj endp

getcurfile proc
	call getcurobj
	.if !ZERO?
	    add ax,sb_file
	.endif
	ret
getcurfile endp

putcelid proc
	les bx,DLG_FindFile
	mov ah,00h
	mov al,es:[bx.dl_index]
	.if al >= ID_FILE
	    sub ax,ax
	.endif
	inc ax
	mov bx,FCB_FindFile
	add ax,[bx.ll_index]
	mov cx,[bx.ll_count]
	les bx,DLG_FindFile
	mov bx,es:[bx+4]
	add bx,0F04h
	scputf@	bl, bh, 0, 0, offset cstr('[%03d:%03d]'), ax, cx
	ret
putcelid endp

ff_fileblock proc dist pascal uses si di directory:dword, wfblk:dword
local \
    path[WMAXPATH]:byte,
    fblk:dword,
    offs:dword,
    line:word,
    fbsize:word,
    ioflag:word,
    iobuf:dword,
    iosize:word,
    result:word
	mov iosize,4096
	stoso iobuf,ds,offset _bufin
	.if func(malloc, 64000)
	    mov iosize,64000
	    stom iobuf
	.endif
	mov di,word ptr wfblk
	mov si,word ptr wfblk+2
	sub ax,ax
	mov STDI.ios_l,ax
	mov line,ax
	mov word ptr offs,ax
	mov word ptr offs+2,ax
	mov dx,MAXHIT
	mov result,dx
	mov bx,FCB_FindFile
	cmp [bx.ll_count],dx
	jnb ffdofile_end
	mov result,ax
	invoke filter_wblk, si::di
	test ax,ax
	jz ffdofile_end
	add di,wf_name
	invoke strfcat, addr path, directory, si::di
	invoke progress_set, si::di, directory, 1
	mov result,ax
	jnz ffdofile_end
	cmp word ptr directory,ax
	jz ffdofile_fail
	invoke cmpwarg, si::di, fp_maskp
	jz ffdofile_end
	cmp searchstring,0
	je ffdofile_found
	les bx,wfblk
	invoke osopen, addr path, es:[bx.wf_attrib], M_RDONLY, A_OPEN
	mov si,ax
	inc ax
	jz ffdofile_fail
	xor ax,ax
	mov ioflag,ax
	les bx,DLG_FindFile
	.if byte ptr es:[bx+OF_CASE] & _O_FLAGB
	    mov ioflag,IO_SEARCHCASE
	.endif
	.if byte ptr es:[bx+OF_HEXA] & _O_FLAGB
	    or ioflag,IO_SEARCHHEX
	.endif
    ffdofile_search:
	les bx,wfblk
	invoke osearch, si, es:[bx.wf_sizeax], iobuf, iosize, ioflag
	stom offs
	mov line,cx
	inc dx
	jz ffdofile_close
    ffdofile_found:
	invoke FFAlloc, addr path, offs, line, FCB_FindFile
	jz ffdofile_abort
	stom fblk
	mov di,cx
	cmp searchstring,0
	je ffdofile_end
	invoke lseek, si, offs, SEEK_SET
	lodm fblk
	add ax,di
	sub ax,INFOSIZE
	invoke osread, si, dx::ax, INFOSIZE-1
	lodm offs
	les bx,wfblk
	add ax,1
	adc dx,0
	cmprm es:[bx.wf_sizeax]
	jb @F
	    lodm es:[bx.wf_sizeax]
	@@:
	    invoke lseek, si, dx::ax, SEEK_SET
	    cmp result,0
	    jne ffdofile_close
	    mov bx,FCB_FindFile
	    cmp [bx.ll_count],MAXHIT
	    jb ffdofile_search
    ffdofile_close:
	invoke close, si
    ffdofile_end:
	invoke free, iobuf
	mov ax,result
	ret
    ffdofile_abort:
	invoke close, si
    ffdofile_fail:
	mov result,-1
	jmp ffdofile_end
ff_fileblock endp

ff_directory proc dist pascal directory:dword
	invoke progress_set, 0, directory, 0
	.if ZERO?
	    invoke scan_files, directory
	.endif
	ret
ff_directory endp

ffsearchpath proc pascal uses si di directory:dword
	invoke strlen, directory
	.if ax
	    mov bx,word ptr directory
	    dec ax
	    add bx,ax
	    .if byte ptr es:[bx] == '\'
		mov byte ptr es:[bx],0
	    .endif
	    les bx,DLG_FindFile
	    mov di,es:[bx+OF_SUBD]
	    movmx fp_maskp,es:[bx.to_data+OF_MASK]
	    fpmov fp_fileblock,ff_fileblock
	    fpmov fp_directory,ff_directory
	    .repeat
		les si,fp_maskp
		mov ah,0
		@@:
		    mov al,es:[si]
		    test al,al
		    jz @F
		    inc si
		    cmp al,' '
		    jne @B
		    mov es:[si-1],ah
		@@:
		.if di & _O_FLAGB
		    invoke scan_directory, 1, directory
		.else
		    invoke ff_directory, directory
		.endif
		mov word ptr fp_maskp,si
		les bx,fp_maskp
		.break .if !(byte ptr es:[bx])
		mov byte ptr es:[bx-1],' '
	    .until ax
	.endif
	ret
ffsearchpath endp

event_xcell proc dist
	call putcelid
	les bx,DLG_FindFile
	xor ax,ax
	mov al,es:[bx.dl_index]
	mov bx,FCB_FindFile
	mov [bx.ll_celoff],ax
	call dlxcellevent
	ret
event_xcell endp

event_hexa proc dist
	call dlcheckevent
	cmp ax,KEY_SPACE
	je toggle_hex
	ret
event_hexa endp

event_toggle_format proc dist
	.if ffflag == OUTPUT_LINE
	    mov ffflag,OUTPUT_BINARY
	.elseif ffflag
	    mov ffflag,OUTPUT_LINE
	.else
	    mov ffflag,OUTPUT_TEXT
	.endif
	call event_list
	jmp event_normal
event_toggle_format endp

event_toggle_hex proc dist
	les bx,DLG_FindFile
	cmp es:[bx.dl_index],ID_FILE+2
	jne event_normal
	xor byte ptr es:[bx+OF_HEXA],_O_FLAGB
event_toggle_hex endp

toggle_hex proc dist
	les bx,DLG_FindFile
	pushm es:[bx+OF_SSTR].to_data
	.if byte ptr es:[bx+OF_HEXA] & _O_FLAGB
	    call atohex
	.else
	    call hextoa
	.endif
	call event_list
	jmp event_normal
toggle_hex endp

event_help proc dist
	mov ax,12077
	call view_readme
	ret
event_help endp

event_edit proc dist
	call getcurfile
	jz event_normal
	push dx
	push ax
  ifdef __TE__
	mov es,dx
	mov bx,ax
	push es:[bx-6]
	invoke dlhide, DLG_FindFile
	call tedit
	invoke dlshow, DLG_FindFile
	jmp event_normal
  else
	or cflag,_C_SWAPFF
	push 4
	call load_tedit
  endif
event_edit endp

event_exit proc dist
	call whilekeyalt
	mov ax,_C_ESCAPE
	ret
event_exit endp

event_view proc dist
	les bx,DLG_FindFile
	cmp es:[bx.dl_index],ID_FILE
	jnb event_normal
	call getcurfile
	jz event_normal
  ifdef __TV__
	les bx,es:[bx]
	invoke tview, dx::ax, es:[bx.sb_offs]
  else
	invoke load_tview, dx::ax, 0
	cmp mainswitch,0
	je event_exit
	or cflag,_C_SWAPFF
	jmp event_exit
  endif
event_view endp

event_normal proc dist
	mov ax,_C_NORMAL
	ret
event_normal endp

event_filter proc dist
	call cmfilter
	les bx,DLG_FindFile
	mov bx,es:[bx+4]
	add bx,1410h
	sub cx,cx
	mov ax,7
	.if word ptr filter == cx
	    mov al,' '
	.endif
	inc cx
	call @scputw
	jmp event_normal
event_filter endp

event_mklist proc dist
	push si
	push di
	mov si,FCB_FindFile
	sub ax,ax
	.if [si.ll_count] != ax
	    .if func(mklistidd)
		les bx,DLG_FindFile
		invoke strlen, es:[bx+OF_PATH].to_data
		inc ax
		mov mklist.mkl_offspath,ax
		sub di,di
		.while di < [si.ll_count]
		    les bx,[si.ll_list]
		    mov ax,di
		    shl ax,2
		    add bx,ax
		    les bx,es:[bx]
		    movmx mklist.mkl_offset,es:[bx.sb_offs]
		    mov dx,es
		    mov ax,bx
		    add ax,sb_file
		    call mklistadd
		    inc di
		.endw
		invoke close, mklist.mkl_handle
		mov ax,cpanel
		.if func(panel_state)
		    invoke dlhide, DLG_FindFile
		    mov ax,cpanel
		    call panel_reread
		    invoke dlshow, DLG_FindFile
		.endif
		mov ax,_C_NORMAL
	    .endif
	.endif
	pop di
	pop si
	ret
event_mklist endp

event_list proc dist
	push bp
	push si
	push di
	sub sp,8
	mov bp,sp
	les bx,DLG_FindFile
	invoke strlen, es:[bx+OF_PATH].to_data
	inc ax
	mov [bp+6],ax
	invoke dlinit, DLG_FindFile
	sub ax,ax
	mov al,es:[bx+4]
	mov si,ax
	add si,4
	mov al,es:[bx+5]
	mov di,ax
	add di,2
	mov al,00h
	mov [bp+4],ax
	.while 1
	    mov bx,FCB_FindFile
	    .break .if ax >= [bx.ll_numcel]
	    add ax,[bx.ll_index]
	    shl ax,2
	    les bx,[bx.ll_list]
	    add bx,ax
	    movmx [bp],es:[bx]
	    mov bx,si
	    mov dx,[bp+4]
	    add dx,di
	    mov bh,dl
	    mov cx,25
	    add ax,sb_file
	    add ax,[bp+6]	; strip search directory from filename
	    mov dx,[bp+2]
	    call @scpath
	    .if searchstring	; append (<line>) to filename
		add al,bl
		mov ah,bh
		les bx,[bp]
		scputf@ al, ah, ch, 7, offset cstr("(%u)"), es:[bx.sb_line]
	    .endif
	    push ds
	    push si
	    push di
	    mov bx,si
	    add bx,33
	    mov ax,di
	    add ax,[bp+4]
	    mov bh,al
	    call @getxyp
	    mov di,bx
	    mov dl,ffflag
	    mov cx,36
	    lds si,[bp]
	    add si,[si.sb_size]
	    sub si,INFOSIZE
	    cld
	    .while cx
		lodsb
		.if dl == OUTPUT_LINE && (al == 10 || al == 13)
		    .break
		.elseif dl && (al == 9 || al == 10 || al == 13)
		    mov ah,al
		    mov al,'\'
		    stosb
		    .if ah == 13
			mov al,'n'
		    .elseif ah == 10
			mov al,'r'
		    .else
			mov al,'t'
		    .endif
		    inc di
		    dec cx
		    .break .if !cx
		.endif
		stosb
		inc di
		dec cx
	    .endw
	    pop di
	    pop si
	    pop ds
	  ifdef __MOUSE__
	    call mouseshow
	  endif
	    mov ax,[bp+4]
	    inc ax
	    mov [bp+4],ax
	.endw
	mov ax,1
	add sp,8
	pop di
	pop si
	pop bp
	ret
event_list endp

event_find proc dist pascal uses si di
local cursor:dword
	les bx,DLG_FindFile
	.if !(es:[bx+OF_GOTO].to_flag & _O_STATE)
	    invoke getcursor, addr cursor
	    call cursoroff
	    mov di,FCB_FindFile
	    mov si,[di.ll_count]
	    mov di,word ptr [di.ll_list]
	    .while si
		mov bx,FCB_FindFile
		les ax,[bx.ll_list]
		invoke free, es:[di]
		add di,4
		dec si
	    .endw
	    sub ax,ax
	    mov di,FCB_FindFile
	    mov [di.ll_celoff],ax
	    mov [di.ll_index],ax
	    mov [di.ll_numcel],ax
	    mov [di.ll_count],ax
	    invoke dlinit, DLG_FindFile
	    mov ax,es:[bx+4]
	    add ax,0F04h
	    scputw@	al, ah, 9, 00C4h
	    invoke progress_open, addr cp_search, 0
	    les bx,DLG_FindFile
	    lodm es:[bx+OF_PATH].to_data
	    push dx
	    push ax
	    invoke progress_set, 0, dx::ax, MAXHIT+2
	    call ffsearchpath
	    call progress_close
	    invoke setcursor, cursor
	    mov ax,[di.ll_count]
	    .if ax >= ID_FILE
		mov ax,ID_FILE
	    .endif
	    mov [di.ll_numcel],ax
	    call update_cellid
	.endif
	ret
event_find endp

update_cellid proc
	push di
	call putcelid
	call event_list
	les bx,DLG_FindFile
	mov di,FCB_FindFile
	mov cx,ID_FILE
	mov ax,_O_STATE
	.repeat
	    add bx,16
	    or es:[bx],ax
	.untilcxz
	mov bx,word ptr DLG_FindFile
	mov ax,not _O_STATE
	mov cx,[di.ll_numcel]
	.while cx
	    add bx,16
	    and es:[bx],ax
	    dec cx
	.endw
	mov ax,_C_NORMAL
	pop di
	ret
update_cellid endp

event_delete proc dist
	.if func(getcurobj)
	    push dx
	    push ax
	    .repeat
		movmx es:[bx],es:[bx+4]
		add bx,4
	    .until !ax
	    call free
	    mov bx,FCB_FindFile
	    dec [bx.ll_count]
	    mov ax,[bx.ll_count]
	    mov dx,[bx.ll_index]
	    mov cx,[bx.ll_celoff]
	    .if ZERO?
		mov dx,ax
		mov cx,ax
	    .else
		.if dx
		    mov bx,ax
		    sub bx,dx
		    .if bx < ID_FILE
			dec dx
			inc cx
		    .endif
		.endif
		sub ax,dx
		.if ax >= ID_FILE
		    mov ax,ID_FILE
		.endif
		.if cx >= ax
		    dec cx
		.endif
	    .endif
	    mov bx,FCB_FindFile
	    mov [bx.ll_index],dx
	    mov [bx.ll_celoff],cx
	    mov [bx.ll_numcel],ax
	    les bx,DLG_FindFile
	    or ax,ax
	    mov al,cl
	    .if ZERO?
		mov al,ID_FILE
	    .endif
	    mov es:[bx.dl_index],al
	    call update_cellid
	.endif
	mov ax,_C_NORMAL
	ret
event_delete endp

FFOpen proc dist pascal ll:word
	mov ax,ll
	invoke memzero, ss::ax, SIZE S_LOBJ
	mov bx,ll
	mov [bx.ll_dcount],ID_FILE
	fpmov [bx.ll_proc],event_list
	invoke malloc, (MAXHIT*4)+4
	mov bx,ll
	stom [bx.ll_list]
	.if ax
	    invoke memzero, dx::ax, (MAXHIT*4)+4
	    inc ax
	.endif
	ret
FFOpen	endp

FFClose	proc dist pascal uses si di ll:word
	mov si,ll
	mov ax,word ptr [si.ll_list]
	.if ax
	    xor di,di
	    .while di < [si.ll_count]
		les bx,[si.ll_list]
		mov ax,di
		shl ax,2
		add bx,ax
		invoke free, es:[bx]
		inc di
	    .endw
	    invoke free, [si.ll_list]
	    xor ax,ax
	    mov word ptr [si.ll_list],ax
	.endif
	ret
FFClose	endp

FFAlloc	proc dist pascal path:dword, offs:dword, line:word, ll:word
local	fblk:dword
	push	si
	push	di
	invoke	strlen, path
	add	ax,BLOCKSIZE
	mov	di,ax
	invoke	malloc, ax
	jz	FFAlloc_end
	mov	si,dx
	invoke	memzero, dx::ax, di
	mov	dx,sb_file+4
	invoke	strcpy, es::dx, path
	mov	bx,ll
	push	0
	push	[bx.ll_count]
	call	progress_update
	mov	cx,ax
	mov	bx,ll
	mov	ax,[bx.ll_count]
	inc	[bx.ll_count]
	mov	dx,[bx.ll_count]
	.if	dx >= ID_FILE
	    mov dx,ID_FILE
	.endif
	mov	[bx.ll_numcel],dx
	shl	ax,2
	les	bx,[bx.ll_list]
	add	bx,ax
	mov	dx,si
	mov	ax,4
	stom	es:[bx]
	mov	es,dx
	mov	bx,ax
	mov	es:[bx.sb_size],di
	movmw	es:[bx.sb_line],line
	movmx	es:[bx.sb_offs],offs
	mov	ax,bx
	or	cx,cx
	mov	cx,di
	jz	FFAlloc_end
	xor	ax,ax
    FFAlloc_end:
	or	ax,ax
	pop	di
	pop	si
	ret
FFAlloc	endp

FindFile proc dist pascal uses si di wspath:dword, ll_off:word
local sbfile:dword, cursor:dword, oldll:word, ll:S_LOBJ
	movmw oldll,FCB_FindFile
	mov ax,ll_off
	mov FCB_FindFile,ax
	.if !ax
	    lea ax,ll
	    mov FCB_FindFile,ax
	    invoke FFOpen, ax
	    jz findfile_nomem
	.endif
	invoke getcursor, addr cursor
	LPUSH cs
	push offset event_help
	call thelp_set
	xor si,si
	call clrcmdl
	invoke rsopen, IDD_DZFindFile
	jz findfile_somem
	stom DLG_FindFile
	xor ax,ax
	stoso es:[bx.to_data+OF_GCMD],ds,offset GCMD_search
	mov si,offset findfilemask
	stoso es:[bx.to_data+OF_MASK],ds,si
	.if [si] == al
	    invoke strcpy, ds::si, addr cp_stdmask
	    les bx,DLG_FindFile
	.endif
	mov si,offset searchstring
	stoso es:[bx.to_data+OF_SSTR],ds,si
	invoke strcpy, es:[bx.to_data+OF_PATH], wspath
	fpmov es:[bx.to_proc+OF_HEXA],event_hexa
	fpmov es:[bx.to_proc+OF_FIND],event_find
	fpmov es:[bx.to_proc+OF_FILT],event_filter
	fpmov es:[bx.to_proc+OF_SAVE],event_mklist
	mov ah,fsflag
	mov al,_O_FLAGB
	.if ah & IO_SEARCHCASE
	    or es:[bx+OF_CASE],al
	.endif
	.if ah & IO_SEARCHHEX
	    or es:[bx+OF_HEXA],al
	.endif
	.if ah & IO_SEARCHSUB
	    or es:[bx+OF_SUBD],al
	.endif
	mov bx,20+TO_OPROC
	mov cx,ID_FILE
	mov ax,offset event_xcell
	LMOV dx,cs
	.repeat
	    mov es:[bx],ax
	    LMOV es:[bx+2],dx
	    add bx,16
	.untilcxz
	invoke dlshow, DLG_FindFile
	invoke dlinit, DLG_FindFile
	mov word ptr filter,0
	mov ax,FCB_FindFile
	stoso tdllist,ds,ax
	.if ll_off
	    mov ax,_O_STATE
	    or es:[bx+OF_FIND],ax
	    or es:[bx+OF_GOTO],ax
	    call update_cellid
	.endif
	.repeat
	    .break .if !func(rsevent, IDD_DZFindFile, DLG_FindFile)
	    mov si,ax
	    mov di,cx
	    mov al,es:[bx.dl_index]
	    .if al < ID_FILE
		call event_view
		.break .if ax != _C_NORMAL
	    .elseif al == ID_GOTO
		.break
	    .elseif !ll_off
		call event_find
	    .endif
	.until 0
	mov ah,fsflag
	and ah,not (IO_SEARCHCASE or IO_SEARCHSUB or IO_SEARCHHEX)
	mov al,_O_FLAGB
	les bx,DLG_FindFile
	.if es:[bx+OF_CASE] & al
	    or ah,IO_SEARCHCASE
	.endif
	.if es:[bx+OF_HEXA] & al
	    or ah,IO_SEARCHHEX
	.endif
	.if es:[bx+OF_SUBD] & al
	    or ah,IO_SEARCHSUB
	.endif
	mov fsflag,ah
	mov al,es:[bx.dl_index]
	mov ah,00h
	invoke dlclose, DLG_FindFile
	.if dx == ID_GOTO
	    mov bx,FCB_FindFile
	    .if [bx.ll_count]
		mov ax,cpanel
		.if func(panel_state)
		    mov bx,FCB_FindFile
		    mov ax,[bx.ll_index]
		    add ax,[bx.ll_celoff]
		    les bx,[bx.ll_list]
		    shl ax,2
		    add bx,ax
		    mov dx,es:[bx+2]
		    mov ax,es:[bx]
		    add ax,sb_file
		    stom sbfile
		    .if func(strrchr, dx::ax, '\')
			mov bx,ax
			mov byte ptr es:[bx],0
			mov ax,word ptr sbfile
			call cpanel_setpath
		    .endif
		.endif
	    .endif
	.endif
	invoke FFClose, FCB_FindFile
    findfile_end:
	movmw FCB_FindFile,oldll
	call thelp_pop
	invoke setcursor, cursor
	mov ax,si		; Exit code
	mov cx,di		; Exit key
	ret
    findfile_somem:
	invoke FFClose, FCB_FindFile
    findfile_nomem:
	mov si,-1
	mov ax,offset CP_ENOMEM
	call @ermsg
	jmp findfile_end
FindFile endp

cmsearch proc dist
	mov bx,com_wsub
	invoke FindFile, [bx.ws_path], 0
	ret
cmsearch endp

_DZIP	ENDS
endif
	END
