include	clib.inc
include	mouse.inc

ifdef __MOUSE__

	public	mouseinit
	public	mouseget
	public	mouseset
	public	mousep
	public	mouseon
	public	mouseoff
	public	mousex
	public	mousey
	public	mousehide
	public	mouseshow

OFFSETVECTOR	equ	MOUSEINT*4

_TEXT	SEGMENT

__mouse	db 	0	; Installed
__mbool	db 	0	; Visible
__mflag	db 	0	; Mouse State

mouseinit proc	DIST
	xor	ax,ax
	mov	cs:[__mouse],al
	mov	es,ax
	cmp	ax,es:[OFFSETVECTOR+2]
	je	mouseinit_00
	les	bx,es:[OFFSETVECTOR]
	cmp	byte ptr es:[bx],0CFh
	je	mouseinit_00
	int	33h
	test	ax,ax
	jz	mouseinit_00
	inc	cs:[__mouse]
    mouseinit_00:
	ret
mouseinit endp

mousep	proc DIST
	xor ax,ax
	cmp cs:[__mouse],al
	je @F
	push bx
	push cx
	push dx
	mov al,6
	int 33h
	or  al,al
	pop dx
	pop cx
	pop bx
      @@:
	ret
mousep	endp

mouseon	proc	DIST
	mov	ax,1
	cmp	al,cs:[__mbool]
	je	mouseon_00
	cmp	ah,cs:[__mouse]
	je	mouseon_00
	mov	cs:[__mbool],al
	int	33h
    mouseon_00:
	ret
mouseon	endp

mouseoff proc	DIST
	xor	ax,ax
	cmp	al,cs:[__mbool]
	jz	mouseoff_00
	mov	cs:[__mbool],al
	mov	ax,2
	int	33h
    mouseoff_00:
	ret
mouseoff endp

mousex	proc	DIST
	push	bx
	push	cx
	push	dx
	xor	ax,ax
	cmp	al,cs:[__mouse]
	je	mousex_00
	mov	al,3
	int	33h
	mov	ax,cx
	shr	ax,3
    mousex_00:
	pop	dx
	pop	cx
	pop	bx
	ret
mousex	endp

mousey	proc	DIST
	push	bx
	push	cx
	push	dx
	xor	ax,ax
	cmp	al,cs:[__mouse]
	je	mousey_00
	mov	ax,3
	int	33h
	mov	ax,dx
	shr	ax,3
    mousey_00:
	pop	dx
	pop	cx
	pop	bx
	ret
mousey	endp

mousehide proc	DIST
	push	ax
	call	mouseoff
	shr	al,1
	mov	ah,cs:[__mflag]
	shl	ah,1
	or	al,ah
	mov	cs:[__mflag],al
	pop	ax
	ret
mousehide endp

mouseshow proc	DIST
	push	ax
	mov	al,cs:[__mflag]
	shr	al,1
	mov	cs:[__mflag],al
	jnc	mouseshow_00
	call	mouseon
    mouseshow_00:
	pop	ax
	ret
mouseshow endp

mouseset proc DIST
	call	mousehide
	mov	cs:[__mouse],al
	call	mouseshow
	ret
mouseset endp

mouseget proc DIST
	mov	ah,cs:[__mouse]
	mov	al,cs:[__mbool]
	mov	dl,cs:[__mflag]
	ret
mouseget endp

_TEXT	ENDS

endif ; __MOUSE__

	END
