; DZ.ASM--
; Copyright (c) 1996-2011 Hjort Nidudsson
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;

	.186
	.model	small

S_DATA		STRUC
dz_envlen	dw ?
dz_envseg	dw ?
dz_command	dw 2 dup(?)
dz_fcb_0P	dw 2 dup(?)
dz_fcb_1P	dw 2 dup(?)
dz_dzmain	db 80 dup(?)
dz_dzcommand	db 128 dup(?)
dz_fcb_160	db 16 dup(?)
dz_fcb_161	db 16 dup(?)
dz_exeproc	db 80 dup(?)
dz_execommand	db 128 dup(?)
dz_errno	dw ?
dz_eflag	dw ?
dz_count	dw ?
dz_exename	dw ?
dz_oldintF1	dd ?
S_DATA		ENDS

include	version.inc

ifdef USE_MEMCONFIG
 STACKSIZE    = 839 + 128
 PROGRAMSIZE  =	2048
else
 STACKSIZE    = 128
 PROGRAMSIZE  = 1024
endif

	.code

config label S_DATA

start	PROC
	jmp	around
	db	10
copyright label byte
	db	'The Doszip Commander Version ',DOSZIP_VSTR,', '
	db	'Copyright (c) 1996-2011 Hjort Nidudsson',13,10,13,10,'$'
invalid_environ label byte
	db	'Environment invalid',13,10,'$'
around:	mov	ax,cs
	mov	ds,ax
	mov	ah,9
	mov	dx,offset copyright
	int	21h
	mov	si,offset config
	mov	bx,002Ch
	mov	bp,es
	mov	ax,es:[bx]
	mov	[si.S_DATA.dz_envseg],ax
	mov	bx,PROGRAMSIZE/16
	mov	ah,4Ah
	int	21h
	mov	bx,[si.S_DATA.dz_envseg]
	mov	es,bx
	xor	ax,ax
	mov	di,ax
	mov	cx,7FFFh
	cld
environ_loop:
	repnz	scasb
	or	cx,cx
	jz	errorlevel_10
	cmp	es:[di],al
	jne	environ_loop
	or	ch,80h
	neg	cx
	jmp	init_vector
errorlevel_10:
	mov	dx,offset invalid_environ
	mov	ah,9
	int	21h
	mov	ax,4C0Ah
	int	21h
init_vector:
	mov	ax,ds
	mov	vector+6,ax
	mov	vector+4,offset config.dz_exeproc
	mov	[si.S_DATA.dz_fcb_0P+2],ax
	mov	[si.S_DATA.dz_fcb_1P+2],ax
	mov	[si.S_DATA.dz_fcb_0P],offset config.dz_fcb_160
	mov	[si.S_DATA.dz_fcb_1P],offset config.dz_fcb_161
	mov	[si.S_DATA.dz_command+2],ax
	mov	dx,ax
	mov	di,cx
	add	di,2
	mov	si,di
	mov	cx,-1
	xor	ax,ax
	repnz	scasb
	not	cx
	push	cx
	mov	es,dx
	mov	di,offset config.dz_dzmain
	mov	ds,bx
	rep	movsb
	mov	ds,dx
	mov	es,dx
	mov	bx,di
	mov	di,offset config.dz_fcb_160
	mov	si,offset config.dz_dzmain
	mov	ax,2901h
	int	21h
	mov	cx,10
	lea	di,[bx-7]
	mov	si,offset cp_dzmain_exe
	rep	movsb
	xor	ax,ax
	stosb
	mov	di,offset config.dz_dzcommand
	mov	si,128
	mov	ds,bp
	mov	cx,128
	rep	movsb
	mov	ds,dx
	mov	ax,4300h
	mov	dx,offset config.dz_dzmain
	int	21h
	pop	di
	jnc	file_found
file_not_found:
	mov	dx,offset cp_file_not_found
	mov	cx,15
	call	write
	mov	cx,di
	add	cx,4
	mov	dx,offset config.dz_dzmain
	call	write
	mov	ax,2
	jmp	toend
write:	mov	ah,40h
	mov	bx,2
	int	21h
	ret
	db	13,10,10
	db	'$Id: DZ.ASM ',DOSZIP_DATE,' ',DOSZIP_TIME,10
file_found:
	xor	ax,ax
	mov	vector+8,ax
	jmp	DOS
	db	13,10
	db	'DOS (errorlevel):',10
	db	' (2) '
cp_file_not_found label byte
	db	'File not found '
cp_dzmain_exe label byte
	db	'DZMAIN.EXE',13,10
	db	' (5) Access',10
	db	' (8) Memory',10
	db	'(10) Environment'
	db	100 dup(0Ah)
	org	SIZE S_DATA - 14
	dw	0
	dw	0	; dz_errno
	dw	0	; dz_eflag
	dw	0	; dz_count
	dw	0A00h	; dz_exename
	dw	4F44h	; dz_oldintF1
	dw	3A53h
START	ENDP

DOS	PROC
	mov	ax,35F1h
	int	21h
	mov	si,offset config
	mov	word ptr [si.S_DATA.dz_oldintF1],bx
	mov	word ptr [si.S_DATA.dz_oldintF1+2],es
	mov	ax,25F1h
	mov	dx,offset vector
	int	21h
	mov	config.dz_exename,offset config.dz_dzmain
	mov	config.dz_command,offset config.dz_dzcommand
spawn:  mov	bx,ds
	mov	es,bx
	mov	di,offset config.dz_fcb_161
	mov	si,config.dz_exename
	mov	ax,2901h
	int	21h
	mov	es,bx
	mov	bx,offset config.dz_envseg
	mov	dx,config.dz_exename
	mov	ax,4B00h
	int	21h
	mov	dx,cs
	mov	ds,dx
	jc	error
	xor	ax,ax
error:	mov	si,offset config
	mov	[si.S_DATA.dz_errno],ax
	mov	ax,4D00h
	int	21h
	mov	[si.S_DATA.dz_eflag],ax
	cmp	[si.S_DATA.dz_exename],offset config.dz_dzmain
	jne	DOS
	mov	di,ax
	mov	ax,25F1h
	lds	dx,[si.S_DATA.dz_oldintF1]
	int	21h
	mov	ax,cs
	mov	ds,ax
	mov	ax,di
	cmp	al,23
	jne	toend
	inc	[si.S_DATA.dz_count]
	mov	[si.S_DATA.dz_exename],offset config.dz_exeproc
	mov	[si.S_DATA.dz_command],offset config.dz_execommand
	jmp	spawn
DOS	ENDP
toend:  mov	ah,4Ch
	int	21h
vector	label word
	dd	50495A44h
	dd	564A4A0Ah
	.stack	STACKSIZE
	end	START
