	.186

include	clib.inc
ifdef __EDIT__
include	tinfo.inc
include	iost.inc
include	string.inc
include	ctype.inc

	public	tiflushl

_TEXT	SEGMENT
	;
	; Produce output to clipboard or file
	;
	; args:	AX start line	?, 0
	;	DX start offset	?, 0
	;	CX end line	?, line count - 1 ?
	;	BX end offset	?, -1
	;	SI tinfo
	;
	;
	; line is padded '\t_______mov\t_____ah,es:[di]'
	;
tiflushl PROC
	push	si
	push	di		; DI offset in line
	push	bp		; BP line index
	mov	bp,ax		; BP to first line
	mov	di,dx		; DI to start offset
	call	tigetline	; DX:AX to line
	jz	tiflushl_eoi
	jnc	tiflushl_do	; Carry set if string buffer
	test	[si.ti_flag],_T_LINEBUF
	jnz	tiflushl_eoi	; else Carry is EOF
    tiflushl_do:
	call	optimalfill
	add	di,ax		; DI to start of line
	add	bx,ax		; BX to offset
	jmp	tiflushl_loop
    tiflushl_dia:		; case DI > SI
	cmp	bp,cx		; break if last line
	je	tiflushl_eok
    tiflushl_00h:		; case [DI] == 0
	inc	bp
	cmp	bp,cx
	ja	tiflushl_eokl	; break if last line (BP==CX)
	mov	ax,bp
	call	tigetline
	jbe	tiflushl_eoi	; break if last line (EOF)
	call	optimalfill
	mov	di,ax
	test	[si.ti_flag],_T_USECRLF
	jz	tiflushl_0Ah	; insert line: 0D0A or 0A
	mov	al,0Dh
	call	oputc
    tiflushl_0Ah:
	mov	al,0Ah
	call	oputc
	jz	tiflushl_eof
	mov	ax,di
	jmp	tiflushl_loop
    tiflushl_09h:		; case [DI] == '\t'
	mov	ah,es:[di]	; remove space
	cmp	ah,' '
	jne	tiflushl_putt
	inc	di
	inc	al
	cmp	al,8
	jb	tiflushl_09h
    tiflushl_putt:
	mov	al,9		; insert TAB
    tiflushl_putc:
	call	oputc		; uses ES and AX
	jz	tiflushl_eof	; out of space..
    tiflushl_loop:
	mov	es,dx		; restore ES
	inc	di
	mov	ax,[si.ti_bcol]	; offset is zero if linebuf
	cmp	bp,cx		; is this is the last line ?
	jne	tiflushl_bcol
	mov	ax,bx
    tiflushl_bcol:
	cmp	di,ax		; end of line ?
	ja	tiflushl_dia
	mov	al,es:[di-1]	; get next char
	or	al,al		; end of string ?
	jz	tiflushl_00h
	cmp	al,9
	jne	tiflushl_putc
	mov	ax,di
	and	ax,7
	jz 	tiflushl_putt
	jmp	tiflushl_09h
    tiflushl_eof:		; end of output (ZF and CF)
	xor	ax,ax
	stc
	jmp	tiflushl_end
    tiflushl_eoi:		; end of input (CF)
	xor	ax,ax
	inc	ax
	stc
	jmp	tiflushl_end
    tiflushl_eokl:
	dec	bp
    tiflushl_eok:		; end ok
	xor	ax,ax
	inc	ax
	clc
    tiflushl_end:		; end
	;
	; out:	AX result
	;	DX line index
	;	BX line offset
	;
	mov	bx,di
	mov	dx,bp
	pop	bp
	pop	di
	pop	si
	ret
tiflushl ENDP

optimalfill PROC
	push	cx
	push	es
	push	si
	push	di
	mov	si,ax
	push	dx
	push	ax
	call	strlen
	mov	di,si
	add	di,ax
	mov	cx,ax
	xor	ax,ax
    optimalfill_len:
	dec	di
	cmp	di,si
	jb      optimalfill_end
	mov	al,es:[di]
	call	isspace
	jz	optimalfill_end
	mov	es:[di],ah
	dec	cx
	jnz	optimalfill_len
    optimalfill_end:
	or	cx,cx
	mov	ax,si
	pop	di
	pop	si
	pop	es
	pop	cx
	ret
optimalfill ENDP

_TEXT	ENDS
endif
	END
