include	clib.inc
include	io.inc
include	ios.inc
include	string.inc
include	errno.inc
if USE_MOUSE
 include mouse.inc
endif

	.186

	public	tvflag
	public	fsflag
	public	searchstring

	extrn	tview: NEAR

_DATA	SEGMENT

cp_info		DB	'TVIEW Version 1.09, Copyright (c) 1998-2010 Hjort Nidudsson',13,10
size_info	=	$ - OFFSET cp_info
cp_usage	DB	'Syntax:        TVIEW [-option] [<filename>]',13,10
		DB	13,10
		DB	'-t             Text view',13,10
		DB	'-b             Binary view',13,10
		DB	'-h             Hex view',13,10
		DB	'-m             View Memory [00000..FFFFF]',13,10
		DB	'-o<offset>     File Offset or Memory adress',13,10
size_usage	=	$ - OFFSET cp_usage

_C_HEXVIEW	=	80h
_C_BINVIEW	=	40h
_C_WRAPLINES	=	20h
_C_HIGHCOLOR	=	10h
_C_HEXOFFSET	=	08h
_C_CLIPBOARD	=	04h

tvflag		DB	_C_HEXOFFSET
fsflag		DB	0
searchstring	DB	128 dup(0)
ext_cfg		DB	'cfg',0

arg_file	DD	0
arg_offset	DD	0

_DATA	ENDS

_TEXT	SEGMENT
	PUBLIC_MAIN

	MOV	CX,size_info
	MOV	DX,OFFSET cp_info
	CALL	stderrmsg

	CMP	_argc,1
	JNE	read_config

print_usage:
	MOV	CX,size_usage
	MOV	DX,OFFSET cp_usage
	CALL	stderrmsg
	XOR	AX,AX
	RET

read_config:
	PUSH	DS
	PUSH	OFFSET searchstring
	PUSH	DS
	PUSH	OFFSET ext_cfg
	CALL	setext
	PUSH	DX
	PUSH	AX
	CALL	readword
	OR	AX,AX
	JZ	init_args
	MOV	tvflag,AL
	MOV	fsflag,AH
	XOR	AX,AX

init_args:
	MOV	searchstring,AL
	MOV	SI,1
arg_loop:
	CMP	SI,_argc
	jae	init_file
	LES	BX,_argv
	MOV	AX,SI
	INC	SI
	SHL	AX,2
	ADD	BX,AX
	LES	BX,ES:[BX]
	MOV	AX,ES:[BX]
	CMP	AL,'?'
	JE	print_usage
	CMP	AL,'/'
	JE	options
	CMP	AL,'-'
	JE	options
	MOV     WORD PTR arg_file,BX
	MOV	WORD PTR arg_file+2,ES
	JMP	arg_loop

options:
	MOV	AL,AH
	OR	AL,20h
	CMP	AL,'t'
	JE	case_t
	CMP	AL,'b'
	JE	case_b
	CMP	AL,'h'
	JE	case_h
	CMP	AL,'m'
	JE	case_m
	CMP	AL,'o'
	JE	case_o
	JMP	print_usage
case_t:
	AND	tvflag,NOT (_C_HEXVIEW OR _C_BINVIEW)
	JMP	arg_loop
case_b:
	OR	tvflag,_C_BINVIEW
case_h:
	OR	tvflag,_C_HEXVIEW
	JMP	arg_loop
case_m:
	MOV	STDI.ios_flag,IO_MEMREAD
	JMP	arg_loop
case_o:
	ADD	BX,2
	PUSH	ES
	PUSH	BX
	CALL	strtol
	MOV	WORD PTR arg_offset,AX
	MOV	WORD PTR arg_offset+2,DX
	JMP	arg_loop

init_file:
	CMP	STDI.ios_flag,IO_MEMREAD
	JE	call_tview
	PUSH	WORD PTR arg_file+2
	PUSH	WORD PTR arg_file
	PUSH	0
	CALL	access
	OR	AX,AX
	JZ	call_tview
	PUSH	WORD PTR arg_file+2
	PUSH	WORD PTR arg_file
	CALL	eropen
	XOR	AX,AX
	RET

call_tview:
if USE_MOUSE
	CALL	mouseinit
	CALL	mouseon
endif
	PUSH	WORD PTR arg_file+2
	PUSH	WORD PTR arg_file
	PUSH	WORD PTR arg_offset+2
	PUSH	WORD PTR arg_offset
	CALL	tview
if USE_MOUSE
	CALL	mouseoff
endif
	PUSH	DS
	PUSH	OFFSET searchstring
	PUSH	DS
	PUSH	OFFSET ext_cfg
	CALL	setext
	PUSH	DX
	PUSH	AX
	PUSH	_A_HIDDEN
	PUSH	 M_WRONLY
	PUSH	A_CREATE OR A_TRUNC
	CALL	osopen
	CMP	AX,-1
	JZ	toend
	PUSH	AX
	PUSH	AX
	PUSH	DS
	PUSH	OFFSET tvflag
	PUSH	2
	CALL	oswrite
	CALL	close
toend:
	XOR	AX,AX
	RET

_TEXT	ENDS

	END
