#include <stdio.h>
#include <string.h>

char out[] = "STDIO functions ";
char end[] = "Ok.\n";

char format[] =
"string %%s   'hello'     (%s)\n"
"binary %%b   0xF0        (%b)\n"
"binary %%lb  0xF0F0      (%lb)\n"
"char   %%c   '*'         (%c)\n"
"int    %%d   0xFFFF      (%d)\n"
"int    %%i   0xFFFF      (%i)\n"
"int    %%o   0xFFFF      (%i)\n"
"word   %%u   0xFFFF      (%u)\n"
"long   %%ld  -1L         (%ld)\n"
"dword  %%lu  -1L         (%lu)\n"
"far    %%p   0xFF0F0     (%p)\n"
"hex    %%x   0xABCD      (%x)\n"
"hex    %%lx  0x89ABCDEF  (%lx)\n"
"HEX    %%X   0xABCD      (%X)\n"
"HEX    %%lX  0x89ABCDEF  (%lX)\n"
#ifdef USE_FLOAT
"%e"
"double %%e   3.14   (%e)\n"
"double %%E   3.14   (%E)\n"
"float  %%f   3.14   (%f)\n"
"double %%g   3.14   (%g)\n"
"double %%G   3.14   (%G)\n"
#endif
;

char buf[1024];

int main(void)
{
	FILE *fp;
	long time;
	long count;
	int q;
#ifdef USE_FLOAT
	float  f = 3.14;
	double d = 3.14;
#endif
	puts(out);
	q = sprintf(buf, format, "hello",
	0xF0, 0xF0F0, '*',
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	-1L, -1L,
	0xFF0F0,
	0xABCD,
	0x89ABCDEF,
	0xABCD,
	0x89ABCDEF
#ifdef USE_FLOAT
	, 3.33, d, d, f, d, d
#endif
	);
	_ASSERTE(q != 0x01EA);
	_ASSERTE(puts(buf) < 1);
	_ASSERTE((fp = fopen("stdio.c", "rt")) == NULL);
	_ASSERTE(fseek(fp, 0x0000053A, SEEK_SET) != 0);
	_ASSERTE(fread(buf, 10, 10, fp) != 10);
	_ASSERTE(fclose(fp) != 0);
	_ASSERTE(strncmp(buf, "0x0000053A", 10) != 0);
	puts(end);
	return 0;
}
