include	clib.inc
include	stdio.inc

	.186

	EXTRN DIV32:NEAR

BUFFERSIZE	=	512		; ANSI-specified minimum is 509

FLAG_SIGN	=	0001h     	; put plus or minus in front
FLAG_SIGNSP	=	0002h     	; put space or minus in front
FLAG_LEFT	=	0004h     	; left justify
FLAG_LEADZERO	=	0008h     	; pad with leading zeros
FLAG_LONG       =	0010h     	; long value given
FLAG_SHORT      =	0020h     	; short value given
FLAG_SIGNED	=	0040h     	; signed data given
FLAG_ALTERNATE	=	0080h     	; alternate form requested
FLAG_NEGATIVE	=	0100h     	; value is negative
FLAG_FORCEOCTAL =	0200h     	; force leading '0' for octals

_DATA	SEGMENT

cl_table	DB	 06h, 00h, 00h, 06h, 00h, 01h, 00h, 00h
		DB	 10h, 00h, 03h, 06h, 00h, 06h, 02h, 10h
		DB	 04h, 45h, 45h, 45h, 05h, 05h, 05h, 05h
		DB	 05h, 35h, 30h, 00h, 50h, 00h, 00h, 00h
		DB	 00h, 20h, 28h, 38h, 50h, 58h, 07h, 08h
		DB	 00h, 37h, 30h, 30h, 57h, 50h, 07h, 00h
		DB	 00h, 20h, 20h, 08h, 00h, 00h, 00h, 00h
		DB	 08h, 60h, 60h, 60h, 60h, 60h, 60h, 00h
		DB	 00h, 70h, 78h, 78h, 78h, 78h, 78h, 08h
		DB	 07h, 08h, 00h, 00h, 07h, 00h, 08h, 08h
		DB	 08h, 00h, 00h, 08h, 00h, 08h, 00h, 00h
		DB	 08h

formchar	DB	'bcdefginopsuxEGX'
nullstring	DB	'(null)',0

OPST_table 	DW	OFFSET OPST_normal
		DW	OFFSET OPST_percent
		DW	OFFSET OPST_flag
		DW	OFFSET OPST_width
		DW	OFFSET OPST_dot
		DW	OFFSET OPST_precision
		DW	OFFSET OPST_size
		DW	OFFSET OPST_type

;	public	output_proctab

output_proctab	DW	OUTPUT_b
		DW      OUTPUT_c
		DW      OUTPUT_d
		DW      OUTPUT_dummy
		DW      OUTPUT_dummy
		DW      OUTPUT_dummy
		DW      OUTPUT_d
		DW      OUTPUT_n
		DW      OUTPUT_o
		DW	OUTPUT_p
		DW      OUTPUT_s
		DW      OUTPUT_u
		DW      OUTPUT_x
		DW	OUTPUT_dummy
		DW      OUTPUT_dummy
		DW      OUTPUT_xu

_DATA	ENDS

S_OUTPUT STRUC
	OP_filep	PD ?
	OP_format	PD ?
	OP_charsout 	DW ?
	OP_hexoff	DW ?
	OP_state	DW ?
	OP_curadix	DW ?
	OP_prefix	DB 2 dup(?)
	OP_count	DW ?
	OP_prefixlen	DW ?
	OP_no_output	DW ?
	OP_fldwidth	DW ?
	OP_padding	DW ?
	OP_offtext	DW ?
	OP_segtext	DW ?
	OP_capitalize	DW ?
	OP_number	DD ?
	OP_ddtemp	DD ?
	OP_dwtemp	DW ?
	OP_buffer	DB BUFFERSIZE dup(?)
	OP_STACK	DD ? ; [BP]
ifdef LPROG
	OP_CSIP		DW ?
endif
;	OP_PUSHBP	DW ?
ifdef __CDECL__
	OP_ARGfile	PD ?
	OP_ARGformat	PD ?
	OP_argp		PD ?
else
	OP_argp		PD ?
	OP_ARGformat	PD ?
	OP_ARGfile	PD ?
endif
S_OUTPUT ENDS

PPROC	_output, filep:DPTR, format:DPTR, argp:DPTR
LOCAL	OP[OP_STACK]:BYTE
	PUSH	BP
	LEA	BP,OP
	push	SI
	push	DI
ifdef	LDATA
	MOV32	[BP.OP_format],[BP.OP_ARGformat]
	MOV32	[BP.OP_filep],[BP.OP_ARGfile]
else
	mov	AX,[BP.OP_ARGformat]
	mov	[BP.OP_format],AX
	mov	AX,[BP.OP_ARGfile]
	mov	[BP.OP_filep],AX
endif
	xor	AX,AX
	mov	[BP.OP_count],AX
	mov	[BP.OP_charsout],AX
	mov	[BP.OP_state],AX
SOUTPUT_00:
	MLES	BX,[BP.OP_format]
	inc	WORD PTR [BP.OP_format]
	mov	AL,ES:[BX]
	mov	DL,AL
	or	AL,AL
	jz	SOUTPUT_04
	cmp	[BP.OP_charsout],0
	jl	SOUTPUT_04
	cmp	DL,' '
	jl	SOUTPUT_01
	cmp	DL,'x'
	jle	SOUTPUT_02
SOUTPUT_01:
	xor	AX,AX
	jmp	SOUTPUT_03
SOUTPUT_02:
	mov	AL,DL
	cbw
	mov	BX,AX
	mov	AL,[BX+cl_table-32]
	cbw
	and	AX,15
SOUTPUT_03:
	mov	CX,AX
	mov	BX,AX
	shl	BX,3
	add	BX,[BP.OP_state]
	mov	AL,[BX+cl_table]
	cbw
	sar	AX,4
	mov	[BP.OP_state],AX
	mov	BX,AX
	cmp	AX,7
	ja	SOUTPUT_00
	add	BX,BX
	call	[BX+OPST_table]
	jmp	SOUTPUT_00
SOUTPUT_04:
	mov	AX,[BP.OP_charsout]
	pop	DI
	pop	SI
	pop	BP
	ret
_output	ENDP

OPST_normal	PROC
		mov	AL,DL
OPST_normal	ENDP

OUTPUT_PUTC	PROC
	ifdef	LDATA
		les	BX,[BP.OP_filep]
		dec	ES:[BX.iob_cnt]
		jl	OPPUTC_00
		inc	WORD PTR ES:[BX]
		les	BX,ES:[BX]
		mov	ES:[BX-1],AL
	else
		mov	BX,[BP.OP_filep]
		dec	[BX.iob_cnt]
		jl	OPPUTC_00
		inc	WORD PTR [BX]
		mov	BX,[BX]
		mov	[BX-1],AL
	endif
OPPUTC_01:	inc	[BP.OP_charsout]
		ret
OPPUTC_00:	push	AX
		PUSH32	[BP.OP_filep]
		call	_flsbuf
		cmp	AX,-1
		jne	OPPUTC_01
		mov	[BP.OP_charsout],AX
		ret
OUTPUT_PUTC	ENDP

OUTPUT_GETW	PROC	NEAR	; Get WORD from stack
		lea	BX,[BP.OP_argp]
	ifdef	LDATA
		mov	AX,SS:[BX+2]
		add	WORD PTR SS:[BX],2
		mov	BX,SS:[BX]
		mov	ES,AX
		mov	AX,ES:[BX-2]
	else
		add	WORD PTR [BX],2
		mov	BX,[BX]
		mov	AX,[BX-2]
	endif
		ret
OUTPUT_GETW	ENDP

OUTPUT_GETD	PROC	NEAR	; Get DWORD from stack
		lea	BX,[BP.OP_argp]
	ifdef	LDATA
		mov	AX,SS:[BX+2]
		add	WORD PTR SS:[BX],4
		mov	BX,SS:[BX]
		mov	ES,AX
		mov	AX,ES:[BX-4]
		mov	DX,ES:[BX-2]
	else
		add	WORD PTR [BX],4
		mov	BX,[BX]
		mov	AX,[BX-4]
		mov	DX,[BX-2]
	endif
		ret
OUTPUT_GETD	ENDP

OPST_percent	PROC	NEAR
		xor	AX,AX
		mov	[BP.OP_no_output],AX
		mov	[BP.OP_fldwidth],AX
		mov	[BP.OP_prefixlen],AX
		mov	[BP.OP_capitalize],AX
		xor	SI,SI	; bufferiswide (default)
		mov	DI,-1   ; precision
		ret
OPST_percent	ENDP

OPST_flag	PROC	NEAR
		mov	AL,DL
		cbw
		cmp	AL,'+'
		je	STFL_0001
		jg	STFL_00
		cmp	AL,' '
		je	STFL_0002
		cmp	AL,'#'
		je	STFL_0080
		ret
STFL_00:	cmp	AL,'-'
		je	STFL_0004
		cmp	AL,'0'
		je	STFL_0008
		ret
STFL_0001:	or	SI,FLAG_SIGN            ; '+' force sign indicator
		ret
STFL_0002:	or	SI,FLAG_SIGNSP          ; ' ' force sign or space
		ret
STFL_0004:	or	SI,FLAG_LEFT		; '-' left justify
		ret
STFL_0008:	or	SI,FLAG_LEADZERO	; '0' pad with leading zeros
		ret
STFL_0080:	or	SI,FLAG_ALTERNATE	; '#' alternate form
		ret
OPST_flag	ENDP

OPST_width	PROC	NEAR
		cmp	DL,'*'
		jne	STWIDTH_01
		call	OUTPUT_GETW
		mov	[BP.OP_fldwidth],AX
		cmp	AX,0000h
		jnl	STWIDTH_00
		or	SI,4
		neg	AX
		mov	[BP.OP_fldwidth],AX
STWIDTH_00:	ret
STWIDTH_01:	mov	AL,DL
		cbw
		push	AX
		mov	AX,[BP.OP_fldwidth]
		mov	DX,10
		imul	DX
		pop	DX
		add	DX,AX
		add	DX,-48
		mov	[BP.OP_fldwidth],DX
		ret
OPST_width	ENDP

OPST_dot	PROC	NEAR
		xor	DI,DI
		ret
OPST_dot	ENDP

OPST_precision	PROC	NEAR
		cmp	DL,'*'
		jnz	STPRES_01
		call	OUTPUT_GETW
		mov	DI,AX
		or	AX,AX
		jnl	STPRES_00
		mov	DI,-1
STPRES_00:	ret
STPRES_01:	mov	AL,DL
		cbw
		push	AX
		mov	AX,DI
		mov	DX,10
		imul	DX
		pop	DX
		add	DX,AX
		add	DX,-48
		mov	DI,DX
		ret
OPST_precision	ENDP

OPST_size	PROC	NEAR
		cmp	DL,'l'
		jne	STSIZE_00
		or	SI,FLAG_LONG
STSIZE_00:	ret
OPST_size	ENDP

OPST_type	PROC	NEAR
		xor	BX,BX
		mov	CX,16
STTYPE_00:	cmp	DL,[BX+formchar]
		je	STTYPE_01
		inc	BX
		dec	CX
		jnz	STTYPE_00
		jmp	STTYPE_02
STTYPE_01:	add	BX,BX
		call	[BX+output_proctab]
STTYPE_02:	call	OUTPUT
		ret
OPST_type	ENDP

OUTPUT_b	PROC	NEAR
		push	SI
		call	OUTPUT_GETW
		test	SI,FLAG_LONG
		mov	SI,16
		jnz	OUTPB_00
		mov	SI,8
OUTPB_00:	mov	[BP.OP_count],SI
OUTPB_01:	mov	DX,AX
		xor	CX,CX
OUTPB_02:	mov	AX,DX
		shr	AX,CL
		and	AX,1
		add	AX,48
		mov	[BP.OP_buffer+SI-1],AL
		inc	CX
		dec	SI
		jnz	OUTPB_02
		pop	SI
		jmp	OUTPUT_LDTEXT
OUTPUT_b	ENDP

OUTPUT_c	PROC	NEAR
		call	OUTPUT_GETW
		mov	DX,AX
		mov	[BP.OP_buffer],DL
		mov	[BP.OP_count],1
OUTPUT_c	ENDP

OUTPUT_LDTEXT	PROC	NEAR
		lea	AX,[BP.OP_buffer]
		mov	[BP.OP_segtext],SS
		mov	[BP.OP_offtext],AX
		ret
OUTPUT_LDTEXT	ENDP

OUTPUT_s	PROC	NEAR
		cmp	DI,-1
		jnz	OUTPS_00
		mov	CX,7FFFh
		jmp	OUTPS_01
OUTPS_00:	mov	CX,DI
OUTPS_01:
	ifdef	LDATA
		call	OUTPUT_GETD
		mov	[BP.OP_segtext],DX
	else
		xor	AX,AX
		mov	[BP.OP_segtext],AX
		call	OUTPUT_GETW
		or	AX,AX
		jz	OUTPS_NULL
		mov	[BP.OP_segtext],DS
	endif
		mov	[BP.OP_offtext],AX
		or	AX,DX
		jnz	OUTPS_02
OUTPS_NULL:	mov	[BP.OP_segtext],DS
		mov	[BP.OP_offtext],OFFSET nullstring
OUTPS_02:	les	BX,DWORD PTR [BP.OP_offtext]
OUTPS_03:	cmp	BYTE PTR ES:[BX],0
		jz	OUTPS_04
		inc	BX
		dec	CX
		jnz	OUTPS_03
OUTPS_04:	sub	BX,[BP.OP_offtext]
		mov	[BP.OP_count],BX
		ret
OUTPUT_s	ENDP

OUTPUT_n	PROC	NEAR
	ifdef	LDATA
		call	OUTPUT_GETD
		mov	ES,DX
		mov	BX,AX
		test	SI,FLAG_LONG
		jnz	OUTPN_00
		mov	AX,[BP.OP_charsout]
		mov	ES:[BX],AX
		ret
OUTPN_00:	mov	AX,[BP.OP_charsout]
		mov	ES:[BX],AX
		mov	WORD PTR ES:[BX+2],0
	else
		call	OUTPUT_GETW
		mov	BX,AX
		test	SI,FLAG_LONG
		jnz	OUTPN_00
		mov	AX,[BP.OP_charsout]
		mov	[BX],AX
		jmp	OUTPUT
OUTPN_00:	mov	AX,[BP.OP_charsout]
		mov	[BX],AX
		mov	WORD PTR [BX+2],0
	endif
		mov	[BP.OP_no_output],1
		ret
OUTPUT_n	ENDP

OUTPUT_p	PROC	NEAR
		mov	DI,8
		or	SI,FLAG_LONG
OUTPUT_p	ENDP

OUTPUT_xu	PROC	NEAR
		mov	[BP.OP_hexoff],'A'-'9'-1
		jmp	OPCOMMONHEX
OUTPUT_xu	ENDP

OUTPUT_x	PROC	NEAR
		mov	[BP.OP_hexoff],'a'-'9'-1
OUTPUT_x	ENDP

OPCOMMONHEX	PROC	NEAR
		mov	[BP.OP_curadix],16
		test	SI,FLAG_ALTERNATE
		jz	OPCOMM_00
		mov	[BP.OP_prefix],'0'
		mov	[BP.OP_prefix+1],'x'
		mov	[BP.OP_prefixlen],2
OPCOMM_00:	test	SI,FLAG_LONG
		jnz	OUTPUT_LONGINT
		cmp	[BP.OP_fldwidth],2
		jne	OUTPUT_SHORTINT
		call	OUTPUT_GETW
		mov	AH,0
		jmp	OUTPUT_UNSIGNED
OPCOMMONHEX	ENDP

OUTPUT_o	PROC	NEAR
		mov	[BP.OP_curadix],8
		test	SI,FLAG_ALTERNATE
		jz	OUTPUT_GENINT
		or	SI,FLAG_FORCEOCTAL
		jmp	OUTPUT_GENINT
OUTPUT_o	ENDP

OUTPUT_d	PROC	NEAR
		or	SI,FLAG_SIGNED
OUTPUT_d	ENDP

OUTPUT_u	PROC	NEAR
		mov	[BP.OP_curadix],10
OUTPUT_u	ENDP

OUTPUT_GENINT	PROC	NEAR
		test	SI,FLAG_LONG
		jz	OUTPUT_SHORTINT
OUTPUT_GENINT	ENDP

OUTPUT_LONGINT	PROC	NEAR
		call	OUTPUT_GETD
		jmp	OUTPUT_NUMBER
OUTPUT_LONGINT	ENDP

OUTPUT_SHORTINT	PROC	NEAR
		call	OUTPUT_GETW
		test	SI,FLAG_SIGNED
		jz	OUTPUT_UNSIGNED
		CWD
		jmp	OUTPUT_NUMBER
OUTPUT_SHORTINT	ENDP

OUTPUT_UNSIGNED	PROC	NEAR
		XOR	DX,DX
OUTPUT_UNSIGNED	ENDP

OUTPUT_NUMBER	PROC	NEAR
		mov	WORD PTR [BP.OP_ddtemp],AX
		mov	WORD PTR [BP.OP_ddtemp+2],DX
		test	SI,FLAG_SIGNED
		jz	OPNUM_00
		or	DX,DX
		jns	OPNUM_00
		neg	AX
		neg	DX
		sbb	DX,0
		or	SI,FLAG_NEGATIVE
OPNUM_00:	mov	WORD PTR [BP.OP_number],AX
		mov	WORD PTR [BP.OP_number+2],DX
		or	DI,DI
		jnl	OPNUM_01
		mov	DI,1
		jmp	OPNUM_02
OPNUM_01:	and	SI,-9
OPNUM_02:	or	AX,AX
		jnz	OPNUM_03
		or	DX,DX
		jnz	OPNUM_03
		mov	[BP.OP_prefixlen],AX
OPNUM_03:	lea	AX,[BP.OP_buffer+512-1]
		mov	[BP.OP_segtext],SS
		mov	[BP.OP_offtext],AX
		jmp	OPNUM_06
OPNUM_04:	XOR	CX,CX
		mov	BX,[BP.OP_curadix]
		mov	AX,WORD PTR [BP.OP_number]
		mov	DX,WORD PTR [BP.OP_number+2]
		CALL	DIV32
		mov	WORD PTR [BP.OP_number],AX
		mov	WORD PTR [BP.OP_number+2],DX
		add	BX,'0'
		mov	CX,BX
		cmp	CX,'9'
		jng	OPNUM_05
		add	CX,[BP.OP_hexoff]
OPNUM_05:	les	BX,DWORD PTR [BP.OP_offtext]
		mov	ES:[BX],CL
		dec	[BP.OP_offtext]
OPNUM_06:	mov	CX,DI
		dec	DI
		or	CX,CX
		jg	OPNUM_04
		OR	AX,DX
		jnz	OPNUM_04
		lea	AX,[BP.OP_buffer+512-1]
		sub	AX,[BP.OP_offtext]
		mov	[BP.OP_count],AX
		inc	[BP.OP_offtext]
		test	SI,FLAG_FORCEOCTAL
		jz	OUTPUT_dummy
		les	BX,DWORD PTR [BP.OP_offtext]
		cmp	BYTE PTR ES:[BX],'0'
		jne	OPNUM_07
		cmp	[BP.OP_count],0
		jne	OUTPUT_dummy
OPNUM_07:	dec	BX
		mov	[BP.OP_offtext],BX
		mov	BYTE PTR ES:[BX],'0'
		inc	[BP.OP_count]
OUTPUT_NUMBER	ENDP

OUTPUT_dummy	PROC	NEAR
		ret
OUTPUT_dummy	ENDP

OUTPUT_MULTI	PROC	NEAR
		push	SI
		push	DI
		xor	AH,AH
		mov	SI,AX
		mov	DI,DX
		jmp	OPMULTI_01
OPMULTI_00:	mov	AX,SI
		call	OUTPUT_PUTC
		cmp	[BP.OP_charsout],-1
		je	OPMULTI_02
OPMULTI_01:	mov	AX,DI
		dec	DI
		or	AX,AX
		jg	OPMULTI_00
OPMULTI_02:	pop	DI
		pop	SI
		ret
OUTPUT_MULTI	ENDP

OUTPUT_STRING	PROC	NEAR
		push	DI
		push	SI
		mov	SI,CX
		mov	DI,AX
		mov	BX,DX
		jmp	OPSTR_01
OPSTR_00:	mov	ES,DI
		mov	AL,ES:[BX]
		inc	BX
		push	BX
		cbw
		call	OUTPUT_PUTC
		pop	BX
		cmp	[BP.OP_charsout],-1
		jz	OPSTR_02
OPSTR_01:	mov	AX,SI
		dec	SI
		or	AX,AX
		jg	OPSTR_00
OPSTR_02:	pop	SI
		pop	DI
		ret
OUTPUT_STRING	ENDP

OUTPUT		PROC	NEAR
		xor	AX,AX
		cmp	AX,[BP.OP_no_output]
		je	OUTPUT_00
		ret
OUTPUT_00:	test	SI,FLAG_SIGNED
		jz	OUTPUT_03
		test	SI,FLAG_NEGATIVE
		jz	OUTPUT_01
		mov	[BP.OP_prefix],'-'
		mov	[BP.OP_prefixlen],1
		jmp	OUTPUT_03
OUTPUT_01:	test	SI,FLAG_SIGN
		jz	OUTPUT_02
		mov	[BP.OP_prefix],43
		mov	[BP.OP_prefixlen],1
		jmp	OUTPUT_03
OUTPUT_02:	test	SI,FLAG_SIGNSP
		jz	OUTPUT_03
		mov	[BP.OP_prefix],' '
		mov	[BP.OP_prefixlen],1
OUTPUT_03:	mov	AX,[BP.OP_fldwidth]
		sub	AX,[BP.OP_count]
		sub	AX,[BP.OP_prefixlen]
		mov	[BP.OP_padding],AX
		test	SI,FLAG_LEFT or FLAG_LEADZERO
		jnz	OUTPUT_04
		mov	DX,AX
		mov	AX,' '
		call	OUTPUT_MULTI
OUTPUT_04:	mov	AX,SS
		lea	DX,[BP.OP_prefix]
		mov	CX,[BP.OP_prefixlen]
		call	OUTPUT_STRING
		test	SI,FLAG_LEADZERO
		jz	OUTPUT_05
		test	SI,FLAG_LEFT
		jnz	OUTPUT_05
		mov	AX,'0'
		mov	DX,[BP.OP_padding]
		call	OUTPUT_MULTI
OUTPUT_05:	cmp	[BP.OP_count],0
		jng	OUTPUT_08
		MOV32	[BP.OP_ddtemp],[BP.OP_offtext]
		;mov	EAX,DWORD PTR [BP.OP_offtext]
		;mov	[BP.OP_ddtemp],EAX
		mov	AX,[BP.OP_count]
		mov	[BP.OP_dwtemp],AX
		jmp	OUTPUT_07
OUTPUT_06:	les	BX,[BP.OP_ddtemp]
		inc	WORD PTR [BP.OP_ddtemp]
		mov	AL,ES:[BX]
		cbw
		call	OUTPUT_PUTC
OUTPUT_07:	mov	AX,[BP.OP_dwtemp]
		dec	[BP.OP_dwtemp]
		or	AX,AX
		jg	OUTPUT_06
		jmp	OUTPUT_09
OUTPUT_08:	mov	DX,[BP.OP_offtext]
		mov	AX,[BP.OP_count]
		mov	CX,AX
		call	OUTPUT_STRING
OUTPUT_09:	test	SI,FLAG_LEFT
		jz	OUTPUT_10
		mov	AX,' '
		mov	DX,[BP.OP_padding]
		call	OUTPUT_MULTI
OUTPUT_10:	ret
OUTPUT		ENDP

_TEXT	ENDS

	END
