;
; _int9.asm
;
; void Install_09(void); - install new int 09
; void Restore_09(void); - restore vector
;

include		clib.inc

		locals

_TEXT		segment

		public	keycode
		public	keypres

OFFSETVECTOR	= 	0024h	; (9 * 4)

keycode		DB	00h
keypres		DB	00h
oldint9		DD	00000000h

Interrupt_09:	push	ax
		push	cx

		cli			; no interrupts
		xor	cx,cx		; wait until the keyboard is ready..
@@wait:		in      al,64h
		test	al,2
		loopnz	short @@wait

		in      al,60h		; get the key..
		sti                     ; allow interrupts again
		mov     ah,1            ; assume key on
		or      al,al           ; high bit set = release code
		jns     short @@release
		xor     ah,ah
@@release:      mov	cs:[keycode],al	; update keycode
		or      cs:[keypres],ah	; update keypres

		pop	cx
		pop	ax
		jmp	DWORD PTR cs:[oldint9]

		.386p

Install_09:	xor	ax,ax
		mov	es,ax
		mov     ax,cs
		shl	eax,16
		mov	ax,offset Interrupt_09
		cli
		xchg    eax,es:[OFFSETVECTOR]
		sti
		mov     cs:[oldint9],eax		; save old handler.
		ret

Restore_09:	xor	ax,ax
		mov	es,ax
		mov     ax,cs
		shl	eax,16
		mov	ax,OFFSET Interrupt_09
		cmp	eax,es:[OFFSETVECTOR]
		jnz	short NotInstalled
		mov	eax,cs:[oldint9]
		cli
		mov	es:[OFFSETVECTOR],eax          ; restore handler.
		sti
NotInstalled:	ret

_TEXT		ENDS

INITPROC	Install_09, 0, 17
EXITPROC	Restore_09, 0, 17

		END
