/*
 * MAIN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <bios.h>
#include <errno.h>
#include <string.h>
#include <dzmain.h>

extern char cp_termination[];
extern char cp_system_error[];
extern char cp_termination_type[4][64];
extern char cp_ercomspec[];

char default_comspec[] = "COMMAND";
/*
 * numfblock - max fileblock in each panel set
 * to MINFBLOCK if the /t argument is given
 */
int numfblock = MAXFBLOCK;
int dzexitcode  = 0;

int argv_verbose;
char *argv_cfgpath;
char *argv_filename;

void init_screen(void);
void init_tools(void);
void dzmain(void);
void apiclose(void);

static int verbose(void)
{
	if (!dzcount || !argv_verbose)
		return 1;
	if (dzerflag || dzerrno) {
		printfs(cp_termination, dzexe->name,
			cp_termination_type[(dzerflag >> 8) & 3],
			(BYTE)(dzerflag));
	}
	if (dzerrno) {
		printfs(cp_system_error);
		switch (dzerrno) {
		case 2: /* ER_FILE_NOT_FOUND */
			printfs(sys_errlist[ENOENT]);
			break;
		case 5: /* ER_ACCESS_DENIED */
			printfs(sys_errlist[EACCES]);
			break;
		case 8: /* ER_NOT_ENOUGH_MEMORY */
			printfs(sys_errlist[ENOMEM]);
			break;
		case 1: /* ER_INVALID_FUNCTION */
		case 10:/* ER_BAD_ENVIRONMENT */
		case 11:/* ER_BAD_FORMAT */
			printfs(sys_errlist[ENOEXEC]);
			break;
		default:/* Unknown error */
			printfs(sys_errlist[ENOTBLK]);
			break;
		}
	}
	return 1;
}

static int init_args(void)
{
	int args;

	if (_argc == 1)
		return 1;
	for (args = 1; args < _argc; args++) {
		switch (_argv[args][0]) {
		case '?':
			printfs(_bufin);
			return 0;
		case '/':
		case '-':
			switch (_argv[args][1] | 0x20) {
			case 'x':
				if (dzcount == 0)
					bios_settextmode();
				break;
			case 'v':
				argv_verbose = 1;
				break;
			case 't':
				numfblock = 500;
				break;
			case 'l':
				numfblock = 5000;
				break;
			case 'c':
				argv_cfgpath = &_argv[args][2];
				break;
			default:
				printfs(_bufin);
				return 0;
			}
			break;
		default:
			argv_filename = _argv[args];
			break;
		}
	}
	return verbose();
}

void delete_tempfile(const char *name)
{
	char b[WMAXPATH];

	strfcat(b, envtemp, name);
	setfattr(b, 0);
	remove(b);
}

int main(void)
{
	//_ifsmgr = 0;
	if (init_args() == 0)
		return 0;
	config_init();
	wspanel[0].maxfb = numfblock;
	wspanel[1].maxfb = numfblock;
	if (comspec == NULL) {
		printfs(cp_ercomspec);
		comspec = default_comspec;
	}
	config_read();
	set_confirmflag();
	if (config.pending_file[0]) {
		setfattr(config.pending_file, 0);
		remove(config.pending_file);
		config.pending_file[0] = 0;
	}
	if (cflag & _C_DELZIPLST)
		delete_tempfile(cp_ziplst);
	if ((cflag & _C_SAVEDZCMD) == 0)
		delete_tempfile(cp_dzcmd);
	cflag &= ~_C_DELZIPLST;
	init_panels();
	init_screen();
	init_tools();
	mouseon();
	if (open_panels())
		dzmain();
	config.console = console;
	config.idb[0] = panela.fcb_index;
	config.idx[0] = panela.cel_index;
	config.idb[1] = panelb.fcb_index;
	config.idx[1] = panelb.cel_index;
	if (cflag & _C_AUTOSAVE)
		config_write();
	panel_close(&panela);
	panel_close(&panelb);
	apiclose();
	gotoxy(0, *__egaline);
	if (dzexitcode != 23 &&	(cflag & _C_SAVEDZCMD) == 0)
		doskey_delete();
	return dzexitcode;
}