; DZIP.ASM--
; Copyright (c) 2008 Hjort Nidudsson

include		clib.inc
include		dzip.inc
include		string.inc
include		errno.inc
include		io.inc
include		version.inc
include		progress.inc
include		dzmain.inc
include		tdialog.inc
include		alloc.inc

GLOBAL PASCAL cp_emaxfb: BYTE

DZIPID		= 5A44h		; 'DZ' - two-byte dzip signature

_DZENCRYPTED	= 0200h
_DZCENTRALID	= 4000h
_DZLOCALID	= 8000h

DZIPL		STRUC		; Local file header
		dzl_ID		DW ?
		dzl_magic	DW ?	; 4 byte
		ENDS

DZIPC		STRUC		; Central directory file header
		dz_signature	DW ?
		dz_flag		DW ?
		dz_time		DW ?
		dz_date		DW ?
		dz_size		DD ?
		dz_name		DW ?	; size of file name
		dz_offset	DD ?
		dz_csize	DD ?
		dz_crc		DD ?	; 26 byte
		ENDS

DZIPE		STRUC		; End of central directory record
		dze_signature	DW ?
		dze_version	DW ?
		dze_fcount	DD ?	; files in central directory
		dze_offset	DD ?	; offset to start c-directory
		ENDS

BFREQ		STRUC
		bf_count	DW ?	; frequency or bit-sequnce
		bf_length	DB ?    ; length of bit-sequnce
		bf_byte		DB ?    ; char
		ENDS

SSLOCAL		STRUC
		ss_srcfile	DB WMAXPATH dup(?)
		ss_endcent	DZIPE <?>
		ss_central	DZIPC <?>
		ss_dzlocal	DZIPL <?>
		ss_offendc	DD ?
		ss_fbname	DD ?
		ss_lcoffs	DD ?
		ss_lcsize	DD ?
		ENDS

DZIP_TEXT	SEGMENT USE16 BYTE PUBLIC 'CODE'
		ASSUME CS:DZIP_TEXT, DS:DGROUP

;***************************************************************************
; Local stack

dzip_proc	PROC	PASCAL
LOCAL           srcfile:BYTE:[WMAXPATH],\
		EndCent:DZIPE,\		; End Central record
		Central:DZIPC,\		; Central record
		DZLocal:DZIPL,\		; Local record
		offendc:DWORD,\		; Offset End Central
		fbname:	DWORD,\		; FBLK.name
		lcoffs:	DWORD,\		; Local offset in archive
		lcsize:	DWORD		; Local size = compressed size
dzip_proc	ENDP

;***************************************************************************
; __outfile:	Archive name
; __outpath:	Path in archive

AllocError:	push	eax		; Insufficient memory
		push	EMNOMEM
		push	(ER_MEM-1)
		jmp	SHORT ErrorMSG

FileNotFound:	push	dx		; No such file or directory
		push	cx
		push	EMNOENT
		push	(ER_FIND-1)
		jmp	SHORT ErrorMSG

ArchiveError:	push	ds		; Error in archive
		push	OFFSET __outfile
		push	EMARCHIVE
		push	(ER_ZIP-1)
		jmp	SHORT ErrorMSG

ErrorOpen:	push	dx		; Error open file
		push	cx
		push	EMEROPEN
		push	(ER_OPEN-1)

ErrorMSG:	call    stderror
		inc	ax
		ret

		;***********************************************************

OpenSTDI:	push	dx	; DX:AX = filename
		push	ax	; SS:[srcfile] - Compress
		push	dx	; DS:__outfile - Archive
		push	ax
		push	_A_ARCH
		push	M_RDONLY
		push	A_OPEN
		call	osopen
		pop	cx
		pop	dx
		mov	bx,OSTDI
		mov	[bx.ios_file],ax
		cmp	ax,-1
		je	SHORT ErrorOpen
		xor	ax,ax
@@toend:	ret		; return 0 (or ER_OPEN)

; Open archive and read End Central Directory

OpenArchive:	push	OSTDI
		call	oinitst
		jz	SHORT AllocError
		mov	dx,ds
		mov	ax,OFFSET __outfile
		call	OpenSTDI
		jnz	SHORT @@er_nozip
		xor	eax,eax
		sub	eax,SIZE DZIPE
		push	eax
		push	SEEK_END
		call	oseek
		jz	SHORT @@er_zip
		mov	eax,_ios.ios_offs
		mov	offendc,eax
		push	ss
		lea	ax,EndCent
		push	ax
		push	SIZE DZIPE
		call	oread
		cmp	ax,SIZE DZIPE
		jne     SHORT @@er_zip
		cmp	EndCent.dze_signature,DZIPID
		jne     SHORT @@er_zip
		cmp	EndCent.dze_version,DZIP_VERSION
		jne     SHORT @@er_zip
		xor	ax,ax
@@toend:	ret
@@er_nozip:	push	OSTDI
		call	ofreest
		mov	ax,(ER_NOZIP-1)
		inc	ax
		ret
@@er_zip:	push	OSTDI
		call	oclose
		call	ArchiveError
		ret

CLOSE_STDI:	push	OSTDI
		call	oclose
		xor	ax,ax
		ret

		;***********************************************************

SEEK_Error:     call	CLOSE_STDI	; close archive file
		call	ArchiveError
		ret

FIND_FIRST:	call	OpenArchive
		jz	SHORT READ_FIRST
		ret

READ_FIRST:	push	EndCent.dze_offset
		push	SEEK_SET
		call	oseek
		jz	SHORT SEEK_Error
		call	FIND_NEXT
		jz	SHORT @@close
		xor	ax,ax
		ret
@@close:	call	CLOSE_STDI	; close archive file
		add	ax,ER_FIND      ; return error
		ret

FIND_NEXT:	push	ss
		lea	ax,Central
		push	ax
		push	SIZE DZIPC
		call	oread
		cmp	ax,SIZE DZIPC
		jne	SHORT @@null
		cmp	Central.dz_signature,DZIPID
		jne	SHORT @@null
		mov	ax,Central.dz_flag
		and	ax,_DZCENTRALID
		jz	SHORT @@null
		push	ds
		push	OFFSET entryname
		push	Central.dz_name
		call	oread
		cmp	ax,Central.dz_name
		jne	SHORT @@null
		xor	ax,ax
		mov	bx,Central.dz_name
		mov	entryname[bx],al
		push	ds
		push	OFFSET entryname
		call	unixtodos
		xor	ax,ax
		inc	ax
		ret
@@null:		xor	ax,ax
		ret

;***************************************************************************
; Read archive into WSUB

WS_OUTFILE:	push	ds		; ES:BX = WSUB
		push	OFFSET __outfile
		push	es:[bx.ws_path]
		push	es:[bx.ws_file]
		call	strfcat
		ret

WS_OUTPATH:	les	bx,es:[bx.ws_arch]
		xor	al,al		; Path in Archive to __outpath
		cmp	es:[bx],al
		mov	__outpath,al
		jz	SHORT @@toend
		push	ds
		push	OFFSET __outpath
		push	es
		push	bx
		call	strcpy
@@toend:	ret

dzipread	PROC	PASCAL DIST
ARG		@@ws:	DWORD
LOCAL		@@ss:	SSLOCAL

		push	@@ws
		call	wsfree
		les	bx,@@ws
		call	WS_OUTFILE
		les	bx,@@ws
		call	WS_OUTPATH
		call	OpenArchive
		jnz	SHORT @@er_read

		push	_A_DZIP
		call	fbupdir
		les	bx,@@ws
		inc	es:[bx.ws_count]
		les	bx,es:[bx.ws_fcb]
		mov	es:[bx],ax
		mov	es:[bx+2],dx
		call	READ_FIRST
		jnz	SHORT @@nofiles
		jmp	SHORT @@AddEntry

@@er_read:	mov	ax,ER_READARCH
		jmp	SHORT @@toend

@@AddEntry:	push	@@ws
		mov	ax,Central.dz_flag
		and	ax,_A_FATTRIB
		or	ax,_A_DZIP
		push	ax
		push	Central.dz_time
		push	Central.dz_date
		push	Central.dz_size
		call	wsaddentry
		or	ax,ax
		jz	SHORT @@continue
		push	dx
		push	ax
		push	dx
		add	ax,fb_name
		push	ax
		call	strlen
		pop	bx
		pop	es
		add	ax,SIZE S_FBLK
		add	bx,ax
		mov	eax,Central.dz_offset
		mov	es:[bx],eax
		mov	eax,Central.dz_crc
		mov	es:[bx.4],eax
		mov	eax,Central.dz_csize
		mov	es:[bx.8],eax
		les	bx,@@ws
		mov	ax,es:[bx.ws_maxfb]
		inc	es:[bx.ws_count]
		cmp	es:[bx.ws_count],ax
		jae	SHORT @@break
@@continue:	call	FIND_NEXT
		jnz	SHORT @@AddEntry
@@break:	call	CLOSE_STDI
@@nofiles:	les	bx,@@ws
		mov	ax,es:[bx.ws_count]
@@toend:	ret
dzipread	ENDP

DZIP_TEXT	ENDS

		END
